/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class ELFDumpReaderFactory
implements ICoreFileReader {
    @Override
    public ICore processDump(String path) throws InvalidDumpFormatException, IOException {
        return ELFDumpReader.getELFDumpReader(new File(path));
    }

    @Override
    public ICore processDump(ImageInputStream in) throws InvalidDumpFormatException, IOException {
        return ELFDumpReader.getELFDumpReader(in);
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String path) throws IOException {
        if (!new File(path).exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        return ELFFileReader.isELF(CoreReader.getFileHeader(path)) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream in) throws IOException {
        return ELFFileReader.isELF(CoreReader.getFileHeader(in)) ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
    }
}

