/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl.toJavaPortable;

import com.ibm.idl.AttributeEntry;
import com.ibm.idl.ConstEntry;
import com.ibm.idl.GenFileStream;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.InterfaceState;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.toJavaPortable.Arguments;
import com.ibm.idl.toJavaPortable.Compile;
import com.ibm.idl.toJavaPortable.Factories;
import com.ibm.idl.toJavaPortable.JavaGenerator;
import com.ibm.idl.toJavaPortable.MethodGen;
import com.ibm.idl.toJavaPortable.TCOffsets;
import com.ibm.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueGen
implements com.ibm.idl.ValueGen,
JavaGenerator {
    protected int emit = 0;
    protected Factories factories = null;
    protected Hashtable symbolTable = null;
    protected ValueEntry v = null;
    protected PrintWriter stream = null;
    protected boolean explicitDefaultInit = false;

    @Override
    public void generate(Hashtable hashtable, ValueEntry valueEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.v = valueEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateTie();
        this.generateHelper();
        this.generateHolder();
        if (!valueEntry.isAbstract()) {
            this.generateValueFactory();
            this.generateDefaultFactory();
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.emit = ((Arguments)Compile.compiler.arguments).emit;
        this.factories = (Factories)Compile.compiler.factories();
    }

    protected void openStream() {
        this.stream = Util.stream(this.v, ".java");
    }

    protected void generateTie() {
        boolean bl = ((Arguments)Compile.compiler.arguments).TIEServer;
        if (this.v.supports().size() > 0 && bl) {
            Factories factories = (Factories)Compile.compiler.factories();
            factories.skeleton().generate(this.symbolTable, this.v);
        }
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.v);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.v);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.v);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.v.comment() != null) {
            this.v.comment().generate("", this.stream);
        }
        if (this.v.isAbstract()) {
            this.writeAbstract();
            return;
        }
        this.stream.print("public abstract class " + this.v.name());
        SymtabEntry symtabEntry = (SymtabEntry)this.v.derivedFrom().elementAt(0);
        String string = Util.javaName(symtabEntry);
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("java.io.Serializable") || ((ValueEntry)symtabEntry).isAbstract()) {
            if (this.v.isCustom()) {
                this.stream.print(" implements org.omg.CORBA.portable.CustomValue");
                bl2 = true;
            } else {
                this.stream.print(" implements org.omg.CORBA.portable.StreamableValue");
            }
            bl = true;
        } else if (!((ValueEntry)symtabEntry).isAbstract()) {
            this.stream.print(" extends " + string);
        }
        for (int i = 0; i < this.v.derivedFrom().size(); ++i) {
            symtabEntry = (SymtabEntry)this.v.derivedFrom().elementAt(i);
            if (!((ValueEntry)symtabEntry).isAbstract()) continue;
            if (!bl) {
                this.stream.print(" implements ");
                bl = true;
            } else {
                this.stream.print(", ");
            }
            this.stream.print(Util.javaName(symtabEntry));
        }
        if (this.v.supports().size() > 0) {
            if (!bl) {
                this.stream.print(" implements ");
                bl = true;
            } else {
                this.stream.print(", ");
            }
            InterfaceEntry interfaceEntry = (InterfaceEntry)this.v.supports().elementAt(0);
            if (interfaceEntry.isAbstract()) {
                this.stream.print(Util.javaName(interfaceEntry));
            } else {
                this.stream.print(Util.javaName(interfaceEntry) + "Operations");
            }
        }
        if (this.v.isCustom() && !bl2) {
            if (!bl) {
                this.stream.print(" implements ");
                bl = true;
            } else {
                this.stream.print(", ");
            }
            this.stream.print("org.omg.CORBA.portable.CustomValue ");
        }
        this.stream.println();
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeMembers();
        this.writeInitializers();
        this.writeConstructor();
        this.writeTruncatable();
        this.writeMethods();
    }

    protected void writeClosing() {
        if (this.v.isAbstract()) {
            this.stream.println("} // interface " + this.v.name());
        } else {
            this.stream.println("} // class " + this.v.name());
        }
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeConstructor() {
    }

    protected void writeTruncatable() {
        if (!this.v.isAbstract()) {
            this.stream.println("  private static String[] _truncatable_ids = {");
            this.stream.print("    " + Util.helperName(this.v, true) + ".id ()");
            ValueEntry valueEntry = this.v;
            while (valueEntry.isSafe()) {
                this.stream.println(",");
                ValueEntry valueEntry2 = (ValueEntry)valueEntry.derivedFrom().elementAt(0);
                this.stream.print("    \"" + Util.stripLeadingUnderscoresFromID(valueEntry2.repositoryID().ID()) + "\"");
                valueEntry = valueEntry2;
            }
            this.stream.println();
            this.stream.println("  };");
            this.stream.println();
            this.stream.println("  public String[] _truncatable_ids() {");
            this.stream.println("    return _truncatable_ids;");
            this.stream.println("  }");
            this.stream.println();
        }
    }

    protected void writeMembers() {
        if (this.v.state() == null) {
            return;
        }
        for (int i = 0; i < this.v.state().size(); ++i) {
            InterfaceState interfaceState = (InterfaceState)this.v.state().elementAt(i);
            TypedefEntry typedefEntry = interfaceState.entry;
            Util.fillInfo(typedefEntry);
            if (typedefEntry.comment() != null) {
                typedefEntry.comment().generate(" ", this.stream);
            }
            String string = "  ";
            string = interfaceState.modifier == 2 ? "  public " : "  protected ";
            Util.writeInitializer(string, typedefEntry.name(), "", typedefEntry, this.stream);
        }
        this.stream.println();
    }

    protected void writeInitializers() {
    }

    protected void writeMethods() {
        Object object;
        SymtabEntry symtabEntry;
        Enumeration enumeration = this.v.contained().elements();
        while (enumeration.hasMoreElements()) {
            symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof AttributeEntry) {
                object = (AttributeEntry)symtabEntry;
                if (this.v.isAbstract()) {
                    ((MethodGen)((AttributeEntry)object).generator()).interfaceMethod(this.symbolTable, (MethodEntry)object, this.stream);
                    continue;
                }
                ((MethodGen)((AttributeEntry)object).generator()).abstractMethod(this.symbolTable, (MethodEntry)object, this.stream);
                continue;
            }
            if (symtabEntry instanceof MethodEntry) {
                object = (MethodEntry)symtabEntry;
                if (this.v.isAbstract()) {
                    ((MethodGen)((MethodEntry)object).generator()).interfaceMethod(this.symbolTable, (MethodEntry)object, this.stream);
                    continue;
                }
                ((MethodGen)((MethodEntry)object).generator()).abstractMethod(this.symbolTable, (MethodEntry)object, this.stream);
                continue;
            }
            if (symtabEntry instanceof ConstEntry) continue;
            symtabEntry.generate(this.symbolTable, this.stream);
        }
        if (this.v.isAbstract()) {
            return;
        }
        if (this.v.supports().size() > 0) {
            symtabEntry = (InterfaceEntry)this.v.supports().elementAt(0);
            object = ((InterfaceEntry)symtabEntry).allMethods().elements();
            while (object.hasMoreElements()) {
                MethodEntry methodEntry = (MethodEntry)object.nextElement();
                MethodEntry methodEntry2 = (MethodEntry)methodEntry.clone();
                methodEntry2.container(this.v);
                ((MethodGen)methodEntry2.generator()).abstractMethod(this.symbolTable, methodEntry2, this.stream);
            }
        }
        if (!this.v.isCustom() && !this.v.isAbstract()) {
            this.writeStreamableMethods();
        }
    }

    protected void writeStreamableMethods() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        this.read(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream ostream)");
        this.stream.println("  {");
        this.write(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + Util.helperName(this.v, false) + ".type ();");
        this.stream.println("  }");
    }

    @Override
    public int helperType(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        ValueEntry valueEntry = (ValueEntry)symtabEntry;
        Vector vector = valueEntry.state();
        int n2 = vector == null ? 0 : vector.size();
        String string3 = "_members" + n++;
        String string4 = "_tcOf" + string3;
        printWriter.println(string + "org.omg.CORBA.ValueMember[] " + string3 + " = new org.omg.CORBA.ValueMember[" + n2 + "];");
        printWriter.println(string + "org.omg.CORBA.TypeCode " + string4 + " = null;");
        String string5 = "_id";
        for (int i = 0; i < n2; ++i) {
            String string6;
            String string7;
            InterfaceState interfaceState = (InterfaceState)vector.elementAt(i);
            TypedefEntry typedefEntry = interfaceState.entry;
            SymtabEntry symtabEntry2 = Util.typeOf(typedefEntry);
            if (ValueGen.hasRepId(typedefEntry)) {
                string7 = Util.helperName(symtabEntry2, true) + ".id ()";
                if (symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) {
                    string6 = "\"\"";
                } else {
                    String string8 = symtabEntry2.repositoryID().ID();
                    string6 = '\"' + string8.substring(string8.lastIndexOf(58) + 1) + '\"';
                }
            } else {
                string7 = "\"\"";
                string6 = "\"\"";
            }
            printWriter.println(string + "// ValueMember instance for " + typedefEntry.name());
            n = ((JavaGenerator)((Object)typedefEntry.generator())).type(n, string, tCOffsets, string4, typedefEntry, printWriter);
            printWriter.println(string + string3 + "[" + i + "] = new org.omg.CORBA.ValueMember (" + '\"' + typedefEntry.name() + "\", ");
            printWriter.println(string + "    " + string7 + ", ");
            printWriter.println(string + "    " + string5 + ", ");
            printWriter.println(string + "    " + string6 + ", ");
            printWriter.println(string + "    " + string4 + ", ");
            printWriter.println(string + "    null, ");
            printWriter.println(string + "    org.omg.CORBA." + (interfaceState.modifier == 2 ? "PUBLIC_MEMBER" : "PRIVATE_MEMBER") + ".value);");
        }
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_value_tc (_id, " + '\"' + symtabEntry.name() + "\", " + ValueGen.getValueModifier(valueEntry) + ", " + ValueGen.getConcreteBaseTypeCode(valueEntry) + ", " + string3 + ");");
        return n;
    }

    @Override
    public int type(int n, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n;
    }

    private static boolean hasRepId(SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = Util.typeOf(symtabEntry);
        return !(symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof TypedefEntry && !((TypedefEntry)symtabEntry2).arrayInfo().isEmpty() || symtabEntry2 instanceof TypedefEntry && symtabEntry.type() instanceof SequenceEntry);
    }

    private static String getValueModifier(ValueEntry valueEntry) {
        String string = "NONE";
        if (valueEntry.isCustom()) {
            string = "CUSTOM";
        } else if (valueEntry.isAbstract()) {
            string = "ABSTRACT";
        } else if (valueEntry.isSafe()) {
            string = "TRUNCATABLE";
        }
        return "org.omg.CORBA.VM_" + string + ".value";
    }

    private static String getConcreteBaseTypeCode(ValueEntry valueEntry) {
        SymtabEntry symtabEntry;
        Vector vector = valueEntry.derivedFrom();
        if (!valueEntry.isAbstract() && !"ValueBase".equals((symtabEntry = (SymtabEntry)valueEntry.derivedFrom().elementAt(0)).name())) {
            return Util.helperName(symtabEntry, true) + ".type ()";
        }
        return "null";
    }

    @Override
    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    return (" + string + ")((org.omg.CORBA_2_3.portable.InputStream) istream).read_value (id ());");
    }

    @Override
    public int read(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Object object;
        Vector vector = ((ValueEntry)symtabEntry).derivedFrom();
        if (vector != null && vector.size() != 0) {
            object = (ValueEntry)vector.elementAt(0);
            if (object == null) {
                return n;
            }
            if (!((InterfaceEntry)object).isAbstract() && !Util.javaQualifiedName((SymtabEntry)object).equals("java.io.Serializable")) {
                printWriter.println(string + "super._read (istream);");
            }
        }
        int n2 = (object = ((ValueEntry)symtabEntry).state()) == null ? 0 : ((Vector)object).size();
        for (int i = 0; i < n2; ++i) {
            TypedefEntry typedefEntry = ((InterfaceState)((Vector)object).elementAt((int)i)).entry;
            String string3 = typedefEntry.name();
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
                n = ((JavaGenerator)((Object)typedefEntry.generator())).read(n, string, string2 + '.' + string3, typedefEntry, printWriter);
                continue;
            }
            printWriter.println(string + string2 + '.' + string3 + " = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
        }
        return n;
    }

    @Override
    public int write(int n, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Object object;
        Vector vector = ((ValueEntry)symtabEntry).derivedFrom();
        if (vector != null && vector.size() != 0) {
            object = (ValueEntry)vector.elementAt(0);
            if (object == null) {
                return n;
            }
            if (!((InterfaceEntry)object).isAbstract() && !Util.javaQualifiedName((SymtabEntry)object).equals("java.io.Serializable")) {
                printWriter.println(string + "super._write (ostream);");
            }
        }
        int n2 = (object = ((ValueEntry)symtabEntry).state()) == null ? 0 : ((Vector)object).size();
        for (int i = 0; i < n2; ++i) {
            TypedefEntry typedefEntry = ((InterfaceState)((Vector)object).elementAt((int)i)).entry;
            String string3 = typedefEntry.name();
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
                n = ((JavaGenerator)((Object)typedefEntry.generator())).write(n, string, string2 + '.' + string3, typedefEntry, printWriter);
                continue;
            }
            printWriter.println(string + Util.helperName(symtabEntry2, true) + ".write (ostream, " + string2 + '.' + string3 + ");");
        }
        return n;
    }

    protected void writeAbstract() {
        SymtabEntry symtabEntry;
        this.stream.print("public interface " + this.v.name());
        if (this.v.derivedFrom().size() == 0) {
            this.stream.print(" extends org.omg.CORBA.portable.ValueBase");
        } else {
            for (int i = 0; i < this.v.derivedFrom().size(); ++i) {
                if (i == 0) {
                    this.stream.print(" extends ");
                } else {
                    this.stream.print(", ");
                }
                symtabEntry = (SymtabEntry)this.v.derivedFrom().elementAt(i);
                this.stream.print(Util.javaName(symtabEntry));
            }
        }
        if (this.v.supports().size() > 0) {
            this.stream.print(", ");
            symtabEntry = (SymtabEntry)this.v.supports().elementAt(0);
            this.stream.print(Util.javaName(symtabEntry));
        }
        this.stream.println();
        this.stream.println("{");
    }

    @Override
    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    ((org.omg.CORBA_2_3.portable.OutputStream) ostream).write_value (value, id ());");
    }

    protected void generateValueFactory() {
        ((Factories)Compile.compiler.factories()).valueFactory().generate(this.symbolTable, this.v);
    }

    protected void generateDefaultFactory() {
        ((Factories)Compile.compiler.factories()).defaultFactory().generate(this.symbolTable, this.v);
    }
}

