/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.IPC;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jstack {
    private static List<String> vmids;
    private static boolean printProperties;
    private static boolean printSynchronizers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream out = System.out;
        if (!Jstack.parseArguments(args)) {
            System.exit(1);
        }
        AttacherDiagnosticsProvider diagProvider = new AttacherDiagnosticsProvider();
        String myId = AttachHandler.getVmId();
        out.println(LocalDateTime.now());
        for (String vmid : vmids) {
            long pid;
            if (vmid.equals(myId) || vmid.matches("\\d+") && !IPC.processExists(pid = Long.parseLong(vmid))) continue;
            try {
                diagProvider.attach(vmid);
                out.printf("Virtual machine: %s JVM information:%n", vmid);
                Util.runCommandAndPrintResult(diagProvider, DiagnosticUtils.makeThreadPrintCommand(printSynchronizers), "jstack");
                if (!printProperties) continue;
                out.println("System properties:");
                Util.printProperties(out, diagProvider.getSystemProperties());
                out.println();
                out.println("Agent properties:");
                Util.printProperties(out, diagProvider.getAgentProperties());
                out.println();
            }
            catch (Exception e) {
                Util.handleCommandException(vmid, e);
            }
            finally {
                try {
                    diagProvider.detach();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean parseArguments(String[] args) {
        boolean okay = true;
        printProperties = DiagnosticProperties.isDebug;
        printSynchronizers = false;
        String HELPTEXT = "jstack: list thread information about another Java process%n Usage:%n    jstack <vmid>*%n        <vmid>: Attach API VM ID as shown in jps or other Attach API-based tools%n        <vmid>s are read from stdin if none are supplied as arguments%n    -p: print the target's system and agent properties%n    -l: Long format. Print the thread's ownable synchronizers%n    -J: supply arguments to the Java VM running jstack%n";
        vmids = new ArrayList<String>();
        for (String a : args) {
            if (!a.startsWith("-")) {
                vmids.add(a);
                continue;
            }
            if (a.equals("-p")) {
                printProperties = true;
                continue;
            }
            if (a.equals("-l")) {
                printSynchronizers = true;
                continue;
            }
            System.err.printf("jstack: list thread information about another Java process%n Usage:%n    jstack <vmid>*%n        <vmid>: Attach API VM ID as shown in jps or other Attach API-based tools%n        <vmid>s are read from stdin if none are supplied as arguments%n    -p: print the target's system and agent properties%n    -l: Long format. Print the thread's ownable synchronizers%n    -J: supply arguments to the Java VM running jstack%n", new Object[0]);
            okay = false;
            break;
        }
        if (okay && vmids.isEmpty()) {
            vmids = Util.inStreamToStringList(System.in);
        }
        return okay;
    }
}

