/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.Predicate;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public final class OpenTypeMappingIHandler
implements InvocationHandler {
    private final MBeanServerConnection connection;
    private final MBeanInfo info;
    private final ObjectName mxBeanObjectName;

    private static String[] getOperationSignature(Method method) {
        Class<?>[] types = method.getParameterTypes();
        String[] result = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i].getName();
        }
        return result;
    }

    public OpenTypeMappingIHandler(MBeanServerConnection connection, Class<?> mxBeanType, ObjectName mxBeanObjectName) throws IOException {
        this.connection = connection;
        this.mxBeanObjectName = mxBeanObjectName;
        this.checkBeanIsRegistered();
        try {
            this.info = connection.getMBeanInfo(mxBeanObjectName);
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void checkBeanIsRegistered() throws IOException {
        if (!this.connection.isRegistered(this.mxBeanObjectName)) {
            throw new IllegalArgumentException(Msg.getString("K05F4", this.mxBeanObjectName));
        }
    }

    private MBeanAttributeInfo getAttribInfo(String methodName) {
        block3: {
            MBeanAttributeInfo[] attribs;
            block2: {
                attribs = this.info.getAttributes();
                if (!methodName.startsWith("get")) break block2;
                String attribName = methodName.substring("get".length());
                for (MBeanAttributeInfo attribInfo : attribs) {
                    if (!attribName.equals(attribInfo.getName()) || !attribInfo.isReadable()) continue;
                    return attribInfo;
                }
                break block3;
            }
            if (!methodName.startsWith("is")) break block3;
            String attribName = methodName.substring("is".length());
            for (MBeanAttributeInfo attribInfo : attribs) {
                if (!attribName.equals(attribInfo.getName()) || !attribInfo.isReadable() || !attribInfo.isIs()) continue;
                return attribInfo;
            }
        }
        return null;
    }

    private String getAttribName(Method method) {
        MBeanAttributeInfo[] attribs;
        Predicate<MBeanAttributeInfo> attribTest;
        String attribName;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            attribName = methodName.substring("get".length());
            attribTest = attribInfo -> attribInfo.isReadable();
        } else if (methodName.startsWith("is")) {
            attribName = methodName.substring("is".length());
            attribTest = attribInfo -> attribInfo.isReadable() && attribInfo.isIs();
        } else if (methodName.startsWith("set")) {
            attribName = methodName.substring("set".length());
            attribTest = attribInfo -> attribInfo.isWritable();
        } else {
            return null;
        }
        for (MBeanAttributeInfo attribInfo2 : attribs = this.info.getAttributes()) {
            if (!attribName.equals(attribInfo2.getName()) || !attribTest.test(attribInfo2)) continue;
            return attribName;
        }
        return null;
    }

    private String getAttrOpenType(String methodName) {
        MBeanAttributeInfo attrInfo = this.getAttribInfo(methodName);
        return attrInfo.getType();
    }

    private InvokeType getInvokeType(String methodName) {
        Method[] neMethods;
        MBeanAttributeInfo attribInfo;
        int n;
        int n2;
        MBeanAttributeInfo[] mBeanAttributeInfoArray;
        MBeanAttributeInfo[] attribs;
        String attribName;
        if (methodName.startsWith("get")) {
            attribName = methodName.substring("get".length());
            mBeanAttributeInfoArray = attribs = this.info.getAttributes();
            n2 = mBeanAttributeInfoArray.length;
            for (n = 0; n < n2; ++n) {
                attribInfo = mBeanAttributeInfoArray[n];
                if (!attribName.equals(attribInfo.getName()) || !attribInfo.isReadable()) continue;
                return InvokeType.ATTRIBUTE_GETTER;
            }
        } else if (methodName.startsWith("is")) {
            attribName = methodName.substring("is".length());
            mBeanAttributeInfoArray = attribs = this.info.getAttributes();
            n2 = mBeanAttributeInfoArray.length;
            for (n = 0; n < n2; ++n) {
                attribInfo = mBeanAttributeInfoArray[n];
                if (!attribName.equals(attribInfo.getName()) || !attribInfo.isReadable() || !attribInfo.isIs()) continue;
                return InvokeType.ATTRIBUTE_GETTER;
            }
        } else if (methodName.startsWith("set")) {
            attribName = methodName.substring("set".length());
            mBeanAttributeInfoArray = attribs = this.info.getAttributes();
            n2 = mBeanAttributeInfoArray.length;
            for (n = 0; n < n2; ++n) {
                attribInfo = mBeanAttributeInfoArray[n];
                if (!attribName.equals(attribInfo.getName()) || !attribInfo.isWritable()) continue;
                return InvokeType.ATTRIBUTE_SETTER;
            }
        }
        for (Method neMethod : neMethods = NotificationEmitter.class.getMethods()) {
            if (!methodName.equals(neMethod.getName())) continue;
            return InvokeType.NOTIFICATION_OP;
        }
        return InvokeType.OPERATION;
    }

    private String getOperationOpenReturnType(Method method) {
        MBeanOperationInfo[] opInfos;
        String methodName = method.getName();
        String[] methodSig = OpenTypeMappingIHandler.getOperationSignature(method);
        block0: for (MBeanOperationInfo opInfo : opInfos = this.info.getOperations()) {
            MBeanParameterInfo[] opParams;
            if (!methodName.equals(opInfo.getName()) || (opParams = opInfo.getSignature()).length != methodSig.length) continue;
            for (int i = 0; i < opParams.length; ++i) {
                if (!methodSig[i].equals(opParams[i].getType())) continue block0;
            }
            return opInfo.getReturnType();
        }
        return null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        String methodName = method.getName();
        switch (this.getInvokeType(methodName)) {
            case ATTRIBUTE_GETTER: {
                result = this.invokeAttributeGetter(method);
                break;
            }
            case ATTRIBUTE_SETTER: {
                result = this.invokeAttributeSetter(method, args);
                break;
            }
            case NOTIFICATION_OP: {
                result = this.invokeNotificationEmitterOperation(method, args);
                break;
            }
            default: {
                result = "toString".equals(methodName) && (args == null || args.length == 0) ? "MXBeanProxy(" + this.connection + "[" + this.mxBeanObjectName + "])" : ("getObjectName".equals(methodName) && (args == null || args.length == 0) ? this.mxBeanObjectName : this.invokeOperation(method, args));
            }
        }
        return result;
    }

    private Object invokeAttributeGetter(Method method) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object result = null;
        String realReturnType = method.getReturnType().getName();
        String openReturnType = this.getAttrOpenType(method.getName());
        PrivilegedExceptionAction<Object> action = () -> this.connection.getAttribute(this.mxBeanObjectName, this.getAttribName(method));
        try {
            result = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        if (!realReturnType.equals(openReturnType)) {
            result = ManagementUtils.convertFromOpenType(result, Class.forName(openReturnType), Class.forName(realReturnType));
        }
        return result;
    }

    private Object invokeAttributeSetter(Method method, Object[] args) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, InvalidAttributeValueException {
        PrivilegedExceptionAction<Void> action = () -> {
            this.connection.setAttribute(this.mxBeanObjectName, new Attribute(this.getAttribName(method), args[0]));
            return null;
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        return null;
    }

    private Object invokeNotificationEmitterOperation(Method method, Object[] args) throws InstanceNotFoundException, IOException, ListenerNotFoundException {
        String methodName = method.getName();
        MBeanNotificationInfo[] result = null;
        if ("addNotificationListener".equals(methodName)) {
            PrivilegedExceptionAction<Void> action = () -> {
                this.connection.addNotificationListener(this.mxBeanObjectName, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                return null;
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
            catch (RuntimeMBeanException e) {
                throw e.getTargetException();
            }
        }
        if ("getNotificationInfo".equals(methodName)) {
            result = this.info.getNotifications();
        } else if ("removeNotificationListener".equals(methodName)) {
            if (args.length == 1) {
                PrivilegedExceptionAction<Void> action = () -> {
                    this.connection.removeNotificationListener(this.mxBeanObjectName, (NotificationListener)args[0]);
                    return null;
                };
                try {
                    AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof InstanceNotFoundException) {
                        throw (InstanceNotFoundException)t;
                    }
                    if (t instanceof ListenerNotFoundException) {
                        throw (ListenerNotFoundException)t;
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    throw new RuntimeException(t);
                }
                catch (RuntimeMBeanException e) {
                    throw e.getTargetException();
                }
            }
            PrivilegedExceptionAction<Void> action = () -> {
                this.connection.removeNotificationListener(this.mxBeanObjectName, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                return null;
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)t;
                }
                if (t instanceof ListenerNotFoundException) {
                    throw (ListenerNotFoundException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
            catch (RuntimeMBeanException e) {
                throw e.getTargetException();
            }
        }
        return result;
    }

    private Object invokeOperation(Method method, Object[] args) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        PrivilegedExceptionAction<Object> action = () -> this.connection.invoke(this.mxBeanObjectName, method.getName(), args, OpenTypeMappingIHandler.getOperationSignature(method));
        Object result = null;
        try {
            result = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        String realReturnType = method.getReturnType().getName();
        String openReturnType = this.getOperationOpenReturnType(method);
        if (!realReturnType.equals(openReturnType)) {
            result = ManagementUtils.convertFromOpenType(result, Class.forName(openReturnType), Class.forName(realReturnType));
        }
        return result;
    }

    private static enum InvokeType {
        ATTRIBUTE_GETTER,
        ATTRIBUTE_SETTER,
        NOTIFICATION_OP,
        OPERATION;

    }
}

