/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.ThreadMXBeanImpl;
import com.ibm.lang.management.ExtendedThreadInfo;
import com.ibm.lang.management.ThreadMXBean;
import com.ibm.lang.management.internal.ExtendedThreadInfoImpl;
import com.ibm.oti.util.Msg;
import java.lang.management.ThreadInfo;

public final class ExtendedThreadMXBeanImpl
extends ThreadMXBeanImpl
implements ThreadMXBean {
    private static final ThreadMXBean instance = new ExtendedThreadMXBeanImpl();
    private boolean isThreadAllocatedMemoryEnabled = true;

    public static ThreadMXBean getInstance() {
        return instance;
    }

    private ExtendedThreadMXBeanImpl() {
    }

    @Override
    public ExtendedThreadInfo[] dumpAllExtendedThreads(boolean lockedMonitors, boolean lockedSynchronizers) throws InternalError, SecurityException, UnsupportedOperationException {
        ThreadInfo[] threadInfos = this.dumpAllThreads(lockedMonitors, lockedSynchronizers);
        int infoCount = threadInfos.length;
        ExtendedThreadInfo[] resultArray = new ExtendedThreadInfo[infoCount];
        for (int index = 0; index < infoCount; ++index) {
            resultArray[index] = new ExtendedThreadInfoImpl(threadInfos[index]);
        }
        return resultArray;
    }

    private static native long getThreadAllocatedBytesImpl(long var0);

    @Override
    public long getThreadAllocatedBytes(long threadId) {
        if (this.isThreadAllocatedMemorySupported()) {
            if (this.isThreadAllocatedMemoryEnabled()) {
                return ExtendedThreadMXBeanImpl.getThreadAllocatedBytesImpl(threadId);
            }
            return -1L;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] threadIds) {
        int length = threadIds.length;
        long[] allocatedBytes = new long[length];
        for (int i = 0; i < length; ++i) {
            allocatedBytes[i] = this.getThreadAllocatedBytes(threadIds[i]);
        }
        return allocatedBytes;
    }

    @Override
    public long getTotalThreadAllocatedBytes() {
        long[] allocatedBytes;
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException();
        }
        if (!this.isThreadAllocatedMemoryEnabled()) {
            return -1L;
        }
        long total = 0L;
        for (long threadAllocated : allocatedBytes = this.getThreadAllocatedBytes(this.getAllThreadIds())) {
            if (threadAllocated == -1L) continue;
            total += threadAllocated;
        }
        return total;
    }

    @Override
    public long[] getThreadCpuTime(long[] threadIds) {
        int i;
        long[] result = new long[threadIds.length];
        for (i = 0; i < threadIds.length; ++i) {
            if (threadIds[i] <= 0L) {
                throw new IllegalArgumentException(Msg.getString("K05F7"));
            }
            result[i] = -1L;
        }
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                for (i = 0; i < threadIds.length; ++i) {
                    result[i] = this.getThreadCpuTime(threadIds[i]);
                }
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public long[] getThreadUserTime(long[] threadIds) {
        int i;
        long[] result = new long[threadIds.length];
        for (i = 0; i < threadIds.length; ++i) {
            if (threadIds[i] <= 0L) {
                throw new IllegalArgumentException(Msg.getString("K05F7"));
            }
            result[i] = -1L;
        }
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                for (i = 0; i < threadIds.length; ++i) {
                    result[i] = this.getThreadUserTime(threadIds[i]);
                }
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return true;
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        return this.isThreadAllocatedMemoryEnabled && this.isThreadAllocatedMemorySupported();
    }

    @Override
    public void setThreadAllocatedMemoryEnabled(boolean value) {
        this.isThreadAllocatedMemoryEnabled = value;
    }
}

