/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.TracePermission;
import com.ibm.oti.vm.VM;
import java.util.Objects;

public final class Trace {
    public static final String EVENT = "0 ";
    public static final String EXCEPTION = "1 ";
    public static final String ENTRY = "2 ";
    public static final String EXIT = "4 ";
    public static final String EXCEPTION_EXIT = "5 ";
    private static final String LEGACY_TRACE_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyTraceSecurity";
    private static final TracePermission TRACE_PERMISSION = new TracePermission();

    private Trace() {
    }

    @Deprecated
    public static void initializeTrace() {
    }

    private static native void initTraceImpl();

    public static int set(String cmd) {
        Trace.checkLegacySecurityPermssion();
        return Trace.setImpl(cmd);
    }

    public static void snap() {
        Trace.checkLegacySecurityPermssion();
        Trace.snapImpl();
    }

    public static void suspend() {
        Trace.checkLegacySecurityPermssion();
        Trace.suspendImpl();
    }

    public static void resume() {
        Trace.checkLegacySecurityPermssion();
        Trace.resumeImpl();
    }

    public static void suspendThis() {
        Trace.checkLegacySecurityPermssion();
        Trace.suspendThisImpl();
    }

    public static void resumeThis() {
        Trace.checkLegacySecurityPermssion();
        Trace.resumeThisImpl();
    }

    public static synchronized int registerApplication(String name, String[] templates) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(templates, "templates");
        return Trace.registerApplicationImpl(name, templates);
    }

    private static native int setImpl(String var0);

    private static native void snapImpl();

    private static native void suspendImpl();

    private static native void resumeImpl();

    private static native void suspendThisImpl();

    private static native void resumeThisImpl();

    private static native int registerApplicationImpl(String var0, String[] var1);

    private static void checkLegacySecurityPermssion() throws SecurityException {
        if (!"false".equalsIgnoreCase(VM.internalGetProperties().getProperty(LEGACY_TRACE_PERMISSION_PROPERTY))) {
            Trace.checkTraceSecurityPermssion();
        }
    }

    private static void checkTraceSecurityPermssion() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(TRACE_PERMISSION);
        }
    }

    public static void trace(int handle, int traceId) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId);
    }

    public static void trace(int handle, int traceId, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1);
    }

    public static void trace(int handle, int traceId, String s1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, s2);
    }

    public static void trace(int handle, int traceId, String s1, String s2, String s3) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Objects.requireNonNull(s3, "s3");
        Trace.traceImpl(handle, traceId, s1, s2, s3);
    }

    public static void trace(int handle, int traceId, String s1, Object o1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(o1, "o1");
        Trace.traceImpl(handle, traceId, s1, o1);
    }

    public static void trace(int handle, int traceId, Object o1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(o1, "o1");
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, o1, s1);
    }

    public static void trace(int handle, int traceId, String s1, int i1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1, i1);
    }

    public static void trace(int handle, int traceId, int i1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, i1, s1);
    }

    public static void trace(int handle, int traceId, String s1, long l1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1, l1);
    }

    public static void trace(int handle, int traceId, long l1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, l1, s1);
    }

    public static void trace(int handle, int traceId, String s1, byte b1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1, b1);
    }

    public static void trace(int handle, int traceId, byte b1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, b1, s1);
    }

    public static void trace(int handle, int traceId, String s1, char c1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1, c1);
    }

    public static void trace(int handle, int traceId, char c1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, c1, s1);
    }

    public static void trace(int handle, int traceId, String s1, float f1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1, f1);
    }

    public static void trace(int handle, int traceId, float f1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, f1, s1);
    }

    public static void trace(int handle, int traceId, String s1, double d1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, s1, d1);
    }

    public static void trace(int handle, int traceId, double d1, String s1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, d1, s1);
    }

    public static void trace(int handle, int traceId, Object o1) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(o1, "o1");
        Trace.traceImpl(handle, traceId, o1);
    }

    public static void trace(int handle, int traceId, Object o1, Object o2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(o1, "o1");
        Objects.requireNonNull(o2, "o2");
        Trace.traceImpl(handle, traceId, o1, o2);
    }

    public static void trace(int handle, int traceId, int i1) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, i1);
    }

    public static void trace(int handle, int traceId, int i1, int i2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, i1, i2);
    }

    public static void trace(int handle, int traceId, int i1, int i2, int i3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, i1, i2, i3);
    }

    public static void trace(int handle, int traceId, long l1) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, l1);
    }

    public static void trace(int handle, int traceId, long l1, long l2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, l1, l2);
    }

    public static void trace(int handle, int traceId, long l1, long l2, long i3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, l1, l2, i3);
    }

    public static void trace(int handle, int traceId, byte b1) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, b1);
    }

    public static void trace(int handle, int traceId, byte b1, byte b2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, b1, b2);
    }

    public static void trace(int handle, int traceId, byte b1, byte b2, byte b3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, b1, b2, b3);
    }

    public static void trace(int handle, int traceId, char c1) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, c1);
    }

    public static void trace(int handle, int traceId, char c1, char c2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, c1, c2);
    }

    public static void trace(int handle, int traceId, char c1, char c2, char c3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, c1, c2, c3);
    }

    public static void trace(int handle, int traceId, float f1) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, f1);
    }

    public static void trace(int handle, int traceId, float f1, float f2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, f1, f2);
    }

    public static void trace(int handle, int traceId, float f1, float f2, float f3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, f1, f2, f3);
    }

    public static void trace(int handle, int traceId, double d1) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, d1);
    }

    public static void trace(int handle, int traceId, double d1, double d2) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, d1, d2);
    }

    public static void trace(int handle, int traceId, double d1, double d2, double d3) {
        Trace.checkLegacySecurityPermssion();
        Trace.traceImpl(handle, traceId, d1, d2, d3);
    }

    public static void trace(int handle, int traceId, String s1, Object o1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(o1, "o1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, o1, s2);
    }

    public static void trace(int handle, int traceId, Object o1, String s1, Object o2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(o1, "o1");
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(o2, "o2");
        Trace.traceImpl(handle, traceId, o1, s1, o2);
    }

    public static void trace(int handle, int traceId, String s1, int i1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, i1, s2);
    }

    public static void trace(int handle, int traceId, int i1, String s1, int i2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, i1, s1, i2);
    }

    public static void trace(int handle, int traceId, String s1, long l1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, l1, s2);
    }

    public static void trace(int handle, int traceId, long l1, String s1, long l2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, l1, s1, l2);
    }

    public static void trace(int handle, int traceId, String s1, byte b1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, b1, s2);
    }

    public static void trace(int handle, int traceId, byte b1, String s1, byte b2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, b1, s1, b2);
    }

    public static void trace(int handle, int traceId, String s1, char c1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, c1, s2);
    }

    public static void trace(int handle, int traceId, char c1, String s1, char c2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, c1, s1, c2);
    }

    public static void trace(int handle, int traceId, String s1, float f1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, f1, s2);
    }

    public static void trace(int handle, int traceId, float f1, String s1, float f2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, f1, s1, f2);
    }

    public static void trace(int handle, int traceId, String s1, double d1, String s2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Objects.requireNonNull(s2, "s2");
        Trace.traceImpl(handle, traceId, s1, d1, s2);
    }

    public static void trace(int handle, int traceId, double d1, String s1, double d2) {
        Trace.checkLegacySecurityPermssion();
        Objects.requireNonNull(s1, "s1");
        Trace.traceImpl(handle, traceId, d1, s1, d2);
    }

    private static native void traceImpl(int var0, int var1);

    private static native void traceImpl(int var0, int var1, String var2);

    private static native void traceImpl(int var0, int var1, String var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, String var3, String var4);

    private static native void traceImpl(int var0, int var1, String var2, Object var3);

    private static native void traceImpl(int var0, int var1, Object var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, int var3);

    private static native void traceImpl(int var0, int var1, int var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, long var3);

    private static native void traceImpl(int var0, int var1, long var2, String var4);

    private static native void traceImpl(int var0, int var1, String var2, byte var3);

    private static native void traceImpl(int var0, int var1, byte var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, char var3);

    private static native void traceImpl(int var0, int var1, char var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, float var3);

    private static native void traceImpl(int var0, int var1, float var2, String var3);

    private static native void traceImpl(int var0, int var1, String var2, double var3);

    private static native void traceImpl(int var0, int var1, double var2, String var4);

    private static native void traceImpl(int var0, int var1, Object var2);

    private static native void traceImpl(int var0, int var1, Object var2, Object var3);

    private static native void traceImpl(int var0, int var1, int var2);

    private static native void traceImpl(int var0, int var1, int var2, int var3);

    private static native void traceImpl(int var0, int var1, int var2, int var3, int var4);

    private static native void traceImpl(int var0, int var1, long var2);

    private static native void traceImpl(int var0, int var1, long var2, long var4);

    private static native void traceImpl(int var0, int var1, long var2, long var4, long var6);

    private static native void traceImpl(int var0, int var1, byte var2);

    private static native void traceImpl(int var0, int var1, byte var2, byte var3);

    private static native void traceImpl(int var0, int var1, byte var2, byte var3, byte var4);

    private static native void traceImpl(int var0, int var1, char var2);

    private static native void traceImpl(int var0, int var1, char var2, char var3);

    private static native void traceImpl(int var0, int var1, char var2, char var3, char var4);

    private static native void traceImpl(int var0, int var1, float var2);

    private static native void traceImpl(int var0, int var1, float var2, float var3);

    private static native void traceImpl(int var0, int var1, float var2, float var3, float var4);

    private static native void traceImpl(int var0, int var1, double var2);

    private static native void traceImpl(int var0, int var1, double var2, double var4);

    private static native void traceImpl(int var0, int var1, double var2, double var4, double var6);

    private static native void traceImpl(int var0, int var1, String var2, Object var3, String var4);

    private static native void traceImpl(int var0, int var1, Object var2, String var3, Object var4);

    private static native void traceImpl(int var0, int var1, String var2, int var3, String var4);

    private static native void traceImpl(int var0, int var1, int var2, String var3, int var4);

    private static native void traceImpl(int var0, int var1, String var2, long var3, String var5);

    private static native void traceImpl(int var0, int var1, long var2, String var4, long var5);

    private static native void traceImpl(int var0, int var1, String var2, byte var3, String var4);

    private static native void traceImpl(int var0, int var1, byte var2, String var3, byte var4);

    private static native void traceImpl(int var0, int var1, String var2, char var3, String var4);

    private static native void traceImpl(int var0, int var1, char var2, String var3, char var4);

    private static native void traceImpl(int var0, int var1, String var2, float var3, String var4);

    private static native void traceImpl(int var0, int var1, float var2, String var3, float var4);

    private static native void traceImpl(int var0, int var1, String var2, double var3, String var5);

    private static native void traceImpl(int var0, int var1, double var2, String var4, double var5);

    @Deprecated
    public static native long getMicros();

    static {
        Trace.initTraceImpl();
    }
}

