/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit.crypto;

import com.ibm.oti.vm.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITTRNGInHardware {
    private static final JITTRNGInHardware trng;
    private static final boolean isSupportedByHardware;
    static final String osArch;

    private JITTRNGInHardware() {
    }

    @CallerSensitive
    public static JITTRNGInHardware getInstance() {
        ClassLoader callerClassLoader = Reflection.getCallerClass().getClassLoader();
        if (callerClassLoader != null && callerClassLoader != VM.getVMLangAccess().getExtClassLoader()) {
            throw new SecurityException(JITTRNGInHardware.class.getName());
        }
        return trng;
    }

    private static native boolean isTRNGSupportedByHardwareImpl();

    private static native int randomImpl(byte[] var0, int var1, int var2);

    public boolean isTRNGSupportedByHardware() {
        return isSupportedByHardware;
    }

    public int random(byte[] to, int offset, int length) {
        if (isSupportedByHardware) {
            return JITTRNGInHardware.randomImpl(to, offset, length);
        }
        return 0;
    }

    static {
        osArch = VM.getVMLangAccess().internalGetProperties().getProperty("os.arch");
        trng = new JITTRNGInHardware();
        boolean disableHardwareAcceleration = "true".equalsIgnoreCase(VM.getVMLangAccess().internalGetProperties().getProperty("com.ibm.jit.crypto.nohardwaretrng"));
        boolean support = false;
        isSupportedByHardware = support = !disableHardwareAcceleration && JITTRNGInHardware.isTRNGSupportedByHardwareImpl();
    }
}

