/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaException;
import com.ibm.oti.vm.VM;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Cuda {
    private static native long allocatePinnedBuffer(long var0) throws CudaException;

    public static ByteBuffer allocatePinnedHostBuffer(long capacity) throws CudaException {
        if (0L <= capacity && capacity <= Integer.MAX_VALUE) {
            long address = Cuda.allocatePinnedBuffer(capacity);
            ByteBuffer buffer = Cuda.wrapDirectBuffer(address, capacity);
            return Cleaner.instance.insert(buffer, address).order(ByteOrder.LITTLE_ENDIAN);
        }
        throw new IllegalArgumentException(String.valueOf(capacity));
    }

    public static native int getDeviceCount() throws CudaException;

    public static native int getDriverVersion() throws CudaException;

    static native String getErrorMessage(int var0);

    public static native int getRuntimeVersion() throws CudaException;

    private static native int initialize(Class<CudaException> var0, Method var1);

    static void loadNatives() {
    }

    private static native ByteBuffer wrapDirectBuffer(long var0, long var2);

    private Cuda() {
    }

    static {
        Method runMethod;
        AccessController.doPrivileged(() -> {
            System.loadLibrary("cuda4j29");
            return null;
        });
        try {
            runMethod = Runnable.class.getMethod("run", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        int status = Cuda.initialize(CudaException.class, runMethod);
        if (status != 0) {
            throw new RuntimeException(Cuda.getErrorMessage(status));
        }
    }

    private static final class Cleaner
    implements Runnable {
        static final Cleaner instance = new Cleaner();
        private static long releaseCount;
        private final Map<Object, Long> inuse = new ConcurrentHashMap<Object, Long>();
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        private static native void releasePinnedBuffer(long var0) throws CudaException;

        private Cleaner() {
        }

        ByteBuffer insert(ByteBuffer buffer, long address) {
            this.inuse.put(new WeakReference<Object>(buffer, this.queue), address);
            return buffer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Long address;
                        if ((address = this.inuse.remove(this.queue.remove())) == null) {
                            continue;
                        }
                        Cleaner.releasePinnedBuffer(address);
                        ++releaseCount;
                    }
                }
                catch (CudaException | InterruptedException exception) {
                    continue;
                }
                break;
            }
        }

        static {
            PrivilegedAction<Thread> createThread = () -> VM.getVMLangAccess().createThread(instance, "CUDA pinned buffer cleaner", true, false, true, null);
            Thread daemon = AccessController.doPrivileged(createThread);
            daemon.start();
        }
    }
}

