/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.buffer;

import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.util.list.LinkedList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public abstract class ByteBuffer {
    public static final byte[] ZERO_BYTE_ARRAY = new byte[0];
    private final LinkedList positions = new LinkedList();

    ByteBuffer() {
    }

    final byte[] allocByteArray(int n) {
        byte[] byArray = new byte[n];
        return byArray;
    }

    final void releaseByteArray(byte[] byArray) {
    }

    final Position getLastPosition() {
        return (Position)this.positions.getLast();
    }

    final void addPosition(Position position) {
        this.positions.addLast(position);
    }

    final void invalidatePositions(int n) {
        Position position;
        for (position = (Position)this.positions.getFirst(); position != null && position.getOffset() < n; position = (Position)position.getNext()) {
            position.invalidate();
        }
        this.positions.clearBeforeItem(position);
    }

    final void invalidateAllPositions() {
        for (Position position = (Position)this.positions.getFirst(); position != null; position = (Position)position.getNext()) {
            position.invalidate();
        }
        this.positions.clear();
    }

    static void checkParams(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Given byte[] is null.");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = "Given offset (" + n + ") and/or data length (" + n2 + ") is beyond the given byte[] (length " + byArray.length + ") bounds.";
            throw new IndexOutOfBoundsException(string);
        }
    }

    static void checkUpdateByteParams(int n, int n2) {
        if (n < 1 || n + 1 > n2) {
            String string = "Given offset (" + n + ") is beyond the available data (length " + n2 + ") bounds.";
            throw new IndexOutOfBoundsException(string);
        }
    }

    static void checkUpdateParams(byte[] byArray, int n, int n2, int n3, int n4) {
        ByteBuffer.checkParams(byArray, n, n2);
        if (n3 < 0 || n3 + n2 > n4) {
            String string = "Given offset (" + n3 + ") and/or data length (" + n2 + ") is beyond the available data (length " + n4 + ") bounds.";
            throw new IndexOutOfBoundsException(string);
        }
    }

    public static void writeHexString(PrintWriter printWriter, byte[] byArray, int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < n2; ++n4) {
            String string;
            int n5 = byArray[n + n4];
            if (n5 < 0) {
                n5 += 256;
            }
            if ((string = Integer.toHexString(n5)).length() == 1) {
                printWriter.print('0');
            }
            printWriter.print(string);
            printWriter.print(' ');
        }
        for (n4 = 0; n4 < n3; ++n4) {
            printWriter.print("   ");
        }
    }

    public abstract int getAvailableSpace();

    public abstract int getSize();

    public abstract void reset();

    public abstract int read();

    public abstract int read(byte[] var1, int var2, int var3);

    public abstract Position getWritePosition();

    public abstract int getWriteOffset();

    public abstract void write(byte var1);

    public abstract void write(byte[] var1, int var2, int var3);

    public abstract void write(byte var1, Position var2, int var3);

    public abstract void write(byte[] var1, int var2, int var3, Position var4, int var5);

    public abstract void flushTo(OutputStream var1) throws IOException;

    public abstract void flushTo(org.omg.CORBA.portable.OutputStream var1);

    public abstract void flushTo(OutputStream var1, Connection var2) throws IOException;

    public abstract byte[] toByteArray();

    public abstract byte[] toByteArrayFrom(Position var1);

    public abstract String toString();

    public static class Position
    extends LinkedList.Item
    implements Comparable {
        private ByteBuffer byteBuffer;
        private final int offset;

        Position(ByteBuffer byteBuffer, int n) {
            this(byteBuffer, n, true);
        }

        Position(ByteBuffer byteBuffer, int n, boolean bl) {
            this.byteBuffer = byteBuffer;
            this.offset = n;
            if (bl) {
                byteBuffer.addPosition(this);
            }
        }

        void invalidate() {
            this.byteBuffer = null;
        }

        final boolean isValid(ByteBuffer byteBuffer) {
            return this.byteBuffer != null && this.byteBuffer == byteBuffer;
        }

        final void checkValidity() {
            if (this.byteBuffer == null) {
                throw new IllegalStateException("Position is no longer valid");
            }
        }

        public final int getOffset() {
            this.checkValidity();
            return this.offset;
        }

        private final ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public final int compareTo(Object object) {
            Position position = (Position)object;
            this.checkValidity();
            position.checkValidity();
            if (this.byteBuffer != position.getByteBuffer()) {
                String string = "Position objects are from different ByteBuffers.";
                throw new IllegalArgumentException(string);
            }
            return this.offset - this.getOffset();
        }

        final boolean equals(ByteBuffer byteBuffer, int n) {
            boolean bl = false;
            if (this.byteBuffer != null) {
                bl = this.byteBuffer == byteBuffer && this.offset == n;
            }
            return bl;
        }

        final int calculateGap(int n) {
            this.checkValidity();
            return this.offset - n;
        }
    }
}

