/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.Trc;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;

public class JDKClassLoader {
    private static final String CLASS = JDKClassLoader.class.getName();
    public static final PrivilegedAction getLatestLoaderRetrieverAction = GetLatestLoaderRetrieverAction.INSTANCE;

    private static final class GetLatestLoaderRetrieverAction
    implements PrivilegedAction {
        static final PrivilegedAction INSTANCE = new GetLatestLoaderRetrieverAction();
        private static final Class[] PARAMS = null;

        private GetLatestLoaderRetrieverAction() {
        }

        public Object run() {
            Object object;
            Method method = null;
            try {
                object = Class.forName("java.io.ObjectInputStream");
                method = ((Class)object).getDeclaredMethod("latestUserDefinedLoader", PARAMS);
                int n = method.getModifiers();
                if (!Modifier.isStatic(n)) {
                    method = null;
                } else if (!Modifier.isPublic(n)) {
                    method.setAccessible(true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                method = null;
                Trc.ffdc(classNotFoundException, CLASS, "getMethodLatestUserDefinedLoader:122");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = null;
                Trc.ffdc(noSuchMethodException, CLASS, "getMethodLatestUserDefinedLoader:125");
            }
            object = null == method ? NullLoaderRetriever.INSTANCE : new LatestLoaderRetriever(method);
            return object;
        }
    }

    private static final class LatestLoaderRetriever
    extends LoaderRetriever {
        private static final Object[] ARGS = null;
        private final Method method;

        public LatestLoaderRetriever(Method method) {
            this.method = method;
        }

        @Override
        public ClassLoader get() {
            ClassLoader classLoader = null;
            try {
                classLoader = (ClassLoader)this.method.invoke(null, ARGS);
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "get:89");
            }
            return classLoader;
        }
    }

    public static final class NullLoaderRetriever
    extends LoaderRetriever {
        public static final LoaderRetriever INSTANCE = new NullLoaderRetriever();

        private NullLoaderRetriever() {
        }

        @Override
        public ClassLoader get() {
            return null;
        }
    }

    public static abstract class LoaderRetriever {
        public abstract ClassLoader get();
    }
}

