/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.IOException;
import java.lang.reflect.Array;

public class JLShortArraySerializer
extends ArraySerializer {
    private static String CLASS = JLShortArraySerializer.class.getName();
    private static JLShortArraySerializer instance = new JLShortArraySerializer();

    private JLShortArraySerializer() {
        this.vTag = (byte)103;
    }

    public static JLShortArraySerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Short[] shortArray = (Short[])object;
        int n = shortArray.length;
        encoderOutputStream.write_longInVarint(n);
        for (Short s : shortArray) {
            this.writeShort(encoderOutputStream, s);
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Short[] shortArray = null;
        int n = encoderInputStream.read_longInVarint();
        shortArray = (Short[])Array.newInstance(Short.class, n);
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(Short[].class, n);
        encoderInputStream.addToValueCache(shortArray);
        for (int i = 0; i < n; ++i) {
            shortArray[i] = (Short)this.readShort(encoderInputStream);
        }
        iIOPInputStream.decrementDepth();
        return shortArray;
    }

    @Override
    public final boolean isludclPushrequired() {
        return false;
    }
}

