/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.HexFormatter;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.Aligner;
import com.ibm.rmi.ORB;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.iiop.IDRReader;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.util.Interop;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;

public class IDRInputStream
extends IDRReader {
    private static final String CLASS = IDRInputStream.class.getName();
    public final Interop interop;
    private Connection connection = null;
    int index;
    int size;
    int offset;
    byte[] buf;
    int start = 0;
    private static final long serialVersionUID = 0L;

    public IDRInputStream(EncoderInputStream encoderInputStream) {
        super(encoderInputStream);
        this.interop = Interop.NO_IBM_ORB;
    }

    public IDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, EncoderInputStream encoderInputStream) {
        this(oRB, byArray, n, false, encoderInputStream);
    }

    public IDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, Connection connection, EncoderInputStream encoderInputStream) {
        this(oRB, byArray, n, false, encoderInputStream);
        this.connection = connection;
    }

    public IDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl, EncoderInputStream encoderInputStream) {
        super(encoderInputStream);
        this.orb = oRB;
        this.littleEndian = bl;
        this.size = n;
        this.buf = byArray;
        this.offset = 0;
        if (oRB instanceof ORB) {
            this.interop = ((ORB)oRB).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
        } else {
            this.interop = Interop.NO_IBM_ORB;
        }
    }

    public IDRInputStream(EncoderOutputStream encoderOutputStream, byte[] byArray, int n, EncoderInputStream encoderInputStream) {
        this(encoderOutputStream.orb(), byArray, n, encoderOutputStream.littleEndian(), encoderOutputStream.getCharCodeSet(), encoderOutputStream.getWCharCodeSet(), encoderInputStream);
        this.setGIOPVersions(encoderOutputStream.getGIOPMajor(), encoderOutputStream.getGIOPMinor(), encoderOutputStream.getPartnerMajor(), encoderOutputStream.getPartnerMinor(), encoderOutputStream.getPartnerExtended());
        this.setStreamFormatVersion(encoderOutputStream.getStreamFormatVersion());
    }

    public IDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, int n2, int n3, EncoderInputStream encoderInputStream) {
        this(oRB, byArray, n, false, n2, n3, encoderInputStream);
    }

    public IDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, int n, boolean bl, int n2, int n3, EncoderInputStream encoderInputStream) {
        this(oRB, byArray, n, bl, encoderInputStream);
        this.setCodeSets(n2, n3);
    }

    public IDRInputStream(IDRInputStream iDRInputStream, EncoderInputStream encoderInputStream) {
        super(encoderInputStream);
        this.littleEndian = iDRInputStream.littleEndian;
        this.index = iDRInputStream.index;
        this.size = iDRInputStream.size;
        this.buf = iDRInputStream.buf;
        this.orb = iDRInputStream.orb;
        this.connection = iDRInputStream.connection;
        this.offset = iDRInputStream.offset;
        this.start = iDRInputStream.start;
        this.setGIOPVersion(iDRInputStream.GIOPMajor, iDRInputStream.GIOPMinor, iDRInputStream.fragmentable);
        this.setCodeSets(iDRInputStream.tcsChar, iDRInputStream.tcsWChar);
        if (this.orb instanceof ORB) {
            this.interop = ((ORB)this.orb).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
        } else {
            this.interop = Interop.NO_IBM_ORB;
        }
        this.tcsChar = iDRInputStream.tcsChar;
        this.tcsWChar = iDRInputStream.tcsWChar;
        this.tcsCConverter = iDRInputStream.tcsCConverter;
        this.tcsWConverter = iDRInputStream.tcsWConverter;
    }

    public IDRInputStream(IDRInputStream iDRInputStream, int n, EncoderInputStream encoderInputStream) {
        this(iDRInputStream.getORB(), iDRInputStream.buf, iDRInputStream.mark() + n, encoderInputStream);
        if (iDRInputStream.index + n <= iDRInputStream.size) {
            this.index = this.start = iDRInputStream.index;
            this.offset = iDRInputStream.get_offset();
            iDRInputStream.setOffset(iDRInputStream.mark() + n);
        } else {
            this.littleEndian = iDRInputStream.littleEndian;
            this.buf = new byte[n];
            iDRInputStream.read_octet_array(this.buf, 0, n);
            this.start = 0;
            this.index = 0;
            this.size = n;
            this.offset = iDRInputStream.get_offset() - n;
        }
        this.typeStore = iDRInputStream.getTypeStore();
        this.setGIOPVersion(iDRInputStream.GIOPMajor, iDRInputStream.GIOPMinor, iDRInputStream.fragmentable);
    }

    public IDRInputStream(CDRInputStream cDRInputStream, EncoderInputStream encoderInputStream) {
        super(encoderInputStream);
        this.littleEndian = cDRInputStream.littleEndian;
        this.index = cDRInputStream.index;
        this.size = cDRInputStream.size;
        this.buf = cDRInputStream.buf;
        this.orb = cDRInputStream.orb;
        this.connection = cDRInputStream.connection;
        this.offset = cDRInputStream.offset;
        this.start = cDRInputStream.start;
        this.setGIOPVersion(cDRInputStream.GIOPMajor, cDRInputStream.GIOPMinor, cDRInputStream.fragmentable);
        this.setCodeSets(cDRInputStream.tcsChar, cDRInputStream.tcsWChar);
        if (this.orb instanceof ORB) {
            this.interop = ((ORB)this.orb).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
        } else {
            this.interop = Interop.NO_IBM_ORB;
        }
        this.connectionType = cDRInputStream.connectionType;
    }

    @Override
    public void toAlign(Aligner aligner, int n) {
        int n2;
        if (n > 1 && (n2 = this.index - this.start & n - 1) != 0) {
            n2 = n - n2;
            this.index += n2;
        }
    }

    @Override
    public void setOffset(int n) {
        this.index = n;
    }

    public final byte read_octet() {
        this.checkCustomDataAvailability(1);
        if (this.index >= this.size) {
            this.availableData(1, 1, 1);
        }
        byte by = this.buf[this.index++];
        return by;
    }

    @Override
    protected final int read_longInVarint() {
        int n = 0;
        int n2 = 0;
        while (true) {
            this.checkCustomDataAvailability(1);
            if (this.index >= this.size) {
                this.availableData(1, 1, 1);
            }
            int n3 = this.buf[this.index++] & 0x7F;
            n = (n3 <<= 7 * n2) + n;
            if ((this.buf[this.index - 1] & 0x80) == 0) break;
            ++n2;
        }
        n = n >>> 1 ^ -(n & 1);
        return n;
    }

    @Override
    public final void ignoreReserved() {
        try {
            switch (this.available()) {
                case 0: {
                    this.alignAndCheck(null, 2, 2);
                    this.index += 2;
                    this.alignAndCheck(null, 1, 1);
                    ++this.index;
                    return;
                }
                case 1: {
                    ++this.index;
                    this.alignAndCheck(null, 2, 2);
                    this.index += 2;
                    return;
                }
                case 2: {
                    this.index += 2;
                    this.alignAndCheck(null, 1, 1);
                    ++this.index;
                    return;
                }
            }
            this.index += 3;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final short read_short() {
        int n = 0;
        this.checkCustomDataAvailability(2);
        if (this.readMode == 1) {
            this.alignAndCheck(null, 2, 2);
        }
        if (this.littleEndian) {
            for (int i = 0; i < 2; ++i) {
                if (this.index >= this.size) {
                    this.availableData(1, 1, 1);
                }
                int n2 = this.buf[this.index++] & 0xFF;
                n = (n2 <<= 8 * i) | n;
            }
        } else {
            for (int i = 2; i > 0; --i) {
                if (this.index >= this.size) {
                    this.availableData(1, 1, 1);
                }
                int n3 = this.buf[this.index++] & 0xFF;
                n = (n3 <<= 8 * (i - 1)) | n;
            }
        }
        return (short)n;
    }

    public final int read_long() {
        int n = 0;
        this.checkCustomDataAvailability(4);
        if (this.readMode == 1) {
            this.alignAndCheck(null, 4, 4);
        }
        if (this.littleEndian) {
            for (int i = 0; i < 4; ++i) {
                if (this.index >= this.size) {
                    this.availableData(1, 1, 1);
                }
                int n2 = this.buf[this.index++] & 0xFF;
                n = (n2 <<= 8 * i) | n;
            }
        } else {
            for (int i = 4; i > 0; --i) {
                if (this.index >= this.size) {
                    this.availableData(1, 1, 1);
                }
                int n3 = this.buf[this.index++] & 0xFF;
                n = (n3 <<= 8 * (i - 1)) | n;
            }
        }
        return n;
    }

    public final long read_longlong() {
        long l;
        long l2;
        this.checkCustomDataAvailability(8);
        if (this.littleEndian) {
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
            l = (long)this.read_long() << 32;
        } else {
            l = (long)this.read_long() << 32;
            l2 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l | l2;
    }

    @Override
    protected final long read_longlongInVarint() {
        long l = 0L;
        int n = 0;
        while (true) {
            if (this.index >= this.size) {
                this.availableData(1, 1, 1);
            }
            long l2 = this.buf[this.index++] & 0x7F;
            l = (l2 <<= 7 * n) + l;
            if ((this.buf[this.index - 1] & 0x80) == 0) break;
            ++n;
        }
        l = l >>> 1 ^ -(l & 1L);
        return l;
    }

    @Override
    public final byte fast_read_byte() {
        this.checkCustomDataAvailability(1);
        return this.buf[this.index++];
    }

    @Override
    public final void read_octet_array(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null) {
            throw new BAD_PARAM("NULL_PARAM (17) - Null encountered reading octet array", 1229124113, CompletionStatus.COMPLETED_NO);
        }
        for (int i = n; i < n2 + n; i += n3) {
            int n4 = n2 + n - i;
            n3 = this.alignAndCheck(null, 1, n4);
            System.arraycopy(this.buf, this.index, byArray, i, n3);
            this.index += n3;
        }
    }

    @Override
    public int get_offset() {
        return this.index - this.start + this.offset;
    }

    @Override
    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.encoderStream instanceof IIOPInputStream) {
            this.connection = ((IIOPInputStream)this.encoderStream).getConnection();
        }
        return this.connection;
    }

    @Override
    public boolean wasCreatedFrom(EncoderOutputStream encoderOutputStream) {
        return false;
    }

    @Override
    public final void rewind() {
        this.offset += this.index;
        this.index = this.start;
    }

    @Override
    public final boolean isAtEnd() {
        return this.index == this.size;
    }

    @Override
    public int available() throws IOException {
        return this.size - this.index;
    }

    @Override
    public int mark() {
        return this.index;
    }

    @Override
    public void reset(int n) {
        this.index = n;
    }

    @Override
    public void printBuffer() {
        for (int i = 0; i < this.size; i += 16) {
            int n = 0;
            for (int j = 0; j < 16; ++j) {
                String string;
                int n2;
                if (i + j >= this.size) {
                    n2 = 0;
                } else {
                    n2 = this.buf[i + j];
                    ++n;
                }
                if (n2 < 0) {
                    n2 = 256 + n2;
                }
                if ((string = Integer.toHexString(n2)).length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
            }
            System.out.println(new String(this.buf, i, n));
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:581");
        throw notSerializableException;
    }

    @Override
    public Interop getInterop() {
        return this.interop;
    }

    @Override
    public void closeBuffer() {
        this.buf = null;
    }

    @Override
    public int getBufferIndex() {
        return this.index;
    }

    @Override
    public int getBufferStart() {
        return this.start;
    }

    @Override
    public void skip(int n) {
        this.index += n;
    }

    @Override
    public void setEndian(boolean bl) {
    }

    public void setStreamFormatVersion(byte by) {
        this.streamFormatVersion = by;
    }

    protected void traceData(String string, String string2, String string3) {
        String string4 = HexFormatter.format(this.buf, this.start, this.index, this.size, this.offset);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, string + "\n" + string4, string2, string3);
        }
    }

    @Override
    protected int getCurrentRemaining() {
        return -1;
    }

    @Override
    protected int checkSize(int n) {
        throw new NO_IMPLEMENT();
    }

    @Override
    int getStreamOffset() {
        return this.offset;
    }

    @Override
    void setStreamOffset(int n) {
        this.offset = n;
    }

    @Override
    void setByteBuffer(byte[] byArray) {
        this.buf = byArray;
    }

    @Override
    byte[] getByteBuffer() {
        return this.buf;
    }

    @Override
    void setSize(int n) {
        this.size = n;
    }

    @Override
    int getStart() {
        return this.start;
    }

    @Override
    void setStart(int n) {
        this.start = n;
    }

    @Override
    void setBufferIndex(int n) {
        this.index = n;
    }
}

