/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.nio;

import com.ibm.jtc.orb.nio.BufferHandler;
import com.ibm.jtc.orb.nio.BufferHandlerHelper;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public final class Aligner {
    private static final byte PAD_BYTE = -67;
    private static final byte[][] PADS = new byte[8][];
    private final int mask;
    private final byte[][] pads;
    public static final Aligner TWO;
    public static final Aligner FOUR;
    public static final Aligner EIGHT;

    private Aligner(int n) {
        this.mask = n - 1;
        if (n == PADS.length) {
            this.pads = PADS;
        } else {
            this.pads = new byte[n][];
            this.pads[0] = PADS[0];
            for (int i = 1; i < n; ++i) {
                this.pads[i] = PADS[PADS.length - n + i];
            }
        }
    }

    public static Aligner getAligner(int n) {
        switch (n) {
            case 2: {
                return TWO;
            }
            case 4: {
                return FOUR;
            }
            case 8: {
                return EIGHT;
            }
        }
        throw new MARSHAL("Unsupported alignment of " + n, 1229125872, CompletionStatus.COMPLETED_MAYBE);
    }

    public void pad(BufferHandler bufferHandler) {
        int n = bufferHandler.getStreamPosition() & this.mask;
        if (n != 0) {
            byte[] byArray = this.pads[n];
            WsByteBuffer wsByteBuffer = BufferHandlerHelper.ensureCapacity(bufferHandler, byArray.length);
            wsByteBuffer.put(byArray);
        }
    }

    public void skip(BufferHandler bufferHandler) {
        int n = bufferHandler.getStreamPosition() & this.mask;
        if (n != 0) {
            int n2 = this.pads[n].length;
            int n3 = BufferHandlerHelper.skip(bufferHandler, n2);
        }
    }

    static {
        Aligner.PADS[0] = new byte[0];
        for (int i = 1; i < PADS.length; ++i) {
            Aligner.PADS[i] = new byte[PADS.length - i];
            for (int j = 0; j < PADS[i].length; ++j) {
                Aligner.PADS[i][j] = -67;
            }
        }
        TWO = new Aligner(2);
        FOUR = new Aligner(4);
        EIGHT = new Aligner(8);
    }
}

