/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.AuthorityInfoAccessExtension;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.IssuerAlternativeNameExtension;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.PolicyConstraintsExtension;
import com.ibm.security.x509.PolicyMappingsExtension;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.UniqueIdentity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509AttributeName;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.x500.X500Principal;
import sun.security.util.SignatureUtil;

public final class X509CertImpl
extends X509Certificate
implements DerEncoder {
    private static final long serialVersionUID = -5820390314598772321L;
    private static final String DOT = ".";
    public static final String NAME = "x509";
    public static final String INFO = "info";
    public static final String ALG_ID = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNED_CERT = "signed_cert";
    public static final String SUBJECT_DN = "x509.info.subject.dname";
    public static final String ISSUER_DN = "x509.info.issuer.dname";
    public static final String SERIAL_ID = "x509.info.serialNumber.number";
    public static final String PUBLIC_KEY = "x509.info.key.value";
    public static final String SIG_ALG = "x509.algorithm";
    public static final String SIG = "x509.signature";
    private boolean readOnly = false;
    private String provider = null;
    private byte[] signedCert = null;
    protected X509CertInfo info = null;
    protected AlgorithmId algId = null;
    protected byte[] signature = null;
    private List<String> extKeyUsage;
    public static final String KEY_USAGE_OID = "2.5.29.15";
    public static final String BASIC_CONSTRAINT_OID = "2.5.29.19";
    public static final String SUB_ALT_NAME_OID = "2.5.29.17";
    public static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    public static final String ISSUER_ALT_NAME_OID = "2.5.29.18";
    public static final String AUTH_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.1";
    private static final int NUM_STANDARD_KEY_USAGE = 9;
    private Collection<List<?>> subjectAlternativeNames;
    private Collection<List<?>> issuerAlternativeNames;
    private X500Principal issuerX500Principal = null;
    private X500Principal subjectX500Principal = null;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;
    private boolean verificationResult;
    private byte[] subjectKeyId = null;
    private byte[] issuerKeyId = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CertImpl";
    private ConcurrentHashMap<String, String> fingerprints = new ConcurrentHashMap(2);

    public X509CertImpl(byte[] certData) throws CertificateException {
        this(certData, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", (Object)certData);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(byte[] certData, String provider) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", certData, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            this.parse(new DerValue(certData));
        }
        catch (IOException e) {
            if (debug != null) {
                debug.text(16384L, className, "X509CertImpl", "Unable to initialize, " + e);
            }
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + e);
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(InputStream in) throws CertificateException {
        this(in, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", in);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(InputStream in, String provider) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", in, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            this.parse(new DerValue(in));
        }
        catch (IOException e) {
            this.signedCert = null;
            if (debug != null) {
                debug.text(16384L, className, "X509CertImpl", "Unable to initialize, " + e);
            }
            throw new CertificateException("Unable to initialize, " + e);
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(X509CertInfo certInfo) throws CertificateParsingException, CertificateEncodingException {
        this(certInfo, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", certInfo);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(X509CertInfo certInfo, String provider) throws CertificateParsingException, CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", certInfo, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.info = certInfo != null ? (this.provider != null ? new X509CertInfo(certInfo.getEncodedInfo(), this.provider) : new X509CertInfo(certInfo.getEncodedInfo())) : certInfo;
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(DerValue derVal) throws CertificateException {
        this(derVal, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertImpl", derVal);
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public X509CertImpl(DerValue derVal, String provider) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertImpl", derVal, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            this.parse(derVal);
        }
        catch (IOException e) {
            this.signedCert = null;
            if (debug != null) {
                debug.text(16384L, className, "X509CertImpl", "Unable to initialize, " + e);
            }
            throw new CertificateException("Unable to initialize, " + e);
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertImpl");
        }
    }

    public void encode(OutputStream out) throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Null certificate to encode");
            }
            throw new CertificateEncodingException("Null certificate to encode");
        }
        try {
            out.write((byte[])this.signedCert.clone());
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", e);
            }
            throw new CertificateEncodingException(e.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public synchronized void verify(PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        if (this.getSigAlgParams() != null) {
            try {
                this.verify(key, sigProvider, this.getSigAlgParams());
            }
            catch (InvalidParameterSpecException ipse) {
                throw new SignatureException("Signature does not match");
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new SignatureException("Signature does not match");
            }
            catch (IOException ioe) {
                throw new SignatureException("Signature does not match");
            }
            return;
        }
        Signature sigVerf = null;
        sigVerf = sigProvider == null ? Signature.getInstance(this.algId.getName()) : Signature.getInstance(this.algId.getName(), sigProvider);
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(this.algId.getName(), this.getSigAlgParams()));
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        this.verificationResult = sigVerf.verify(this.signature);
        this.verifiedPublicKey = key;
        if (!this.verificationResult) {
            throw new SignatureException("Signature does not match.");
        }
    }

    public synchronized void verify(PublicKey key, Provider sigProvider, byte[] sigAlgParams) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException, InvalidParameterSpecException, InvalidAlgorithmParameterException {
        AlgorithmParameters pssParams;
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature sigVerf = null;
        sigVerf = sigProvider == null ? Signature.getInstance(this.algId.getName()) : Signature.getInstance(this.algId.getName(), sigProvider);
        String signatureAlgorithmName = this.getSigAlgName();
        if (signatureAlgorithmName != null && signatureAlgorithmName.toUpperCase().contains("PSS") && (pssParams = AlgorithmParameters.getInstance("RSAPSS")) != null) {
            pssParams.init(sigAlgParams);
            PSSParameterSpec algParameterSpec = pssParams.getParameterSpec(PSSParameterSpec.class);
            if (algParameterSpec != null) {
                sigVerf.setParameter(algParameterSpec);
            }
        }
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(this.algId.getName(), sigAlgParams));
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        this.verificationResult = sigVerf.verify(this.signature);
        this.verifiedPublicKey = key;
        if (!this.verificationResult) {
            throw new SignatureException("Signature does not match.");
        }
    }

    public static void verify(X509Certificate cert, PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509CertImpl certImpl = (X509CertImpl)cert;
        certImpl.verify(key, sigProvider);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "derEncode", "Null certificate to encode");
            }
            throw new IOException("Null certificate to encode");
        }
        out.write((byte[])this.signedCert.clone());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        return (byte[])this.getEncodedInternal().clone();
    }

    public byte[] getEncodedInternal() throws CertificateEncodingException {
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "getEncoded", "Null certificate to encode");
            }
            throw new CertificateEncodingException("Null certificate to encode");
        }
        byte[] result = this.signedCert;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncoded", result);
        }
        return result;
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", key);
        }
        this.verify(key, "");
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    @Override
    public synchronized void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", key, sigProvider);
        }
        if (this.getSigAlgParams() != null) {
            try {
                this.verify(key, sigProvider, this.getSigAlgParams());
            }
            catch (InvalidParameterSpecException ipse) {
                throw new SignatureException("Signature does not match");
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new SignatureException("Signature does not match");
            }
            catch (IOException ioe) {
                throw new SignatureException("Signature does not match");
            }
            return;
        }
        if (sigProvider == null) {
            sigProvider = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(key) && sigProvider.equals(this.verifiedProvider)) {
            if (this.verificationResult) {
                return;
            }
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized certificate");
            }
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature sigVerf = null;
        sigVerf = sigProvider.length() == 0 ? Signature.getInstance(this.algId.getName()) : Signature.getInstance(this.algId.getName(), sigProvider);
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(this.algId.getName(), this.getSigAlgParams()));
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        this.verificationResult = sigVerf.verify(this.signature);
        this.verifiedPublicKey = key;
        this.verifiedProvider = sigProvider;
        if (!this.verificationResult) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public synchronized void verify(PublicKey key, String sigProvider, byte[] sigAlgParams) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, InvalidAlgorithmParameterException, IOException, InvalidParameterSpecException {
        AlgorithmParameters pssParams;
        if (debug != null) {
            debug.entry(16384L, className, "verify", key, sigProvider);
        }
        if (sigProvider == null) {
            sigProvider = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(key) && sigProvider.equals(this.verifiedProvider)) {
            if (this.verificationResult) {
                return;
            }
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        if (this.signedCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized certificate");
            }
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature sigVerf = null;
        sigVerf = sigProvider.length() == 0 ? Signature.getInstance(this.algId.getName()) : Signature.getInstance(this.algId.getName(), sigProvider);
        String signatureAlgorithmName = this.getSigAlgName();
        if (signatureAlgorithmName != null && signatureAlgorithmName.toUpperCase().contains("PSS") && (pssParams = AlgorithmParameters.getInstance("RSAPSS")) != null) {
            pssParams.init(sigAlgParams);
            PSSParameterSpec algParameterSpec = pssParams.getParameterSpec(PSSParameterSpec.class);
            if (algParameterSpec != null) {
                sigVerf.setParameter(algParameterSpec);
            }
        }
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(this.algId.getName(), sigAlgParams));
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        this.verificationResult = sigVerf.verify(this.signature);
        this.verifiedPublicKey = key;
        this.verifiedProvider = sigProvider;
        if (!this.verificationResult) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public void sign(PrivateKey key, String algorithm) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", key, algorithm);
        }
        this.sign(key, algorithm, (String)null);
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void sign(PrivateKey key, String algorithm, AlgorithmParameterSpec algParameterSpec) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "sign", new Object[]{key, algorithm, algParameterSpec});
        }
        this.sign(key, algorithm, null, algParameterSpec);
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void sign(PrivateKey key, String algorithm, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{key, algorithm, provider};
            debug.entry(16384L, (Object)className, "sign", parms);
        }
        try {
            if (this.readOnly) {
                if (debug != null) {
                    debug.text(16384L, className, "sign", "cannot over-write existing certificate");
                }
                throw new CertificateEncodingException("cannot over-write existing certificate");
            }
            Signature sigEngine = null;
            sigEngine = provider == null || provider.length() == 0 ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            SignatureUtil.initSignWithParam(sigEngine, key, SignatureUtil.getParamSpec(algorithm, this.getSigAlgParams()), null);
            this.algId = AlgorithmId.get(sigEngine.getAlgorithm());
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            this.info.encode(tmp);
            byte[] rawCert = tmp.toByteArray();
            this.algId.encode(tmp);
            sigEngine.update(rawCert, 0, rawCert.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCert = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.text(16384L, className, "sign", e.toString());
            }
            throw new CertificateEncodingException(e.toString());
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void sign(PrivateKey key, String algorithm, String provider, AlgorithmParameterSpec algParams) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, InvalidAlgorithmParameterException {
        if (debug != null) {
            String algParamsStr = algParams != null ? algParams.toString() : null;
            Object[] parms = new Object[]{key, algorithm, provider, algParamsStr};
            debug.entry(16384L, (Object)className, "sign", parms);
        }
        try {
            if (this.readOnly) {
                if (debug != null) {
                    debug.text(16384L, className, "sign", "cannot over-write existing certificate");
                }
                throw new CertificateEncodingException("cannot over-write existing certificate");
            }
            Signature sigEngine = null;
            sigEngine = provider == null || provider.length() == 0 ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            if (algParams != null) {
                sigEngine.setParameter(algParams);
            }
            SignatureUtil.initSignWithParam(sigEngine, key, algParams, null);
            this.algId = AlgorithmId.get(sigEngine.getParameters());
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            this.info.encode(tmp);
            byte[] rawCert = tmp.toByteArray();
            this.algId.encode(tmp);
            sigEngine.update(rawCert, 0, rawCert.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCert = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            if (debug != null) {
                debug.text(16384L, className, "sign", e.toString());
            }
            throw new CertificateEncodingException(e.toString());
        }
        catch (ProviderException e) {
            throw new SignatureException("Error parsing signature parameters", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Invalid signature parameters", e);
        }
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        if (debug != null) {
            debug.entry(16384L, className, "checkValidity");
        }
        Date date = new Date();
        this.checkValidity(date);
        if (debug != null) {
            debug.exit(16384L, className, "checkValidity");
        }
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "checkValidity", date);
        }
        CertificateValidity interval = null;
        try {
            interval = (CertificateValidity)this.info.get("validity");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "checkValidity", "Incorrect validity period");
            }
            throw new CertificateNotYetValidException("Incorrect validity period");
        }
        if (interval == null) {
            if (debug != null) {
                debug.text(16384L, className, "checkValidity", "Null validity period");
            }
            throw new CertificateNotYetValidException("Null validity period");
        }
        interval.valid(date);
        if (debug != null) {
            debug.exit(16384L, className, "checkValidity");
        }
    }

    public Object get(String name) throws CertificateParsingException {
        X509AttributeName attr;
        String id;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (!(id = (attr = new X509AttributeName(name)).getPrefix()).equalsIgnoreCase(NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "get", "Invalid root of attribute name, expected [x509], received [" + id + "]");
            }
            throw new CertificateParsingException("Invalid root of attribute name, expected [x509], received [" + id + "]");
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (this.info == null) {
                return null;
            }
            if (attr.getSuffix() != null) {
                try {
                    return this.info.get(attr.getSuffix());
                }
                catch (IOException e) {
                    if (debug != null) {
                        debug.exception(16384L, className, "get", e);
                    }
                    throw new CertificateParsingException(e.toString());
                }
                catch (CertificateException e) {
                    if (debug != null) {
                        debug.exception(16384L, className, "get", e);
                    }
                    throw new CertificateParsingException(e.toString());
                }
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.info);
            }
            return this.info;
        }
        if (id.equalsIgnoreCase(ALG_ID)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.algId);
            }
            return this.algId;
        }
        if (id.equalsIgnoreCase(SIGNATURE)) {
            if (this.signature == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_3", null);
                }
                return null;
            }
            byte[] dup = new byte[this.signature.length];
            System.arraycopy(this.signature, 0, dup, 0, dup.length);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", dup);
            }
            return dup;
        }
        if (id.equalsIgnoreCase(SIGNED_CERT)) {
            if (this.signedCert == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_5", null);
                }
                return null;
            }
            byte[] dup = new byte[this.signedCert.length];
            System.arraycopy(this.signedCert, 0, dup, 0, dup.length);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_6", dup);
            }
            return dup;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized or get() not allowed for the same: " + id);
        }
        throw new CertificateParsingException("Attribute name not recognized or get() not allowed for the same: " + id);
    }

    public void set(String name, Object obj) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.text(16384L, className, "set", "cannot over-write existing certificate");
            }
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Invalid root of attribute name, expected [x509], received " + id);
            }
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + id);
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() == null) {
                if (!(obj instanceof X509CertInfo)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type X509CertInfo.");
                    }
                    throw new CertificateException("Attribute value should be of type X509CertInfo.");
                }
                if (obj != null) {
                    X509CertInfo tempInfo = (X509CertInfo)obj;
                    this.info = this.provider != null ? new X509CertInfo(tempInfo.getEncodedInfo(), this.provider) : new X509CertInfo(tempInfo.getEncodedInfo());
                } else {
                    this.info = (X509CertInfo)obj;
                }
                this.signedCert = null;
            } else {
                if (this.info == null) {
                    this.info = this.provider != null ? new X509CertInfo(this.provider) : new X509CertInfo();
                }
                this.info.set(attr.getSuffix(), obj);
                this.signedCert = null;
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized or set() not allowed for the same: " + id);
            }
            throw new CertificateException("Attribute name not recognized or set() not allowed for the same: " + id);
        }
    }

    public void delete(String name) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "cannot over-write existing certificate");
            }
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Invalid root of attribute name, expected [x509], received " + id);
            }
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + id);
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() != null) {
                this.info = null;
            } else {
                this.info.delete(attr.getSuffix());
            }
        } else if (id.equalsIgnoreCase(ALG_ID)) {
            this.algId = null;
        } else if (id.equalsIgnoreCase(SIGNATURE)) {
            this.signature = null;
        } else if (id.equalsIgnoreCase(SIGNED_CERT)) {
            this.signedCert = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized or delete() not allowed for the same: " + id);
            }
            throw new CertificateException("Attribute name not recognized or delete() not allowed for the same: " + id);
        }
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement("x509.info");
        elements.addElement(SIG_ALG);
        elements.addElement(SIG);
        elements.addElement("x509.signed_cert");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    @Override
    public String toString() {
        if (this.info == null || this.algId == null || this.signature == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\r\n");
        sb.append(this.info.toString() + "\r\n");
        sb.append("  Algorithm: [" + this.algId.toString() + "]\r\n");
        HexDumpEncoder encoder = new HexDumpEncoder();
        sb.append("  Signature:\r\n" + encoder.encodeBuffer(this.signature));
        sb.append("\r\n]");
        return sb.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKey");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_1", null);
            }
            return null;
        }
        try {
            PublicKey key = (PublicKey)this.info.get("key.value");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_2", key);
            }
            return key;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getPublicKey", e);
                debug.exit(16384L, (Object)className, "getPublicKey_3", null);
            }
            return null;
        }
    }

    @Override
    public int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getVersion_1", new Integer(-1));
            }
            return -1;
        }
        try {
            int vers = (Integer)this.info.get("version.number");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getVersion_2", new Integer(vers + 1));
            }
            return vers + 1;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getVersion", e);
                debug.exit(16384L, (Object)className, "getVersion_3", new Integer(-1));
            }
            return -1;
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSerialNumber_1", null);
            }
            return null;
        }
        try {
            SerialNumber ser = (SerialNumber)this.info.get("serialNumber.number");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSerialNumber_2", ser.getNumber());
            }
            return ser.getNumber();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSerialNumber", e);
                debug.exit(16384L, (Object)className, "getSerialNumber_3", null);
            }
            return null;
        }
    }

    public SerialNumber getSerialNumberObject() {
        if (this.info == null) {
            return null;
        }
        try {
            SerialNumber ser = (SerialNumber)this.info.get("serialNumber.number");
            return ser;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Principal getSubjectDN() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectDN");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_1", null);
            }
            return null;
        }
        try {
            Principal subject = (Principal)this.info.get("subject.dname");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_2", subject);
            }
            return subject;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (debug != null) {
                debug.text(16384L, className, "getSubjectDN", e.toString());
                debug.exit(16384L, (Object)className, "getSubjectDN_3", null);
            }
            return null;
        }
    }

    @Override
    public Principal getIssuerDN() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectDN");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_1", null);
            }
            return null;
        }
        try {
            Principal issuer = (Principal)this.info.get("issuer.dname");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectDN_2", issuer);
            }
            return issuer;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSubjectDN", e);
                debug.exit(16384L, (Object)className, "getSubjectDN_3", null);
            }
            return null;
        }
    }

    @Override
    public Date getNotBefore() {
        if (debug != null) {
            debug.entry(16384L, className, "getNotBefore");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotBefore_1", null);
            }
            return null;
        }
        try {
            Date d = (Date)this.info.get("validity.notBefore");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotBefore_2", d);
            }
            return d;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getNotBefore", e);
                debug.exit(16384L, (Object)className, "getNotBefore_3", null);
            }
            return null;
        }
    }

    @Override
    public Date getNotAfter() {
        if (debug != null) {
            debug.entry(16384L, className, "getNotAfter");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotAfter_1", null);
            }
            return null;
        }
        try {
            Date d = (Date)this.info.get("validity.notAfter");
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNotAfter_2", d);
            }
            return d;
        }
        catch (Exception e) {
            debug.exception(16384L, className, "getNotAfter", e);
            debug.exit(16384L, (Object)className, "getNotAfter_3", null);
            return null;
        }
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "getTBSCertificate");
        }
        if (this.info != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getTBSCertificate", this.info.getEncodedInfo());
            }
            return this.info.getEncodedInfo();
        }
        if (debug != null) {
            debug.text(16384L, className, "getTBSCertificate", "Uninitialized certificate");
        }
        throw new CertificateEncodingException("Uninitialized certificate");
    }

    @Override
    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature_1", null);
            }
            return null;
        }
        byte[] dup = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, dup, 0, dup.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", dup);
        }
        return dup;
    }

    @Override
    public String getSigAlgName() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgName");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgName_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigAlgName", this.algId.getName());
        }
        return this.algId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgOID");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgOID_1", null);
            }
            return null;
        }
        ObjectIdentifier oid = this.algId.getOID();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigAlgOID_2", oid.toString());
        }
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgParams");
        }
        if (this.algId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams_1", null);
            }
            return null;
        }
        try {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams_2", this.algId.getEncodedParams());
            }
            return this.algId.getEncodedParams();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSigAlgParams", e);
                debug.exit(16384L, (Object)className, "getSigAlgParams_3", null);
            }
            return null;
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuerUniqueID");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuerUniqueID_1", null);
            }
            return null;
        }
        try {
            UniqueIdentity id = (UniqueIdentity)this.info.get("issuerID");
            if (id == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getIssuerUniqueID_2", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuerUniqueID", id.getId());
            }
            return id.getId();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getIssuerUniqueID", e);
                debug.exit(16384L, (Object)className, "getIssuerUniqueID_3", null);
            }
            return null;
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubjectUniqueID");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectUniqueID_1", null);
            }
            return null;
        }
        try {
            UniqueIdentity id = (UniqueIdentity)this.info.get("subjectID");
            if (id == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getSubjectUniqueID_2", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubjectUniqueID", id.getId());
            }
            return id.getId();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getSubjectUniqueID", e);
                debug.exit(16384L, (Object)className, "getSubjectUniqueID_3", null);
            }
            return null;
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension_1", new Boolean(false));
            }
            return false;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension_2", new Boolean(false));
                }
                return false;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(exts.hasUnsupportedCriticalExtension()));
            }
            return exts.hasUnsupportedCriticalExtension();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension_3", new Boolean(false));
            }
            return false;
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_2", null);
                }
                return null;
            }
            TreeSet<String> extSet = new TreeSet<String>();
            for (Extension ex : exts.getAllExtensions()) {
                if (!ex.isCritical()) continue;
                extSet.add(ex.getExtensionId().toString());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", extSet);
            }
            return extSet;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getCriticalExtensionOIDs", e);
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs_3", null);
            }
            return null;
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.info == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_1", null);
            }
            return null;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_2", null);
                }
                return null;
            }
            TreeSet<String> extSet = new TreeSet<String>();
            for (Extension ex : exts.getAllExtensions()) {
                if (ex.isCritical()) continue;
                extSet.add(ex.getExtensionId().toString());
            }
            extSet.addAll(exts.getUnparseableExtensions().keySet());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", extSet);
            }
            return extSet;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getNonCriticalExtensionOIDs", e);
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs_3", null);
            }
            return null;
        }
    }

    public SubjectAlternativeNameExtension getSubjectAlternativeNameExtension() {
        return (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id);
    }

    public ExtKeyUsageExtension getExtendedKeyUsageExtension() {
        return (ExtKeyUsageExtension)this.getExtension(PKIXExtensions.ExtendedKeyUsage_Id);
    }

    public NameConstraintsExtension getNameConstraintsExtension() {
        return (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id);
    }

    public PolicyConstraintsExtension getPolicyConstraintsExtension() {
        return (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id);
    }

    public PolicyMappingsExtension getPolicyMappingsExtension() {
        return (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id);
    }

    public IssuerAlternativeNameExtension getIssuerAlternativeNameExtension() {
        return (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id);
    }

    public synchronized Collection getIssuerAlternativeNames() throws CertificateParsingException {
        GeneralNames names;
        if (this.readOnly && this.issuerAlternativeNames != null) {
            return X509CertImpl.cloneAltNames(this.issuerAlternativeNames);
        }
        IssuerAlternativeNameExtension issuerAltNameExt = this.getIssuerAlternativeNameExtension();
        if (issuerAltNameExt == null) {
            return null;
        }
        try {
            names = issuerAltNameExt.get("issuer_name");
        }
        catch (IOException ioe) {
            return Collections.EMPTY_SET;
        }
        this.issuerAlternativeNames = X509CertImpl.makeAltNames(names);
        return this.issuerAlternativeNames;
    }

    public static Collection<List<?>> getIssuerAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        try {
            GeneralNames names;
            byte[] ext = cert.getExtensionValue(ISSUER_ALT_NAME_OID);
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            IssuerAlternativeNameExtension issuerAltNameExt = new IssuerAlternativeNameExtension(Boolean.FALSE, data);
            try {
                names = issuerAltNameExt.get("issuer_name");
            }
            catch (IOException ioe) {
                return Collections.emptySet();
            }
            return X509CertImpl.makeAltNames(names);
        }
        catch (IOException ioe) {
            CertificateParsingException cpe = new CertificateParsingException(ioe.getMessage());
            throw cpe;
        }
    }

    public synchronized Set<AccessDescription> getAuthorityInformationAccess() throws CertificateParsingException {
        return X509CertImpl.getAuthorityInformationAccess(this);
    }

    public AuthorityKeyIdentifierExtension getAuthorityKeyIdentifierExtension() {
        return (AuthorityKeyIdentifierExtension)this.getExtension(PKIXExtensions.AuthorityKey_Id);
    }

    public KeyIdentifier getAuthKeyId() {
        AuthorityKeyIdentifierExtension aki = this.getAuthorityKeyIdentifierExtension();
        if (aki != null) {
            try {
                return (KeyIdentifier)aki.get("key_id");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Set<AccessDescription> getAuthorityInformationAccess(X509Certificate cert) throws CertificateParsingException {
        try {
            byte[] extValue = cert.getExtensionValue(AUTH_INFO_ACCESS_OID);
            if (extValue == null) {
                return Collections.emptySet();
            }
            DerInputStream der = new DerInputStream(extValue);
            DerInputStream subDer = new DerInputStream(der.getOctetString());
            DerValue[] derVal = subDer.getSequence(5);
            HashSet<AccessDescription> accessDesc = new HashSet<AccessDescription>(derVal.length);
            for (int i = 0; i < derVal.length; ++i) {
                accessDesc.add(new AccessDescription(derVal[i]));
            }
            return Collections.unmodifiableSet(accessDesc);
        }
        catch (IOException ioe) {
            return Collections.emptySet();
        }
    }

    public static X500Principal getIssuerX500Principal(X509Certificate cert) {
        try {
            return X509CertImpl.getX500Principal(cert, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse issuer", e);
        }
    }

    public CertificatePoliciesExtension getCertificatePoliciesExtension() {
        return (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id);
    }

    public PrivateKeyUsageExtension getPrivateKeyUsageExtension() {
        return (PrivateKeyUsageExtension)this.getExtension(PKIXExtensions.PrivateKeyUsage_Id);
    }

    private static Collection<List<?>> cloneAltNames(Collection<List<?>> altNames) {
        boolean mustClone = false;
        for (List<?> nameEntry : altNames) {
            if (!(nameEntry.get(1) instanceof byte[])) continue;
            mustClone = true;
        }
        if (mustClone) {
            ArrayList namesCopy = new ArrayList();
            for (List<?> nameEntry : altNames) {
                Object nameObject = nameEntry.get(1);
                if (nameObject instanceof byte[]) {
                    ArrayList nameEntryCopy = new ArrayList(nameEntry);
                    nameEntryCopy.set(1, ((byte[])nameObject).clone());
                    namesCopy.add(Collections.unmodifiableList(nameEntryCopy));
                    continue;
                }
                namesCopy.add(nameEntry);
            }
            return Collections.unmodifiableCollection(namesCopy);
        }
        return altNames;
    }

    private static Collection<List<?>> makeAltNames(GeneralNames names) {
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList newNames = new ArrayList();
        for (GeneralName gname : names) {
            GeneralNameInterface name = gname.getName();
            ArrayList<Object> nameEntry = new ArrayList<Object>(2);
            nameEntry.add(name.getType());
            switch (name.getType()) {
                case 1: {
                    nameEntry.add(((RFC822Name)name).getName());
                    break;
                }
                case 2: {
                    nameEntry.add(((DNSName)name).getName());
                    break;
                }
                case 4: {
                    nameEntry.add(((X500Name)name).getRFC2253Name());
                    break;
                }
                case 6: {
                    nameEntry.add(((URIName)name).getName());
                    break;
                }
                case 7: {
                    try {
                        nameEntry.add(((IPAddressName)name).getName());
                        break;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("IPAddress cannot be parsed: " + ioe.toString());
                    }
                }
                case 8: {
                    nameEntry.add(((OIDName)name).getOID().toString());
                    break;
                }
                default: {
                    DerOutputStream derOut = new DerOutputStream();
                    try {
                        name.encode(derOut);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("name cannot be encoded: " + ioe.toString());
                    }
                    nameEntry.add(derOut.toByteArray());
                }
            }
            newNames.add(Collections.unmodifiableList(nameEntry));
        }
        return Collections.unmodifiableCollection(newNames);
    }

    public synchronized Collection getSubjectAlternativeNames() throws CertificateParsingException {
        GeneralNames names;
        if (this.readOnly && this.subjectAlternativeNames != null) {
            return X509CertImpl.cloneAltNames(this.subjectAlternativeNames);
        }
        SubjectAlternativeNameExtension subjectAltNameExt = this.getSubjectAlternativeNameExtension();
        if (subjectAltNameExt == null) {
            return null;
        }
        try {
            names = subjectAltNameExt.get("subject_name");
            if (names == null) {
                return Collections.EMPTY_SET;
            }
        }
        catch (IOException ioe) {
            return Collections.EMPTY_SET;
        }
        this.subjectAlternativeNames = X509CertImpl.makeAltNames(names);
        return this.subjectAlternativeNames;
    }

    public static Collection getSubjectAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        try {
            GeneralNames names;
            byte[] ext = cert.getExtensionValue(SUB_ALT_NAME_OID);
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            SubjectAlternativeNameExtension subjectAltNameExt = new SubjectAlternativeNameExtension(Boolean.FALSE, data);
            try {
                names = subjectAltNameExt.get("subject_name");
                if (names == null) {
                    return Collections.EMPTY_SET;
                }
            }
            catch (IOException ioe) {
                return Collections.EMPTY_SET;
            }
            return X509CertImpl.makeAltNames(names);
        }
        catch (IOException ioe) {
            CertificateParsingException cpe = new CertificateParsingException(ioe.toString());
            throw cpe;
        }
    }

    public static X500Principal getSubjectX500Principal(X509Certificate cert) {
        try {
            return X509CertImpl.getX500Principal(cert, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse subject", e);
        }
    }

    private static X500Principal getX500Principal(X509Certificate cert, boolean getIssuer) throws Exception {
        byte[] encoded = cert.getEncoded();
        DerInputStream derIn = new DerInputStream(encoded);
        DerValue tbsCert = derIn.getSequence(3)[0];
        DerInputStream tbsIn = tbsCert.getData();
        DerValue tmp = tbsIn.getDerValue();
        if (tmp.isContextSpecific((byte)0)) {
            tmp = tbsIn.getDerValue();
        }
        tmp = tbsIn.getDerValue();
        tmp = tbsIn.getDerValue();
        if (!getIssuer) {
            tmp = tbsIn.getDerValue();
            tmp = tbsIn.getDerValue();
        }
        byte[] principalBytes = tmp.toByteArray();
        return new X500Principal(principalBytes);
    }

    @Override
    public synchronized List<String> getExtendedKeyUsage() throws CertificateParsingException {
        if (this.readOnly && this.extKeyUsage != null) {
            return this.extKeyUsage;
        }
        ExtKeyUsageExtension ext = this.getExtendedKeyUsageExtension();
        if (ext == null) {
            return null;
        }
        this.extKeyUsage = Collections.unmodifiableList(ext.getExtendedKeyUsage());
        return this.extKeyUsage;
    }

    public static List<String> getExtendedKeyUsage(X509Certificate cert) throws CertificateParsingException {
        try {
            byte[] ext = cert.getExtensionValue(EXTENDED_KEY_USAGE_OID);
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            ExtKeyUsageExtension ekuExt = new ExtKeyUsageExtension(Boolean.FALSE, data);
            return Collections.unmodifiableList(ekuExt.getExtendedKeyUsage());
        }
        catch (IOException ioe) {
            throw new CertificateParsingException(ioe);
        }
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", oid);
        }
        try {
            ObjectIdentifier findOID = new ObjectIdentifier(oid);
            String extAlias = OIDMap.getName(findOID);
            Extension certExt = null;
            if (extAlias == null) {
                CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
                if (exts == null) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
                    }
                    return null;
                }
                for (Extension ex : exts.getAllExtensions()) {
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals((Object)findOID)) continue;
                    certExt = ex;
                    break;
                }
            } else {
                if (this.info == null) {
                    return null;
                }
                certExt = this.info.getExt(extAlias.substring(extAlias.indexOf("extensions")));
            }
            if (certExt == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            byte[] extData = certExt.getExtensionValue();
            if (extData == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            byte[] result = out.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_3", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", e);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyUsage");
        }
        try {
            String extAlias = OIDMap.getName(PKIXExtensions.KeyUsage_Id);
            if (extAlias == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getKeyUsage_1", null);
                }
                return null;
            }
            KeyUsageExtension certExt = (KeyUsageExtension)this.get(extAlias);
            if (certExt == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getKeyUsage_2", null);
                }
                return null;
            }
            boolean[] ret = certExt.getBits();
            if (ret.length < 9) {
                boolean[] usageBits = new boolean[9];
                System.arraycopy(ret, 0, usageBits, 0, ret.length);
                ret = usageBits;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyUsage", ret);
            }
            return ret;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getKeyUsage", e);
                debug.exit(16384L, (Object)className, "getKeyUsage_3", null);
            }
            return null;
        }
    }

    @Override
    public int getBasicConstraints() {
        if (debug != null) {
            debug.entry(16384L, className, "getBasicConstraints");
        }
        try {
            String extAlias = OIDMap.getName(PKIXExtensions.BasicConstraints_Id);
            if (extAlias == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getBasicConstraints_1", new Integer(-1));
                }
                return -1;
            }
            BasicConstraintsExtension certExt = (BasicConstraintsExtension)this.get(extAlias);
            if (certExt == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getBasicConstraints_2", new Integer(-1));
                }
                return -1;
            }
            if (((Boolean)certExt.get("is_ca")).booleanValue()) {
                int result = (Integer)certExt.get("path_len");
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getBasicConstraints", new Integer(result));
                }
                return result;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getBasicConstraints_3", new Integer(-1));
            }
            return -1;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "getBasicConstraints", e);
                debug.exit(16384L, (Object)className, "getBasicConstraints_4", new Integer(-1));
            }
            return -1;
        }
    }

    private void parse(DerValue val) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", val);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "cannot over-write existing certificate");
            }
            throw new CertificateParsingException("cannot over-write existing certificate");
        }
        if (val.getData() == null) {
            throw new CertificateParsingException("invalid DER-encoded certificate data");
        }
        this.signedCert = val.toByteArray();
        DerValue[] seq = new DerValue[]{val.getData().getDerValue(), val.getData().getDerValue(), val.getData().getDerValue()};
        if (val.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed overrun, bytes = " + val.getData().available());
            }
            throw new CertificateParsingException("signed overrun, bytes = " + val.getData().available());
        }
        if (seq[0].getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields invalid");
            }
            throw new CertificateParsingException("signed fields invalid");
        }
        this.algId = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "algid field overrun");
            }
            throw new CertificateParsingException("algid field overrun");
        }
        if (seq[2].getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "signed fields overrun");
            }
            throw new CertificateParsingException("signed fields overrun");
        }
        this.info = this.provider != null ? new X509CertInfo(seq[0], this.provider) : new X509CertInfo(seq[0]);
        AlgorithmId infoSigAlg = (AlgorithmId)this.info.get("algorithmID.algorithm");
        if (!this.algId.equals(infoSigAlg)) {
            if (debug != null) {
                debug.text(16384L, className, "parse", "Signature algorithm mismatch");
            }
            throw new CertificateException("Signature algorithm mismatch");
        }
        this.readOnly = true;
        if (debug != null) {
            debug.exit(16384L, className, "parse");
        }
    }

    public Extension getExtension(ObjectIdentifier oid) {
        if (this.info == null) {
            return null;
        }
        String name = OIDMap.getName(oid);
        if (name == null) {
            try {
                CertificateExtensions extensions = null;
                try {
                    extensions = (CertificateExtensions)this.info.get("extensions");
                }
                catch (CertificateException ce) {
                    return null;
                }
                if (extensions == null) {
                    return null;
                }
                Extension ex = extensions.getExt(oid.toString());
                if (ex != null) {
                    return ex;
                }
                for (Extension ex2 : extensions.getAllExtensions()) {
                    if (!ex2.getExtensionId().equals((Object)oid)) continue;
                    return ex2;
                }
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return this.info.getExt(name.substring(name.indexOf("extensions")));
    }

    public static X509CertImpl toImpl(X509Certificate cert) throws CertificateException {
        if (cert instanceof X509CertImpl) {
            return (X509CertImpl)cert;
        }
        byte[] encoding = cert.getEncoded();
        X509CertImpl newC = new X509CertImpl(encoding);
        return newC;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.info == null) {
            return null;
        }
        if (this.issuerX500Principal == null || !this.readOnly) {
            try {
                DerOutputStream out = new DerOutputStream();
                ((X500Name)this.getIssuerDN()).encode(out);
                this.issuerX500Principal = new X500Principal(out.toByteArray());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.issuerX500Principal;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        if (this.info == null) {
            return null;
        }
        if (this.subjectX500Principal == null || !this.readOnly) {
            try {
                DerOutputStream out = new DerOutputStream();
                ((X500Name)this.getSubjectDN()).encode(out);
                this.subjectX500Principal = new X500Principal(out.toByteArray());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.subjectX500Principal;
    }

    public static boolean isSelfIssued(X509Certificate cert) {
        X500Principal subject = cert.getSubjectX500Principal();
        X500Principal issuer = cert.getIssuerX500Principal();
        return subject.equals(issuer);
    }

    public static boolean isSelfSigned(X509Certificate cert, String sigProvider) {
        if (X509CertImpl.isSelfIssued(cert)) {
            try {
                if (sigProvider == null) {
                    cert.verify(cert.getPublicKey());
                } else {
                    cert.verify(cert.getPublicKey(), sigProvider);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static byte[] getEncodedInternal(Certificate cert) throws CertificateEncodingException {
        if (cert instanceof X509CertImpl) {
            return ((X509CertImpl)cert).getEncodedInternal();
        }
        return cert.getEncoded();
    }

    public AuthorityInfoAccessExtension getAuthorityInfoAccessExtension() {
        return (AuthorityInfoAccessExtension)this.getExtension(PKIXExtensions.AuthorityInfoAccess_Id);
    }

    public CRLDistributionPointsExtension getCRLDistributionPointsExtension() {
        return (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id);
    }

    public SubjectKeyIdentifierExtension getSubjectKeyIdentifierExtension() {
        return (SubjectKeyIdentifierExtension)this.getExtension(PKIXExtensions.SubjectKey_Id);
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyId == null) {
            SubjectKeyIdentifierExtension ski = this.getSubjectKeyIdentifierExtension();
            if (ski != null) {
                try {
                    this.subjectKeyId = ski.get("key_id").getIdentifier();
                }
                catch (IOException iOException) {}
            } else {
                this.subjectKeyId = new byte[0];
            }
        }
        return this.subjectKeyId.length != 0 ? this.subjectKeyId : null;
    }

    public byte[] getIssuerKeyIdentifier() {
        block6: {
            if (this.issuerKeyId == null) {
                AuthorityKeyIdentifierExtension aki = this.getAuthorityKeyIdentifierExtension();
                if (aki != null) {
                    try {
                        KeyIdentifier issuerKeyIdentifier = (KeyIdentifier)aki.get("key_id");
                        if (null != issuerKeyIdentifier) {
                            this.issuerKeyId = issuerKeyIdentifier.getIdentifier();
                            break block6;
                        }
                        this.issuerKeyId = new byte[0];
                    }
                    catch (IOException iOException) {}
                } else {
                    this.issuerKeyId = new byte[0];
                }
            }
        }
        return this.issuerKeyId.length != 0 ? this.issuerKeyId : null;
    }

    public String getFingerprint(String algorithm) {
        return this.fingerprints.computeIfAbsent(algorithm, x -> X509CertImpl.getFingerprint(x, this));
    }

    public static String getFingerprint(String algorithm, X509Certificate cert) {
        String fingerPrint = "";
        try {
            byte[] encCertInfo = cert.getEncoded();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(encCertInfo);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                X509CertImpl.byte2hex(digest[i], buf);
            }
            fingerPrint = buf.toString();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            // empty catch block
        }
        return fingerPrint;
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("X509CertImpls are not directly deserializable");
    }
}

