/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.text.Normalizer;
import com.ibm.security.x509.AVAKeyword;
import com.ibm.security.x509.X500Name;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class AVA
implements DerEncoder {
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    private static final String specialChars1779 = ",=\n+<>#;\\\"";
    private static final String specialChars2253 = ",=+<>#;\\\"";
    private static final String specialCharsDefault = ",=\n+<>#;\\\" ";
    private static final String escapedDefault = ",+<>;\"";
    private static final String hexDigits = "0123456789ABCDEF";
    private static final String digits = "0123456789ABCDEF";
    final ObjectIdentifier oid;
    final DerValue value;
    private String valueString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AVA";

    public AVA(ObjectIdentifier type, DerValue val) {
        if (debug != null) {
            debug.entry(16384L, className, "AVA", type, val);
        }
        if (type == null || val == null) {
            throw new NullPointerException();
        }
        this.oid = type;
        this.value = val;
        if (debug != null) {
            debug.text(16384L, className, "AVA", "AVA() oid = " + this.oid);
            debug.text(16384L, className, "AVA", "AVA() value = " + this.value);
            debug.exit(16384L, className, "AVA");
        }
    }

    AVA(Reader in) throws IOException {
        this(in, 1);
    }

    AVA(Reader in, Map<String, String> keywordMap) throws IOException {
        this(in, 1, keywordMap);
    }

    AVA(Reader in, int format) throws IOException {
        this(in, format, Collections.emptyMap());
    }

    AVA(Reader in, int format, Map<String, String> keywordMap) throws IOException {
        int c;
        if (debug != null) {
            debug.entry(16384L, className, "AVA", in, new Integer(format));
        }
        StringBuilder temp = new StringBuilder();
        while ((c = AVA.readChar(in, "Incorrect AVA format")) != 61) {
            temp.append((char)c);
        }
        this.oid = AVAKeyword.getOID(temp.toString(), format, keywordMap);
        temp.setLength(0);
        if (format == 3) {
            c = in.read();
            if (c == 32) {
                throw new IOException("Incorrect AVA RFC2253 format - leading space must be escaped");
            }
        } else {
            while ((c = in.read()) == 32 || c == 10) {
            }
        }
        if (c == -1) {
            this.value = this.oid.equals(X500Name.emailAddress_oid) || this.oid.equals(X500Name.domainComponent_oid) ? new DerValue(22, "") : new DerValue("");
            return;
        }
        this.value = c == 35 ? AVA.parseHexString(in, format) : (c == 34 && format != 3 ? this.parseQuotedString(in, temp) : this.parseString(in, c, format, temp));
    }

    public AVA(String ava) throws IOException {
        this(new StringReader(ava));
    }

    AVA(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AVA", in);
        }
        StringBuilder temp = new StringBuilder();
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parseInputStream", in);
        }
        while (true) {
            int byteRead;
            if ((byteRead = in.read()) == -1) {
                if (debug != null) {
                    debug.text(8192L, className, "parseInputStream", "Incorrect AVA format");
                }
                throw new IOException("Incorrect AVA format");
            }
            if ((char)byteRead == '=') break;
            temp.append((char)byteRead);
        }
        String keyword = temp.toString().toUpperCase(Locale.US).trim();
        int dertype = 19;
        if (keyword.equals("CN")) {
            this.oid = X500Name.commonName_oid;
        } else if (keyword.equals("C")) {
            this.oid = X500Name.countryName_oid;
        } else if (keyword.equals("L")) {
            this.oid = X500Name.localityName_oid;
        } else if (keyword.equals("S") || keyword.equals("ST")) {
            this.oid = X500Name.stateName_oid;
        } else if (keyword.equals("O")) {
            this.oid = X500Name.orgName_oid;
        } else if (keyword.equals("OU")) {
            this.oid = X500Name.orgUnitName_oid;
        } else if (keyword.equals("T") || keyword.equals("TITLE")) {
            this.oid = X500Name.title_oid;
        } else if (keyword.equals("IP")) {
            this.oid = X500Name.ipAddress_oid;
        } else if (keyword.equals("STREET")) {
            this.oid = X500Name.streetAddress_oid;
        } else if (keyword.equals("EMAIL") || keyword.equals("EMAILADDRESS")) {
            this.oid = X500Name.emailAddress_oid;
            dertype = 22;
        } else if (keyword.equals("SERIALNUMBER")) {
            this.oid = X500Name.serialNumber_oid;
        } else if (keyword.equals("DC")) {
            this.oid = X500Name.domainComponent_oid;
            dertype = 22;
        } else if (keyword.startsWith("OID.")) {
            this.oid = new ObjectIdentifier(keyword.substring(4));
        } else if (keyword.equals("POSTALCODE")) {
            this.oid = X500Name.postalCode_oid;
        } else if (keyword.equals("DNQ") || keyword.equals("DNQUALIFIER")) {
            this.oid = X500Name.dnQualifier_oid;
        } else if (keyword.equals("PSEUDONYM")) {
            this.oid = X500Name.pseudonym_oid;
        } else if (keyword.equals("SURNAME") || keyword.equals("SN")) {
            this.oid = X500Name.surName_oid;
        } else if (keyword.equals("GIVENNAME")) {
            this.oid = X500Name.givenName_oid;
        } else if (keyword.equals("INITIALS")) {
            this.oid = X500Name.initials_oid;
        } else if (keyword.equals("GENERATION") || keyword.equals("GENERATIONQUALIFIER")) {
            this.oid = X500Name.generationQualifier_oid;
        } else if (keyword.equals("UID")) {
            this.oid = X500Name.userid_oid;
        } else {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "unsupported keyword " + keyword);
            }
            throw new IOException("unsupported keyword " + keyword);
        }
        temp = new StringBuilder();
        char c = (char)in.read();
        while (c == ' ' || c == '\n') {
            c = (char)in.read();
        }
        if (c == '\uffffffff') {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "Incorrect AVA format");
            }
            throw new IOException("Incorrect AVA format");
        }
        if (c == '#') {
            if (debug != null) {
                debug.text(8192L, className, "parseInputStream", "AVA parse, hex values!");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int b = 0;
            int cNdx = 0;
            while (!AVA.isTerminator((short)(c = (char)in.read()), 1)) {
                int cVal = "0123456789ABCDEF".indexOf(Character.toUpperCase(c));
                if (cVal == -1) {
                    throw new IOException("AVA parse, invalid hex digit: " + c);
                }
                if (cNdx % 2 == 1) {
                    b = (byte)(b * 16 + (byte)cVal);
                    baos.write(b);
                } else {
                    b = (byte)cVal;
                }
                ++cNdx;
            }
            if (cNdx == 0) {
                throw new IOException("AVA parse, zero hex digits");
            }
            if (cNdx % 2 == 1) {
                throw new IOException("AVA parse, odd number of hex digits");
            }
            byte[] byteArray = baos.toByteArray();
            this.value = new DerValue(byteArray);
        } else if (c == '\"') {
            int r = in.read();
            c = (char)r;
            while (r != -1 && c != '\"') {
                if (c == '\\') {
                    c = (char)in.read();
                }
                temp.append(c);
                r = in.read();
                c = (char)r;
            }
            this.value = new DerValue((byte)dertype, temp.toString().trim());
        } else {
            int r;
            do {
                if (c == '\\') {
                    c = (char)in.read();
                }
                temp.append(c);
                r = in.read();
                c = (char)r;
            } while (r != -1 && c != '+' && c != ',' && c != ';' && c != '>');
            this.value = new DerValue((byte)dertype, temp.toString().trim());
        }
        if (debug != null) {
            debug.exit(8192L, className, "parseInputStream");
        }
    }

    private static boolean isTerminator(int ch, int format) {
        switch (ch) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: {
                return format != 3;
            }
        }
        return false;
    }

    public AVA(DerInputStream in) throws IOException {
        DerValue assertion;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AVA", in);
        }
        if ((assertion = in.getDerValue()).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AVA", "X500 AVA, not a sequence");
            }
            throw new IOException("X500 AVA, not a sequence");
        }
        this.oid = assertion.getData().getOID();
        this.value = assertion.getData().getDerValue();
        if (assertion.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "AVA", "AVA, extra bytes = " + assertion.getData().available());
            }
            throw new IOException("AVA, extra bytes = " + assertion.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "AVA");
        }
    }

    ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    String getValueString() {
        try {
            String s = this.value.getAsString();
            if (s == null) {
                throw new RuntimeException("AVA string is null");
            }
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException("AVA error: " + e, e);
        }
    }

    private static DerValue parseHexString(Reader in, int format) throws IOException {
        int c;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = 0;
        int cNdx = 0;
        while (!AVA.isTerminator(c = in.read(), format)) {
            int cVal = "0123456789ABCDEF".indexOf(Character.toUpperCase((char)c));
            if (cVal == -1) {
                throw new IOException("AVA parse, invalid hex digit: " + (char)c);
            }
            if (cNdx % 2 == 1) {
                b = (byte)(b * 16 + (byte)cVal);
                baos.write(b);
            } else {
                b = (byte)cVal;
            }
            ++cNdx;
        }
        if (cNdx == 0) {
            throw new IOException("AVA parse, zero hex digits");
        }
        if (cNdx % 2 == 1) {
            throw new IOException("AVA parse, odd number of hex digits");
        }
        return new DerValue(baos.toByteArray());
    }

    private DerValue parseQuotedString(Reader in, StringBuilder temp) throws IOException {
        String hexString;
        int c = AVA.readChar(in, "Quoted string did not end in quote");
        ArrayList<Byte> embeddedHex = new ArrayList<Byte>();
        boolean isPrintableString = true;
        while (c != 34) {
            if (c == 92) {
                c = AVA.readChar(in, "Quoted string did not end in quote");
                Byte hexByte = null;
                hexByte = AVA.getEmbeddedHexPair(c, in);
                if (hexByte != null) {
                    isPrintableString = false;
                    embeddedHex.add(hexByte);
                    c = in.read();
                    continue;
                }
                if (specialChars1779.indexOf((char)c) < 0) {
                    throw new IOException("Invalid escaped character in AVA: " + (char)c);
                }
            }
            if (embeddedHex.size() > 0) {
                hexString = AVA.getEmbeddedHexString(embeddedHex);
                temp.append(hexString);
                embeddedHex.clear();
            }
            isPrintableString &= DerValue.isPrintableStringChar((char)c);
            temp.append((char)c);
            c = AVA.readChar(in, "Quoted string did not end in quote");
        }
        if (embeddedHex.size() > 0) {
            hexString = AVA.getEmbeddedHexString(embeddedHex);
            temp.append(hexString);
            embeddedHex.clear();
        }
        while ((c = in.read()) == 10 || c == 32) {
        }
        if (c != -1) {
            throw new IOException("AVA had characters other than whitespace after terminating quote");
        }
        if (this.oid.equals(X500Name.emailAddress_oid) || this.oid.equals(X500Name.domainComponent_oid)) {
            return new DerValue(22, temp.toString().trim());
        }
        if (isPrintableString) {
            return new DerValue(temp.toString().trim());
        }
        return new DerValue(12, temp.toString().trim());
    }

    private DerValue parseString(Reader in, int c, int format, StringBuilder temp) throws IOException {
        ArrayList<Byte> embeddedHex = new ArrayList<Byte>();
        boolean isPrintableString = true;
        boolean escape = false;
        boolean leadingChar = true;
        int spaceCount = 0;
        do {
            escape = false;
            if (c == 92) {
                escape = true;
                c = AVA.readChar(in, "Invalid trailing backslash");
                Byte hexByte = null;
                hexByte = AVA.getEmbeddedHexPair(c, in);
                if (hexByte != null) {
                    isPrintableString = false;
                    embeddedHex.add(hexByte);
                    c = in.read();
                    leadingChar = false;
                    continue;
                }
                if (format == 1 && specialCharsDefault.indexOf((char)c) == -1) {
                    throw new IOException("Invalid escaped character in AVA: '" + (char)c + "'");
                }
                if (format == 3) {
                    if (c == 32) {
                        if (!leadingChar && !AVA.trailingSpace(in)) {
                            throw new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped.");
                        }
                    } else if (c == 35) {
                        if (!leadingChar) {
                            throw new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped.");
                        }
                    } else if (specialChars2253.indexOf((char)c) == -1) {
                        throw new IOException("Invalid escaped character in AVA: '" + (char)c + "'");
                    }
                }
            } else if (format == 3 ? specialChars2253.indexOf((char)c) != -1 : escapedDefault.indexOf((char)c) != -1) {
                throw new IOException("Character '" + (char)c + "' in AVA appears without escape");
            }
            if (embeddedHex.size() > 0) {
                for (int i = 0; i < spaceCount; ++i) {
                    temp.append(" ");
                }
                spaceCount = 0;
                String hexString = AVA.getEmbeddedHexString(embeddedHex);
                temp.append(hexString);
                embeddedHex.clear();
            }
            isPrintableString &= DerValue.isPrintableStringChar((char)c);
            if (c == 32 && !escape) {
                ++spaceCount;
            } else {
                for (int i = 0; i < spaceCount; ++i) {
                    temp.append(" ");
                }
                spaceCount = 0;
                temp.append((char)c);
            }
            c = in.read();
            leadingChar = false;
        } while (!AVA.isTerminator(c, format));
        if (format == 3 && spaceCount > 0) {
            throw new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped");
        }
        if (embeddedHex.size() > 0) {
            String hexString = AVA.getEmbeddedHexString(embeddedHex);
            temp.append(hexString);
            embeddedHex.clear();
        }
        if (this.oid.equals(X500Name.emailAddress_oid) || this.oid.equals(X500Name.domainComponent_oid)) {
            return new DerValue(22, temp.toString());
        }
        if (isPrintableString) {
            return new DerValue(temp.toString());
        }
        return new DerValue(12, temp.toString());
    }

    private static Byte getEmbeddedHexPair(int c1, Reader in) throws IOException {
        if ("0123456789ABCDEF".indexOf(Character.toUpperCase((char)c1)) >= 0) {
            int c2 = AVA.readChar(in, "unexpected EOF - escaped hex value must include two valid digits");
            if ("0123456789ABCDEF".indexOf(Character.toUpperCase((char)c2)) >= 0) {
                int hi = Character.digit((char)c1, 16);
                int lo = Character.digit((char)c2, 16);
                return new Byte((byte)((hi << 4) + lo));
            }
            throw new IOException("escaped hex value must include two valid digits");
        }
        return null;
    }

    private static String getEmbeddedHexString(List<Byte> hexList) throws IOException {
        byte[] hexBytes = new byte[hexList.size()];
        for (int i = 0; i < hexList.size(); ++i) {
            hexBytes[i] = hexList.get(i);
        }
        return new String(hexBytes, "UTF8");
    }

    private static boolean trailingSpace(Reader in) throws IOException {
        boolean trailing;
        block3: {
            block4: {
                trailing = false;
                if (!in.markSupported()) {
                    return true;
                }
                in.mark(9999);
                while (true) {
                    int nextChar;
                    if ((nextChar = in.read()) == -1) {
                        trailing = true;
                        break block3;
                    }
                    if (nextChar == 32) continue;
                    if (nextChar != 92) break block4;
                    int followingChar = in.read();
                    if (followingChar != 32) break;
                }
                trailing = false;
                break block3;
            }
            trailing = false;
        }
        in.reset();
        return trailing;
    }

    private static int readChar(Reader in, String errMsg) throws IOException {
        int c = in.read();
        if (c == -1) {
            throw new IOException(errMsg);
        }
        return c;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AVA)) {
            return false;
        }
        AVA obj = (AVA)other;
        return this.toRFC2253CanonicalString().equals(obj.toRFC2253CanonicalString());
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        tmp.putOID(this.oid);
        this.value.encode(tmp);
        tmp2.write((byte)48, tmp);
        out.write(tmp2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    private String toKeyword(int format, Map<String, String> oidMap) {
        return AVAKeyword.getKeyword(this.oid, format, oidMap);
    }

    private static boolean isDerString(DerValue value, boolean canonical) {
        if (canonical) {
            switch (value.getTag()) {
                case 12: 
                case 19: 
                case 20: 
                case 22: {
                    return true;
                }
            }
            return false;
        }
        switch (value.getTag()) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String keyword = this.toKeywordValueString(this.toKeyword(1, Collections.emptyMap()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", keyword);
        }
        return keyword;
    }

    public String getName() {
        String retval = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        retval = this.oid.equals(X500Name.commonName_oid) ? "CN" : (this.oid.equals(X500Name.countryName_oid) ? "C" : (this.oid.equals(X500Name.localityName_oid) ? "L" : (this.oid.equals(X500Name.stateName_oid) ? "ST" : (this.oid.equals(X500Name.orgName_oid) ? "O" : (this.oid.equals(X500Name.orgUnitName_oid) ? "OU" : (this.oid.equals(X500Name.title_oid) ? "T" : (this.oid.equals(X500Name.ipAddress_oid) ? "IP" : (this.oid.equals(X500Name.streetAddress_oid) ? "STREET" : (this.oid.equals(X500Name.domainComponent_oid) ? "DC" : (this.oid.equals(X500Name.dnQualifier_oid) ? "DNQ" : (this.oid.equals(X500Name.pseudonym_oid) ? "PSEUDONYM" : (this.oid.equals(X500Name.surName_oid) ? "SURNAME" : (this.oid.equals(X500Name.givenName_oid) ? "GIVENNAME" : (this.oid.equals(X500Name.initials_oid) ? "INITIALS" : (this.oid.equals(X500Name.generationQualifier_oid) ? "GENERATION" : (this.oid.equals(X500Name.emailAddress_oid) ? "EMAILADDRESS" : (this.oid.equals(X500Name.userid_oid) ? "UID" : (this.oid.equals(X500Name.serialNumber_oid) ? "SERIALNUMBER" : (this.oid.equals(X500Name.postalCode_oid) ? "POSTALCODE" : "OID." + this.oid.toString())))))))))))))))))));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", retval);
        }
        return retval;
    }

    public String toRFC1779String() {
        return this.toRFC1779String(Collections.emptyMap());
    }

    public String toRFC1779String(Map<String, String> oidMap) {
        return this.toKeywordValueString(this.toKeyword(2, oidMap));
    }

    public String toRFC2253String() {
        return this.toRFC2253String(Collections.emptyMap());
    }

    public String toRFC2253String(Map<String, String> oidMap) {
        StringBuilder typeAndValue = new StringBuilder(100);
        typeAndValue.append(this.toKeyword(3, oidMap));
        typeAndValue.append('=');
        if (typeAndValue.charAt(0) >= '0' && typeAndValue.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] data = null;
            try {
                data = this.value.toByteArray();
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            typeAndValue.append('#');
            for (int j = 0; j < data.length; ++j) {
                byte b = data[j];
                typeAndValue.append(Character.forDigit(0xF & b >>> 4, 16));
                typeAndValue.append(Character.forDigit(0xF & b, 16));
            }
        } else {
            int trail;
            int lead;
            String valStr = null;
            try {
                valStr = this.getValueStr();
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            String escapees = ",=+<>#;\"\\";
            char[] chars = valStr.toCharArray();
            StringBuilder buf = new StringBuilder(2 * valStr.length());
            for (lead = 0; lead < chars.length && (chars[lead] == ' ' || chars[lead] == '\r'); ++lead) {
            }
            for (trail = chars.length - 1; trail >= 0 && (chars[trail] == ' ' || chars[trail] == '\r'); --trail) {
            }
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (i >= lead || i <= trail) {
                    if (",=+<>#;\"\\".indexOf(c) >= 0) {
                        buf.append('\\');
                        buf.append(c);
                        continue;
                    }
                    if (c == '\u0000') {
                        buf.append("\\00");
                        continue;
                    }
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            typeAndValue.append(buf.toString());
        }
        return typeAndValue.toString();
    }

    public String toRFC2253CanonicalString() {
        StringBuilder typeAndValue = new StringBuilder(40);
        typeAndValue.append(this.toKeyword(3, Collections.emptyMap()));
        typeAndValue.append('=');
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString", this.toKeyword(3, Collections.emptyMap()));
        }
        if (typeAndValue.charAt(0) >= '0' && typeAndValue.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            byte[] data = null;
            try {
                data = this.value.toByteArray();
                if (debug != null) {
                    debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:digit", (Object)data);
                }
            }
            catch (IOException ie) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "toRFC2253CanonicalString_1", "DER Value conversion");
                }
                throw new IllegalArgumentException("DER Value conversion");
            }
            if (this.oid == X500Name.emailAddress_oid) {
                try {
                    typeAndValue.append(this.value.getIA5String());
                }
                catch (IOException e) {
                    typeAndValue.append('#');
                    for (int j = 0; j < data.length; ++j) {
                        byte b = data[j];
                        typeAndValue.append(Character.forDigit(0xF & b >>> 4, 16));
                        typeAndValue.append(Character.forDigit(0xF & b, 16));
                    }
                }
            } else {
                typeAndValue.append('#');
                for (int j = 0; j < data.length; ++j) {
                    byte b = data[j];
                    typeAndValue.append(Character.forDigit(0xF & b >>> 4, 16));
                    typeAndValue.append(Character.forDigit(0xF & b, 16));
                }
            }
        } else {
            int trail;
            String valStr = null;
            try {
                valStr = this.getValueStr();
            }
            catch (IOException ie) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "toRFC2253CanonicalString_2", "DER Value conversion");
                }
                throw new IllegalArgumentException("DER Value conversion");
            }
            String escapees = ",=<>;\"\\";
            char[] chars = valStr.toCharArray();
            StringBuilder buf = new StringBuilder(2 * valStr.length());
            if (chars.length > 0 && chars[0] == '#') {
                buf.append('\\');
            }
            for (int lead = 0; lead < chars.length && Character.isWhitespace(chars[lead]); ++lead) {
            }
            for (trail = chars.length - 1; trail >= 0 && Character.isWhitespace(chars[trail]); --trail) {
            }
            boolean previousWhite = false;
            for (int i = lead; i <= trail; ++i) {
                char c = chars[i];
                if (!Character.isWhitespace(c)) {
                    previousWhite = false;
                    if (",=<>;\"\\".indexOf(c) >= 0) {
                        buf.append('\\');
                    }
                    buf.append(c);
                    continue;
                }
                if (previousWhite) continue;
                previousWhite = true;
                buf.append(c);
            }
            typeAndValue.append(buf.toString().trim());
        }
        String canon = typeAndValue.toString();
        canon = canon.toUpperCase(Locale.US).toLowerCase(Locale.US);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:canon", canon);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toRFC2253CanonicalString", "DONE");
        }
        String normalized = Normalizer.normalize(canon, Normalizer.DECOMP_COMPAT, 0);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253CanonicalString:normalized", normalized);
        }
        return normalized;
    }

    private String toKeywordValueString(String keyword) {
        StringBuilder retval = new StringBuilder(40);
        retval.append(keyword);
        retval.append("=");
        try {
            String temp = this.value.getTag() == 3 ? null : this.getValueStr();
            if (temp == null) {
                byte[] data = this.value.toByteArray();
                retval.append('#');
                for (int i = 0; i < data.length; ++i) {
                    retval.append("0123456789ABCDEF".charAt(data[i] >> 4 & 0xF));
                    retval.append("0123456789ABCDEF".charAt(data[i] & 0xF));
                }
            } else {
                int i;
                boolean quoteNeeded = false;
                int len = temp.length();
                for (i = 0; i < specialChars1779.length(); ++i) {
                    if (temp.indexOf(specialChars1779.charAt(i)) == -1) continue;
                    quoteNeeded = true;
                    break;
                }
                if (!(len <= 0 || quoteNeeded || temp.charAt(0) != ' ' && temp.charAt(0) != '\n' && temp.charAt(len - 1) != ' ' && temp.charAt(len - 1) != '\n')) {
                    quoteNeeded = true;
                }
                if (len > 0 && !quoteNeeded) {
                    boolean lastWasSpace = false;
                    for (i = 1; i < len - 2; ++i) {
                        if (temp.charAt(i) == ' ' || temp.charAt(i) == '\n') {
                            if (lastWasSpace) {
                                quoteNeeded = true;
                                break;
                            }
                            lastWasSpace = true;
                            continue;
                        }
                        lastWasSpace = false;
                    }
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
                for (i = 0; i < len; ++i) {
                    char c = temp.charAt(i);
                    if (c == '\"' || c == '\\') {
                        retval.append('\\');
                    }
                    retval.append(c);
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("DER Value conversion");
        }
        return retval.toString();
    }

    private String getValueStr() throws IOException {
        if (this.valueString == null) {
            byte[] retVal = null;
            switch (this.value.getTag()) {
                case 30: {
                    this.valueString = this.value.getBMPStringAsString();
                    break;
                }
                case 20: {
                    retVal = this.value.getDataBytes();
                    this.valueString = new String(retVal, "ISO-8859-1");
                    break;
                }
                case 19: {
                    retVal = this.value.getDataBytes();
                    this.valueString = new String(retVal, "UTF-8");
                    break;
                }
                case 0: {
                    retVal = this.value.getDataBytes();
                    this.valueString = DerValue.getUniversalString(retVal);
                    break;
                }
                case 12: {
                    retVal = this.value.getDataBytes();
                    this.valueString = DerValue.getUTF8String(retVal);
                    break;
                }
                case 22: {
                    this.valueString = this.value.getIA5String();
                    break;
                }
                default: {
                    retVal = this.value.getDataBytes();
                    this.valueString = new String(retVal, "UTF-8");
                }
            }
        }
        return this.valueString;
    }

    public String getValue() {
        StringBuilder retval = new StringBuilder(30);
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        try {
            String temp = this.value.getAsString().trim();
            if (temp == null) {
                byte[] data = this.value.toByteArray();
                retval.append('#');
                for (int i = 0; i < data.length; ++i) {
                    retval.append("0123456789ABCDEF".charAt(data[i] >> 4 & 0xF));
                    retval.append("0123456789ABCDEF".charAt(data[i] & 0xF));
                }
            } else {
                int i;
                boolean quoteNeeded = false;
                int len = temp.length();
                for (i = 0; i < specialChars1779.length(); ++i) {
                    if (temp.indexOf(specialChars1779.charAt(i)) == -1) continue;
                    quoteNeeded = true;
                    break;
                }
                if (!(len <= 0 || quoteNeeded || temp.charAt(0) != ' ' && temp.charAt(0) != '\n' && temp.charAt(len - 1) != ' ' && temp.charAt(len - 1) != '\n')) {
                    quoteNeeded = true;
                }
                if (len > 0 && !quoteNeeded) {
                    boolean lastWasSpace = false;
                    for (i = 1; i < len - 2; ++i) {
                        if (temp.charAt(i) == ' ' || temp.charAt(i) == '\n') {
                            if (lastWasSpace) {
                                quoteNeeded = true;
                                break;
                            }
                            lastWasSpace = true;
                            continue;
                        }
                        lastWasSpace = false;
                    }
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
                for (i = 0; i < len; ++i) {
                    char c = temp.charAt(i);
                    if (c == '\"' || c == '\\') {
                        retval.append('\\');
                    }
                    retval.append(c);
                }
                if (quoteNeeded) {
                    retval.append('\"');
                }
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", e);
            }
            throw new IllegalArgumentException("DER Value conversion");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", retval.toString());
        }
        return retval.toString();
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.oid);
        }
        return this.oid;
    }

    public DerValue getDerValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerValue");
        }
        if (this.value != null) {
            DerValue retval = new DerValue(this.value.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDerValue_1", retval);
            }
            return retval;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDerValue_2", this.value);
        }
        return this.value;
    }
}

