/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    boolean allowBER = true;

    DerInputBuffer(byte[] buf) {
        this(buf, true);
    }

    DerInputBuffer(byte[] buf, boolean allowBER) {
        super(buf);
        this.allowBER = allowBER;
    }

    DerInputBuffer(byte[] buf, int offset, int len, boolean allowBER) {
        super(buf, offset, len);
        this.allowBER = allowBER;
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer retval = (DerInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    void rewind(int length) {
        if (length <= this.pos) {
            this.pos -= length;
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)other);
        }
        return false;
    }

    boolean equals(DerInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        boolean isEqual = true;
        for (int i = 0; i < max; ++i) {
            if (this.buf[this.pos + i] == other.buf[other.pos + i]) continue;
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        int retval = 0;
        int len = this.available();
        int p = this.pos;
        for (int i = 0; i < len; ++i) {
            retval += this.buf[p + i] * i;
        }
        return retval;
    }

    void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    BigInteger getBigInteger(int len, boolean makePositive) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of integer");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        if (!this.allowBER && len >= 2 && bytes[0] == 0 && bytes[1] >= 0) {
            throw new IOException("Invalid encoding: redundant leading 0s");
        }
        if (makePositive) {
            return new BigInteger(1, bytes);
        }
        return new BigInteger(bytes);
    }

    int getSigned(int len) throws IOException {
        int result = 0;
        if (len > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        byte[] data = new byte[len];
        System.arraycopy(this.buf, this.pos, data, 0, len);
        for (int i = 0; i < len; ++i) {
            result |= (data[i] & 0xFF) << 8 * (len - (i + 1));
        }
        if (len > 0 && (data[0] & 0x80) == 128) {
            result |= -1 << 8 * len;
        }
        this.skip(len);
        return result;
    }

    static int checkPaddedBits(int numOfPadBits, byte[] data, int start, int end, boolean allowBER) throws IOException {
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        int lenInBits = (end - start << 3) - numOfPadBits;
        if (lenInBits < 0) {
            throw new IOException("Not enough bytes in BitString");
        }
        if (!allowBER && numOfPadBits != 0 && (data[end - 1] & 255 >>> 8 - numOfPadBits) != 0) {
            throw new IOException("Invalid value of padding bits");
        }
        return lenInBits;
    }

    byte[] getBitString(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        byte numOfPadBits = this.buf[this.pos];
        DerInputBuffer.checkPaddedBits(numOfPadBits, this.buf, this.pos + 1, this.pos + len, this.allowBER);
        byte[] retval = Arrays.copyOfRange(this.buf, this.pos + 1, this.pos + len);
        if (this.allowBER && numOfPadBits != 0) {
            int n = retval.length - 1;
            retval[n] = (byte)(retval[n] & 255 << numOfPadBits);
        }
        this.skip(len);
        return retval;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    BitArray getUnalignedBitString() throws IOException {
        if (this.pos >= this.count) {
            return null;
        }
        int len = this.available();
        if (len <= 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        int unusedBits = this.buf[this.pos] & 0xFF;
        int validBits = DerInputBuffer.checkPaddedBits(unusedBits, this.buf, this.pos + 1, this.pos + len, this.allowBER);
        return new BitArray(validBits, this.buf, this.pos + 1);
    }
}

