/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.ec;

import com.ibm.security.ec.ECParameters;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class ECPrivateKeyImpl
extends PrivateKeyInfo
implements ECPrivateKey {
    private static final long serialVersionUID = 88695385615075129L;
    private BigInteger s;
    private ECParameterSpec params;

    public ECPrivateKeyImpl(byte[] encoded) throws InvalidKeyException {
        try {
            this.decode(encoded);
        }
        catch (IOException ex) {
            throw new InvalidKeyException(ex);
        }
    }

    public ECPrivateKeyImpl(BigInteger s, ECParameterSpec params) throws InvalidKeyException {
        this.s = s;
        this.params = params;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(params));
        if (s != null) {
            try {
                DerOutputStream out = new DerOutputStream();
                out.putInteger(1);
                byte[] privBytes = ECParameters.trimZeroes(s.toByteArray());
                out.putOctetString(privBytes);
                DerValue val = new DerValue(48, out.toByteArray());
                this.key = val.toByteArray();
            }
            catch (IOException exc) {
                throw new InvalidKeyException(exc);
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    protected void parseKeyBits() throws IOException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue derValue = in.getDerValue();
            if (derValue.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.getData();
            int version = data.getInteger().intValue();
            if (version != 1) {
                throw new IOException("Version must be 1");
            }
            byte[] privData = data.getOctetString();
            this.s = new BigInteger(1, privData);
            while (data.available() != 0) {
                DerValue value = data.getDerValue();
                if (value.isContextSpecific((byte)0) || value.isContextSpecific((byte)1)) continue;
                throw new IOException("Unexpected value: " + value);
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                throw new IOException("EC domain parameters must be encoded in the algorithm identifier");
            }
            this.params = algParams.getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException e) {
            throw new IOException("Invalid EC private key", e);
        }
        catch (InvalidParameterSpecException e) {
            throw new IOException("Invalid EC private key", e);
        }
    }
}

