/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.security.action.GetPropertyAction;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugOracle {
    private String prefix;
    private static String args = GetPropertyAction.privilegedGetProperty("java.security.debug");
    private static final char[] hexDigits;

    public static void Help() {
        System.err.println();
        System.err.println("all           turn on all debugging");
        System.err.println("access        print all checkPermission results");
        System.err.println("certpath      PKIX CertPathBuilder and");
        System.err.println("              CertPathValidator debugging");
        System.err.println("combiner      SubjectDomainCombiner debugging");
        System.err.println("gssloginconfig");
        System.err.println("              GSS LoginConfigImpl debugging");
        System.err.println("configfile    JAAS ConfigFile loading");
        System.err.println("configparser  JAAS ConfigFile parsing");
        System.err.println("jar           jar verification");
        System.err.println("logincontext  login context results");
        System.err.println("jca           JCA engine class debugging");
        System.err.println("keystore      KeyStore debugging");
        System.err.println("policy        loading and granting");
        System.err.println("provider      security provider debugging");
        System.err.println("pkcs11        PKCS11 session manager debugging");
        System.err.println("pkcs11keystore");
        System.err.println("              PKCS11 KeyStore debugging");
        System.err.println("pkcs12        PKCS12 KeyStore debugging");
        System.err.println("sunpkcs11     SunPKCS11 provider debugging");
        System.err.println("scl           permissions SecureClassLoader assigns");
        System.err.println("securerandom  SecureRandom");
        System.err.println("ts            timestamping");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack         include stack trace");
        System.err.println("domain        dump all domains in context");
        System.err.println("failure       before throwing exception, dump stack");
        System.err.println("              and domain that didn't have permission");
        System.err.println();
        System.err.println("The following can be used with stack and domain:");
        System.err.println();
        System.err.println("permission=<classname>");
        System.err.println("              only dump output if specified permission");
        System.err.println("              is being checked");
        System.err.println("codebase=<URL>");
        System.err.println("              only dump output if specified codebase");
        System.err.println("              is being checked");
        System.err.println();
        System.err.println("The following can be used with provider:");
        System.err.println();
        System.err.println("engine=<engines>");
        System.err.println("              only dump output for the specified list");
        System.err.println("              of JCA engines. Supported values:");
        System.err.println("              Cipher, KeyAgreement, KeyGenerator,");
        System.err.println("              KeyPairGenerator, KeyStore, Mac,");
        System.err.println("              MessageDigest, SecureRandom, Signature.");
        System.err.println();
        System.err.println("The following can be used with certpath:");
        System.err.println();
        System.err.println("ocsp          dump the OCSP protocol exchanges");
        System.err.println("verbose       verbose debugging");
        System.err.println();
        System.err.println("Note: Separate multiple options with a comma");
        System.exit(0);
    }

    public static DebugOracle getInstance(String option) {
        return DebugOracle.getInstance(option, option);
    }

    public static DebugOracle getInstance(String option, String prefix) {
        if (DebugOracle.isOn(option)) {
            DebugOracle d = new DebugOracle();
            d.prefix = prefix;
            return d;
        }
        return null;
    }

    public static boolean isOn(String option) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(option) != -1;
    }

    public static boolean isVerbose() {
        return DebugOracle.isOn("verbose");
    }

    public void println(String message) {
        System.err.println(this.prefix + ": " + message);
    }

    public void println(Object obj, String message) {
        System.err.println(this.prefix + " [" + obj.getClass().getSimpleName() + "@" + System.identityHashCode(obj) + "]: " + message);
    }

    public void println() {
        System.err.println(this.prefix + ":");
    }

    public static void println(String prefix, String message) {
        System.err.println(prefix + ": " + message);
    }

    public PrintStream getPrintStream() {
        return System.err;
    }

    public static String toHexString(BigInteger b) {
        String hexValue = b.toString(16);
        StringBuilder sb = new StringBuilder(hexValue.length() * 2);
        if (hexValue.startsWith("-")) {
            sb.append("   -");
            hexValue = hexValue.substring(1);
        } else {
            sb.append("    ");
        }
        if (hexValue.length() % 2 != 0) {
            hexValue = "0" + hexValue;
        }
        int i = 0;
        while (i < hexValue.length()) {
            sb.append(hexValue.substring(i, i + 2));
            if ((i += 2) == hexValue.length()) continue;
            if (i % 64 == 0) {
                sb.append("\n    ");
                continue;
            }
            if (i % 8 != 0) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String marshal(String args) {
        if (args != null) {
            String matched;
            StringBuilder target = new StringBuilder();
            StringBuffer source = new StringBuffer(args);
            String keyReg = "[Pp][Ee][Rr][Mm][Ii][Ss][Ss][Ii][Oo][Nn]=";
            String keyStr = "permission=";
            String reg = keyReg + "[a-zA-Z_$][a-zA-Z0-9_$]*([.][a-zA-Z_$][a-zA-Z0-9_$]*)*";
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(source);
            StringBuffer left = new StringBuffer();
            while (matcher.find()) {
                matched = matcher.group();
                target.append(matched.replaceFirst(keyReg, keyStr));
                target.append("  ");
                matcher.appendReplacement(left, "");
            }
            matcher.appendTail(left);
            source = left;
            keyReg = "[Cc][Oo][Dd][Ee][Bb][Aa][Ss][Ee]=";
            keyStr = "codebase=";
            reg = keyReg + "[^, ;]*";
            pattern = Pattern.compile(reg);
            matcher = pattern.matcher(source);
            left = new StringBuffer();
            while (matcher.find()) {
                matched = matcher.group();
                target.append(matched.replaceFirst(keyReg, keyStr));
                target.append("  ");
                matcher.appendReplacement(left, "");
            }
            matcher.appendTail(left);
            source = left;
            target.append(source.toString().toLowerCase(Locale.ENGLISH));
            return target.toString();
        }
        return null;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int k = b[i] & 0xFF;
            if (i != 0) {
                sb.append(':');
            }
            sb.append(hexDigits[k >>> 4]);
            sb.append(hexDigits[k & 0xF]);
        }
        return sb.toString();
    }

    static {
        String args2 = GetPropertyAction.privilegedGetProperty("java.security.auth.debug");
        if (args == null) {
            args = args2;
        } else if (args2 != null) {
            args = args + "," + args2;
        }
        if (args != null && (args = DebugOracle.marshal(args)).equals("help")) {
            DebugOracle.Help();
        }
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

