/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Images;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageOps
extends ControlsSurface
implements ChangeListener {
    protected JSlider slider1;
    protected JSlider slider2;
    private static final String[] imgName = new String[]{"bld.jpg", "boat.png"};
    private static final BufferedImage[] img = new BufferedImage[imgName.length];
    private static final String[] opsName = new String[]{"Threshold", "RescaleOp", "Invert", "Yellow Invert", "3x3 Blur", "3x3 Sharpen", "3x3 Edge", "5x5 Edge"};
    private static final BufferedImageOp[] biop = new BufferedImageOp[opsName.length];
    private static int rescaleFactor = 128;
    private static float rescaleOffset = 0.0f;
    private static final int low = 100;
    private static final int high = 200;
    private int opsIndex;
    private int imgIndex;

    public ImageOps() {
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        for (int i = 0; i < imgName.length; ++i) {
            Image image = this.getImage(imgName[i]);
            int n = image.getWidth(this);
            int n2 = image.getHeight(this);
            ImageOps.img[i] = new BufferedImage(n, n2, 1);
            img[i].createGraphics().drawImage(image, 0, 0, null);
        }
        this.slider1 = new JSlider(1, 0, 255, 100);
        this.slider1.setPreferredSize(new Dimension(15, 100));
        this.slider1.addChangeListener(this);
        this.slider2 = new JSlider(1, 0, 255, 200);
        this.slider2.setPreferredSize(new Dimension(15, 100));
        this.slider2.addChangeListener(this);
        this.setControls(new Component[]{new DemoControls(this), this.slider1, this.slider2});
        this.setConstraints(new String[]{"North", "West", "East"});
    }

    public static void thresholdOp(int n, int n2) {
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = i > n2 ? -1 : (i < n ? 0 : (int)i);
        }
        ImageOps.biop[0] = new LookupOp(new ByteLookupTable(0, byArray), null);
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        int n3 = img[this.imgIndex].getWidth(null);
        int n4 = img[this.imgIndex].getHeight(null);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale((double)n / (double)n3, (double)n2 / (double)n4);
        graphics2D.drawImage(img[this.imgIndex], biop[this.opsIndex], 0, 0);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().equals(this.slider1)) {
            if (this.opsIndex == 0) {
                ImageOps.thresholdOp(this.slider1.getValue(), 200);
            } else {
                rescaleFactor = this.slider1.getValue();
                ImageOps.biop[1] = new RescaleOp((float)rescaleFactor / 128.0f, rescaleOffset, null);
            }
        } else if (this.opsIndex == 0) {
            ImageOps.thresholdOp(100, this.slider2.getValue());
        } else {
            rescaleOffset = this.slider2.getValue();
            ImageOps.biop[1] = new RescaleOp((float)rescaleFactor / 128.0f, rescaleOffset, null);
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        ImageOps.createDemoFrame(new ImageOps());
    }

    static {
        ImageOps.thresholdOp(100, 200);
        int n = 1;
        ImageOps.biop[n++] = new RescaleOp(1.0f, 0.0f, null);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)(256 - i);
            byArray2[i] = (byte)i;
        }
        ImageOps.biop[n++] = new LookupOp(new ByteLookupTable(0, byArray), null);
        byte[][] byArrayArray = new byte[][]{byArray, byArray, byArray2};
        ImageOps.biop[n++] = new LookupOp(new ByteLookupTable(0, byArrayArray), null);
        int[][] nArrayArray = new int[][]{{3, 3}, {3, 3}, {3, 3}, {5, 5}};
        float[][] fArrayArray = new float[][]{{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f}, {-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f}, {0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f}, {-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 24.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}};
        int n2 = 0;
        while (n2 < fArrayArray.length) {
            ImageOps.biop[n] = new ConvolveOp(new Kernel(nArrayArray[n2][0], nArrayArray[n2][1], fArrayArray[n2]));
            ++n2;
            ++n;
        }
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        ImageOps demo;
        JComboBox imgCombo;
        JComboBox opsCombo;
        Font font = new Font("serif", 0, 10);

        public DemoControls(ImageOps imageOps) {
            super(imageOps.name);
            this.demo = imageOps;
            this.imgCombo = new JComboBox();
            this.add(this.imgCombo);
            this.imgCombo.setFont(this.font);
            for (String string : imgName) {
                this.imgCombo.addItem(string);
            }
            this.imgCombo.addActionListener(this);
            this.opsCombo = new JComboBox();
            this.add(this.opsCombo);
            this.opsCombo.setFont(this.font);
            for (String string : opsName) {
                this.opsCombo.addItem(string);
            }
            this.opsCombo.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.opsCombo)) {
                this.demo.opsIndex = this.opsCombo.getSelectedIndex();
                if (this.demo.opsIndex == 0) {
                    this.demo.slider1.setValue(100);
                    this.demo.slider2.setValue(200);
                    this.demo.slider1.setEnabled(true);
                    this.demo.slider2.setEnabled(true);
                } else if (this.demo.opsIndex == 1) {
                    this.demo.slider1.setValue(rescaleFactor);
                    this.demo.slider2.setValue((int)rescaleOffset);
                    this.demo.slider1.setEnabled(true);
                    this.demo.slider2.setEnabled(true);
                } else {
                    this.demo.slider1.setEnabled(false);
                    this.demo.slider2.setEnabled(false);
                }
            } else if (actionEvent.getSource().equals(this.imgCombo)) {
                this.demo.imgIndex = this.imgCombo.getSelectedIndex();
            }
            this.demo.repaint(10L);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 39);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1111L);
            }
            catch (Exception exception) {
                return;
            }
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 0; i < imgName.length; ++i) {
                    this.imgCombo.setSelectedIndex(i);
                    for (int j = 0; j < opsName.length; ++j) {
                        this.opsCombo.setSelectedIndex(j);
                        if (j <= 1) {
                            for (int k = 50; k <= 200; k += 10) {
                                this.demo.slider1.setValue(k);
                                try {
                                    Thread.sleep(200L);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                        }
                        try {
                            Thread.sleep(4444L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            }
            this.thread = null;
        }
    }
}

