/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Colors;

import java.awt.Color;
import java.awt.Graphics2D;
import java2d.AnimatingSurface;

public class Rotator3D
extends AnimatingSurface {
    private Objects3D[] objs = new Objects3D[3];
    private static final int[][][] polygons = new int[][][]{new int[][]{{5, 1, 15, 13, 21, 23, 15}, {5, 2, 21, 13, 19, 27, 21}, {5, 3, 23, 15, 17, 25, 23}, {5, 4, 19, 13, 15, 17, 19}, {5, 5, 27, 21, 23, 25, 27}, {5, 6, 27, 19, 17, 25, 27}}, new int[][]{{5, 1, 21, 13, 19, 27, 21}, {5, 5, 23, 15, 17, 25, 23}, {4, 0, 15, 14, 16, 15}, {7, 6, 16, 14, 13, 12, 18, 17, 16}, {4, 0, 12, 19, 18, 12}, {4, 2, 22, 21, 20, 22}, {7, 0, 24, 23, 22, 20, 27, 26, 24}, {4, 2, 24, 26, 25, 24}, {4, 3, 15, 13, 23, 15}, {4, 0, 23, 13, 21, 23}, {5, 0, 27, 26, 18, 19, 27}, {5, 4, 25, 17, 18, 26, 25}}, new int[][]{{4, 3, 18, 21, 16, 18}, {4, 1, 20, 16, 18, 20}, {4, 1, 18, 21, 16, 18}, {4, 3, 20, 17, 19, 20}, {4, 2, 20, 26, 27, 20}, {5, 3, 26, 18, 16, 27, 26}, {5, 0, 17, 24, 25, 19, 17}, {4, 3, 21, 25, 24, 21}, {4, 4, 18, 21, 22, 18}, {4, 2, 22, 21, 17, 22}, {4, 5, 20, 23, 16, 20}, {4, 1, 20, 23, 19, 20}, {4, 6, 21, 23, 16, 21}, {4, 4, 21, 23, 19, 21}, {4, 5, 20, 18, 22, 20}, {4, 6, 20, 22, 17, 20}}};
    private static final double[][][] points = new double[][][]{new double[][]{{1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {1.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {1.0, 1.0, 0.0}, {1.0, 1.0, 1.0}, {0.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, 1.0, 0.0}, {-1.0, 1.0, -1.0}, {0.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, 0.0}, {1.0, -1.0, 1.0}, {0.0, -1.0, 1.0}, {-1.0, -1.0, 1.0}, {-1.0, -1.0, 0.0}, {-1.0, -1.0, -1.0}, {0.0, -1.0, -1.0}, {1.0, -1.0, -1.0}}, new double[][]{{0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {-0.8165, 0.4714, 0.33333}, {0.8165, -0.4714, -0.33333}, {0.8165, 0.4714, 0.33333}, {-0.8165, -0.4714, -0.33333}, {0.0, -0.9428, 0.3333}, {0.0, 0.9428, -0.33333}, {0.0, 0.0, 1.0}, {0.0, 0.0, -1.0}, {-0.8165, 0.4714, 0.33333}, {0.8165, -0.4714, -0.33333}, {0.8165, 0.4714, 0.33333}, {-0.8165, -0.4714, -0.33333}, {0.0, -0.9428, 0.33333}, {0.0, 0.9428, -0.33333}, {-1.2247, -0.7071, 1.0}, {1.2247, 0.7071, -1.0}, {0.0, 1.4142, 1.0}, {0.0, -1.4142, -1.0}, {-1.2247, 0.7071, -1.0}, {1.2247, -0.7071, 1.0}, {0.61237, 1.06066, 0.0}, {-0.61237, -1.06066, 0.0}, {1.2247, 0.0, 0.0}, {0.61237, -1.06066, 0.0}, {-0.61237, 1.06066, 0.0}, {-1.2247, 0.0, 0.0}}};
    private static final int[][][] faces = new int[][][]{new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 0}, {1, 5}}, new int[][]{{1, 0}, {1, 1}, {3, 2, 3, 4}, {3, 5, 6, 7}, {2, 8, 9}, {2, 10, 11}}, new int[][]{{1, 2}, {1, 3}, {2, 4, 5}, {2, 6, 7}, {2, 8, 9}, {2, 10, 11}, {2, 12, 13}, {2, 14, 15}}};

    public Rotator3D() {
        this.setBackground(Color.white);
    }

    @Override
    public void reset(int n, int n2) {
        this.objs[0] = new Objects3D(polygons[0], points[0], faces[0], n, n2);
        this.objs[1] = new Objects3D(polygons[1], points[0], faces[1], n, n2);
        this.objs[2] = new Objects3D(polygons[2], points[1], faces[2], n, n2);
    }

    @Override
    public void step(int n, int n2) {
        for (Objects3D objects3D : this.objs) {
            if (objects3D == null) continue;
            objects3D.step(n, n2);
        }
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        for (Objects3D objects3D : this.objs) {
            if (objects3D == null) continue;
            objects3D.render(graphics2D);
        }
    }

    public static void main(String[] stringArray) {
        Rotator3D.createDemoFrame(new Rotator3D());
    }

    public class Objects3D {
        private final int UP = 0;
        private final int DOWN = 1;
        private int[][] polygons;
        private double[][] points;
        private int npoint;
        private int[][] faces;
        private int nface;
        private int ncolour = 10;
        private Color[][] colours = new Color[this.ncolour][7];
        private double[] lightvec = new double[]{0.0, 1.0, 1.0};
        private double Zeye = 10.0;
        private double angle;
        private Matrix3D orient;
        private Matrix3D tmp;
        private Matrix3D tmp2;
        private Matrix3D tmp3;
        private int scaleDirection;
        private double scale;
        private double scaleAmt;
        private double ix = 3.0;
        private double iy = 3.0;
        private double[][] rotPts;
        private int[][] scrPts;
        private int[] xx = new int[20];
        private int[] yy = new int[20];
        private double x;
        private double y;
        private int p;
        private int j;
        private int colour;
        private double bounce;
        private double persp;

        public Objects3D(int[][] nArray, double[][] dArray, int[][] nArray2, int n, int n2) {
            int n3;
            this.polygons = nArray;
            this.points = dArray;
            this.faces = nArray2;
            this.npoint = dArray.length;
            this.nface = nArray2.length;
            this.x = (double)n * Math.random();
            this.y = (double)n2 * Math.random();
            this.ix = Math.random() > 0.5 ? this.ix : -this.ix;
            this.iy = Math.random() > 0.5 ? this.iy : -this.iy;
            this.rotPts = new double[this.npoint][3];
            this.scrPts = new int[this.npoint][2];
            for (int i = 0; i < this.ncolour; ++i) {
                int n4 = 255 - (this.ncolour - i - 1) * 100 / this.ncolour;
                Color[] colorArray = new Color[]{new Color(n4, n4, n4), new Color(n4, 0, 0), new Color(0, n4, 0), new Color(0, 0, n4), new Color(n4, n4, 0), new Color(0, n4, n4), new Color(n4, 0, n4)};
                this.colours[i] = colorArray;
            }
            double d = Math.sqrt(this.lightvec[0] * this.lightvec[0] + this.lightvec[1] * this.lightvec[1] + this.lightvec[2] * this.lightvec[2]);
            this.lightvec[0] = this.lightvec[0] / d;
            this.lightvec[1] = this.lightvec[1] / d;
            this.lightvec[2] = this.lightvec[2] / d;
            double d2 = 0.0;
            for (n3 = 0; n3 < this.npoint; ++n3) {
                d = Math.sqrt(dArray[n3][0] * dArray[n3][0] + dArray[n3][1] * dArray[n3][1] + dArray[n3][2] * dArray[n3][2]);
                if (!(d > d2)) continue;
                d2 = d;
            }
            for (n3 = 0; n3 < this.nface; ++n3) {
                d = Math.sqrt(dArray[n3][0] * dArray[n3][0] + dArray[n3][1] * dArray[n3][1] + dArray[n3][2] * dArray[n3][2]);
                dArray[n3][0] = dArray[n3][0] / d;
                dArray[n3][1] = dArray[n3][1] / d;
                dArray[n3][2] = dArray[n3][2] / d;
            }
            this.orient = new Matrix3D();
            this.tmp = new Matrix3D();
            this.tmp2 = new Matrix3D();
            this.tmp3 = new Matrix3D();
            this.tmp.Rotation(2, 0, 0.06283185307179587);
            this.CalcScrPts((double)n / 3.0, (double)n2 / 3.0, 0.0);
            this.scaleAmt = this.scale = Math.min((double)(n / 3) / d2 / 1.2, (double)(n2 / 3) / d2 / 1.2);
            this.scale *= Math.random() * 1.5;
            this.scaleDirection = this.scaleAmt < this.scale ? 1 : 0;
        }

        private Color getColour(int n, int n2) {
            this.colour = (int)((this.rotPts[n][0] * this.lightvec[0] + this.rotPts[n][1] * this.lightvec[1] + this.rotPts[n][2] * this.lightvec[2]) * (double)this.ncolour);
            if (this.colour < 0) {
                this.colour = 0;
            }
            if (this.colour > this.ncolour - 1) {
                this.colour = this.ncolour - 1;
            }
            return this.colours[this.colour][this.polygons[this.faces[n][n2]][1]];
        }

        private void CalcScrPts(double d, double d2, double d3) {
            this.p = 0;
            while (this.p < this.npoint) {
                this.rotPts[this.p][2] = this.points[this.p][0] * this.orient.M[2][0] + this.points[this.p][1] * this.orient.M[2][1] + this.points[this.p][2] * this.orient.M[2][2];
                this.rotPts[this.p][0] = this.points[this.p][0] * this.orient.M[0][0] + this.points[this.p][1] * this.orient.M[0][1] + this.points[this.p][2] * this.orient.M[0][2];
                this.rotPts[this.p][1] = -this.points[this.p][0] * this.orient.M[1][0] - this.points[this.p][1] * this.orient.M[1][1] - this.points[this.p][2] * this.orient.M[1][2];
                ++this.p;
            }
            this.p = this.nface;
            while (this.p < this.npoint) {
                double[] dArray = this.rotPts[this.p];
                dArray[2] = dArray[2] + d3;
                this.persp = (this.Zeye - this.rotPts[this.p][2]) / (this.scale * this.Zeye);
                this.scrPts[this.p][0] = (int)(this.rotPts[this.p][0] / this.persp + d);
                this.scrPts[this.p][1] = (int)(this.rotPts[this.p][1] / this.persp + d2);
                ++this.p;
            }
        }

        private boolean faceUp(int n) {
            return this.rotPts[n][0] * this.rotPts[this.nface + n][0] + this.rotPts[n][1] * this.rotPts[this.nface + n][1] + this.rotPts[n][2] * (this.rotPts[this.nface + n][2] - this.Zeye) < 0.0;
        }

        public void step(int n, int n2) {
            this.x += this.ix;
            this.y += this.iy;
            if (this.x > (double)n - this.scale) {
                this.x = (double)n - this.scale - 1.0;
                this.ix = -n / 100 - 1;
            }
            if (this.x - this.scale < 0.0) {
                this.x = 2.0 + this.scale;
                this.ix = (double)(n / 100) + Math.random() * 3.0;
            }
            if (this.y > (double)n2 - this.scale) {
                this.y = (double)n2 - this.scale - 2.0;
                this.iy = -n2 / 100 - 1;
            }
            if (this.y - this.scale < 0.0) {
                this.y = 2.0 + this.scale;
                this.iy = (double)(n2 / 100) + Math.random() * 3.0;
            }
            this.angle += Math.random() * 0.15;
            this.tmp3.Rotation(1, 2, this.angle);
            this.tmp2.Rotation(1, 0, this.angle * Math.sqrt(2.0) / 2.0);
            this.tmp.Rotation(0, 2, this.angle * Math.PI / 4.0);
            this.orient.M = this.tmp3.Times(this.tmp2.Times(this.tmp.M));
            this.bounce = Math.abs(Math.cos(0.5 * this.angle)) * 2.0 - 1.0;
            if (this.scale > this.scaleAmt * 1.4) {
                this.scaleDirection = 1;
            }
            if (this.scale < this.scaleAmt * 0.4) {
                this.scaleDirection = 0;
            }
            if (this.scaleDirection == 0) {
                this.scale += Math.random();
            }
            if (this.scaleDirection == 1) {
                this.scale -= Math.random();
            }
            this.CalcScrPts(this.x, this.y, this.bounce);
        }

        public void render(Graphics2D graphics2D) {
            for (int i = 0; i < this.nface; ++i) {
                if (!this.faceUp(i)) continue;
                this.j = 1;
                while (this.j < this.faces[i][0] + 1) {
                    this.DrawPoly(graphics2D, this.faces[i][this.j], this.getColour(i, this.j));
                    ++this.j;
                }
            }
        }

        private void DrawPoly(Graphics2D graphics2D, int n, Color color) {
            for (int i = 2; i < this.polygons[n][0] + 2; ++i) {
                this.xx[i - 2] = this.scrPts[this.polygons[n][i]][0];
                this.yy[i - 2] = this.scrPts[this.polygons[n][i]][1];
            }
            graphics2D.setColor(color);
            graphics2D.fillPolygon(this.xx, this.yy, this.polygons[n][0]);
            graphics2D.setColor(Color.black);
            graphics2D.drawPolygon(this.xx, this.yy, this.polygons[n][0]);
        }

        public class Matrix3D {
            public double[][] M = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
            private double[][] tmp = new double[3][3];
            private int row;
            private int col;
            private int k;

            public void Rotation(int n, int n2, double d) {
                this.row = 0;
                while (this.row < 3) {
                    this.col = 0;
                    while (this.col < 3) {
                        this.M[this.row][this.col] = this.row != this.col ? 0.0 : 1.0;
                        ++this.col;
                    }
                    ++this.row;
                }
                this.M[n][n] = Math.cos(d);
                this.M[n2][n2] = Math.cos(d);
                this.M[n][n2] = Math.sin(d);
                this.M[n2][n] = -Math.sin(d);
            }

            public double[][] Times(double[][] dArray) {
                this.row = 0;
                while (this.row < 3) {
                    this.col = 0;
                    while (this.col < 3) {
                        this.tmp[this.row][this.col] = 0.0;
                        this.k = 0;
                        while (this.k < 3) {
                            double[] dArray2 = this.tmp[this.row];
                            int n = this.col;
                            dArray2[n] = dArray2[n] + this.M[this.row][this.k] * dArray[this.k][this.col];
                            ++this.k;
                        }
                        ++this.col;
                    }
                    ++this.row;
                }
                return this.tmp;
            }
        }
    }
}

