/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class RSAPublicKey
extends X509Key
implements PKCS11RSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    private SessionManager sessionManager = null;
    private Config config = null;
    private Session session = null;
    private Object sessionID;
    static final long serialVersionUID = 8371797842697540042L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private BigInteger modulus = null;
    private Integer modulusBits = null;
    private BigInteger publicExponent = null;
    protected static int totalOpenHardwareSessions5 = 0;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSessionObjectCount = Debug.getInstance((String)"objectcount");
    private static Debug debugKeyCleanup = Debug.getInstance((String)"keycleanup");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPublicKey";

    RSAPublicKey(Session session, PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken, Boolean isVerify, Boolean isEncrypt, Boolean isWrap) throws InvalidKeyException {
        if (debugKeyCleanup != null) {
            System.out.println("RSAPublicKey.java:  CONSTRUCTOR()#1:  Creating a new RSAPublicKey with session ID = " + session.getID());
        }
        this.sessionManager = session.getSessionManager();
        this.object = object;
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getValue(session, this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getValue(session, this.object, 257);
        }
        this.label = label != null ? new String(label) : (String)this.getValue(session, this.object, 3);
        this.isToken = (Boolean)this.getValue(session, this.object, 1);
        this.isVerify = (Boolean)this.getValue(session, this.object, 266);
        this.isEncrypt = (Boolean)this.getValue(session, this.object, 260);
        this.isWrap = (Boolean)this.getValue(session, this.object, 262);
        this.isPrivate = (Boolean)this.getValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getValue(session, this.object, 368);
        this.startDate = (Date)this.getValue(session, this.object, 272);
        this.endDate = (Date)this.getValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getValue(session, this.object, 355);
        this.isVerifyRecover = (Boolean)this.getValue(session, this.object, 267);
    }

    RSAPublicKey(Session session, PKCS11Object object, byte[] ID, byte[] subject, String label, Boolean isToken, Boolean isVerify, Boolean isEncrypt, Boolean isWrap, BigInteger modulus, Integer modulusBits, BigInteger publicExponent) throws InvalidKeyException {
        this(session, object, ID, subject, label, isToken, isVerify, isEncrypt, isWrap);
        if (modulus != null) {
            this.modulus = new BigInteger(modulus.toByteArray());
        }
        if (modulusBits != null) {
            this.modulusBits = new Integer(modulusBits);
        }
        if (publicExponent != null) {
            this.publicExponent = new BigInteger(publicExponent.toByteArray());
        }
        RSAKeyFactory.checkKeyLengths((int)modulus.bitLength(), (BigInteger)publicExponent, (int)512, (int)Integer.MAX_VALUE);
        this.algid = new AlgIdRSA();
        try {
            DerValue[] value = new DerValue[]{new DerValue(2, this.modulus.toByteArray()), new DerValue(2, this.publicExponent.toByteArray())};
            DerOutputStream out = new DerOutputStream();
            out.putSequence(value);
            this.key = out.toByteArray();
            this.encode();
        }
        catch (IOException e) {
            throw new InvalidKeyException("could not DER encode: " + e.getMessage());
        }
    }

    RSAPublicKey(byte[] encoded, Session session, Config conf) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPublicKey", (Object)encoded);
        }
        if (debugKeyCleanup != null) {
            System.out.println("RSAPublicKey.java:  CONSTRUCTOR()#3:  Creating a new RSAPublicKey with session ID = " + session.getID());
        }
        this.decode(encoded);
        RSAKeyFactory.checkKeyLengths((int)this.modulus.bitLength(), (BigInteger)this.publicExponent, (int)512, (int)Integer.MAX_VALUE);
        this.label = conf != null ? this.genLabel(conf.getProviderNameSuffix()) : this.genLabel(null);
        int[] attrTypes = null;
        Object[] attrValues = null;
        HashMap<Integer, Object> hattrs = null;
        Set<Integer> keys = null;
        int numEles = 0;
        if (conf != null) {
            hattrs = conf.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA);
            keys = hattrs.keySet();
            numEles = keys.size();
            attrTypes = new int[5 + numEles];
            attrValues = new Object[5 + numEles];
            attrTypes[0] = 0;
            attrTypes[1] = 256;
            attrTypes[2] = 3;
            attrTypes[3] = 288;
            attrTypes[4] = 290;
            attrValues[0] = PKCS11Object.PUBLIC_KEY;
            attrValues[1] = PKCS11Object.RSA;
            attrValues[2] = this.label;
            attrValues[3] = this.modulus;
            attrValues[4] = this.publicExponent;
            Iterator<Integer> it = keys.iterator();
            int i = 1;
            while (it.hasNext()) {
                Integer key = it.next();
                attrTypes[4 + i] = key;
                attrValues[4 + i] = hattrs.get(key);
                ++i;
            }
        } else {
            attrTypes = new int[]{0, 256, 3, 1, 266, 260, 262, 288, 290};
            attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, this.label, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, this.modulus, this.publicExponent};
        }
        this.sessionManager = session.getSessionManager();
        this.object = session.createObject(attrTypes, attrValues);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPublicKey");
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue[] value = in.getSequence(2);
            this.modulus = value[0].getInteger();
            this.publicExponent = value[1].getInteger();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "parseKeyBits", "Invalid key value");
            }
            throw new InvalidKeyException("Invalid key value \n" + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
    }

    void setSession(Session sess) {
        this.session = sess;
        this.sessionID = sess.getID();
        sess.isThisSessionAssociatedWithAKey = true;
        if (debugKeyCleanup != null) {
            System.out.println("RSAPublicKey.java:  setSession():  Setting session ID = " + this.sessionID + " within this RSAPublicKey");
        }
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            ++totalOpenHardwareSessions5;
        }
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public Boolean getToken() {
        if (this.isToken == null) {
            this.isToken = (Boolean)this.getValue(this.object, 1);
        }
        return this.isToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rm() {
        Object object = SessionManager.synchObj;
        synchronized (object) {
            block18: {
                int sessionObjectCount;
                if (!(debugKeyCleanup == null && debugSessionObjectCount == null || (sessionObjectCount = this.session.getObjectCount()) >= 0 && sessionObjectCount <= 2)) {
                    System.out.println("RSAPublicKey.java:  rm():  Error:  The session object count for session ID = " + this.sessionID + " is:  " + sessionObjectCount);
                }
                if (this.object != null) {
                    try {
                        Session sess = this.sessionManager.getOpSession();
                        sess.destroyObject(this.getObject());
                        this.object = null;
                        this.sessionManager.releaseSession(sess);
                    }
                    catch (Exception ex) {
                        if (debugKeyCleanup == null && debugSessionObjectCount == null) break block18;
                        System.out.println("RSAPublicKey.java:  rm():  The following exception was thrown trying to destroy the hardware key object.");
                        ex.printStackTrace(System.out);
                    }
                }
            }
            if ((debugKeyCleanup != null || debugSessionObjectCount != null) && this.session == null) {
                System.out.println("RSAPublicKey.java:  rm():  Error:  The Java Session within this key is unexpectedly NULL.  EXITING.");
            }
            if (this.session != null) {
                try {
                    int objectCountBefore = 0;
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("===================================================================================================");
                        System.out.println("RSAPublicKey.java:  rm():  The object count in session ID = " + this.sessionID + " before decrementing it is:  " + this.session.getObjectCount());
                        objectCountBefore = this.session.getObjectCount();
                    }
                    this.session.removeObject();
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("RSAPublicKey.java:  rm():  The object count in session ID = " + this.sessionID + " after  decrementing it is:  " + this.session.getObjectCount());
                        int objectCountAfter = this.session.getObjectCount();
                        if (objectCountBefore - objectCountAfter != 1) {
                            System.out.println("RSAPublicKey.java:  rm():  Error:  The object count in session ID = " + this.sessionID + " did not decrement correctly.  EXITING.");
                        }
                        System.out.println("===================================================================================================");
                    }
                    if (this.session.getObjectCount() <= 0 && this.session.session != null) {
                        if (debugKeyCleanup != null || debug != null || debugSessionObjectCount != null) {
                            System.out.println("RSAPublicKey.java:  rm( ):  CLOSING the hardware session for session ID = " + this.sessionID);
                        }
                        this.sessionManager.closeSession(this.session);
                        if ((debugKeyCleanup != null || debugSessionObjectCount != null) && this.session.session != null) {
                            System.out.println("RSAPublicKey.java:  rm():  Error:  After sessionManager.closeSession(), the reference to the hardware session within the Java Session object is not null.  EXITING.");
                        }
                        this.session = null;
                    }
                }
                catch (Exception ex) {
                    if (debugKeyCleanup != null || debugSessionObjectCount != null) {
                        System.out.println("RSAPublicKey.java:  rm():  The following exception was thrown while trying to close the hardware session.");
                        ex.printStackTrace(System.out);
                    }
                    throw ex;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (debug != null || debugSessionObjectCount != null) {
            System.out.println("RSAPublicKey.java:   finalize( ):  METHOD ENTRY");
        }
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            System.out.println("RSAPublicKey.java:  finalize():  METHOD ENTRY for the RSAPublicKey with session ID = " + this.sessionID);
        }
        if (debugKeyCleanup != null || debugSessionObjectCount != null) {
            --totalOpenHardwareSessions5;
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.getToken().booleanValue()) {
                if (debug != null) {
                    System.out.println("RSAPublicKey.java:   finalize( ):   This RSAPublicKey is NOT A TOKEN OBJECT.   CALLING rm( ) ");
                    if (this.label != null) {
                        System.out.println("                                 RSAPublicKey label = " + this.getLabel());
                    } else {
                        System.out.println("                                 RSAPublicKey label = NULL");
                    }
                }
                if (debugKeyCleanup != null) {
                    System.out.println("RSAPublicKey.java:  finalize():  Calling the rm() method for RSAPublicKey with session ID = " + this.sessionID);
                }
                this.rm();
                super.finalize();
            } else if (debug != null) {
                System.out.println("RSAPublicKey.java:   finalize( ):  This RSAPublicKey IS A TOKEN OBJECT.   NOT CALLING rm( )");
                if (this.label != null) {
                    System.out.println("                                RSAPublicKey label = " + this.getLabel());
                } else {
                    System.out.println("                                RSAPublicKey label = NULL");
                }
            }
        }
        if (debug != null) {
            System.out.println("RSAPublicKey.java:   finalize( ):  METHOD EXIT");
            System.out.println("===============================================\n\n");
        }
    }

    @Override
    public Boolean getPrivate() {
        if (this.isPrivate == null) {
            this.isPrivate = (Boolean)this.getValue(this.object, 2);
        }
        return this.isPrivate;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Boolean getModifiable() {
        if (this.isModifiable == null) {
            this.isModifiable = (Boolean)this.getValue(this.object, 368);
        }
        return this.isModifiable;
    }

    @Override
    public Integer getKeyType() {
        return this.keyType;
    }

    @Override
    public byte[] getID() {
        if (this.ID == null) {
            this.ID = (byte[])this.getValue(this.object, 258);
        }
        if (this.ID != null) {
            return (byte[])this.ID.clone();
        }
        return null;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate == null) {
            this.startDate = (Date)this.getValue(this.object, 272);
        }
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null) {
            this.endDate = (Date)this.getValue(this.object, 273);
        }
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    @Override
    public Boolean getDerive() {
        if (this.isDerive == null) {
            this.isDerive = (Boolean)this.getValue(this.object, 268);
        }
        return this.isDerive;
    }

    @Override
    public Boolean getLocal() {
        if (this.isLocal == null) {
            this.isLocal = (Boolean)this.getValue(this.object, 355);
        }
        return this.isLocal;
    }

    @Override
    public byte[] getSubject() {
        if (this.subject == null) {
            this.subject = (byte[])this.getValue(this.object, 257);
        }
        if (this.subject != null) {
            return (byte[])this.subject.clone();
        }
        return null;
    }

    @Override
    public Boolean getEncrypt() {
        if (this.isEncrypt == null) {
            this.isEncrypt = (Boolean)this.getValue(this.object, 260);
        }
        return this.isEncrypt;
    }

    @Override
    public Boolean getVerify() {
        if (this.isVerify == null) {
            this.isVerify = (Boolean)this.getValue(this.object, 266);
        }
        return this.isVerify;
    }

    @Override
    public Boolean getVerifyRecover() {
        if (this.isVerifyRecover == null) {
            this.isVerifyRecover = (Boolean)this.getValue(this.object, 267);
        }
        return this.isVerifyRecover;
    }

    @Override
    public Boolean getWrap() {
        if (this.isWrap == null) {
            this.isWrap = (Boolean)this.getValue(this.object, 262);
        }
        return this.isWrap;
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public Integer getModulusBits() {
        if (this.modulusBits == null) {
            this.modulusBits = (Integer)this.getValue(this.object, 289);
        }
        return this.modulusBits;
    }

    @Override
    public BigInteger getPublicExponent() {
        if (this.publicExponent == null) {
            this.publicExponent = (BigInteger)this.getValue(this.object, 290);
        }
        return this.publicExponent;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " RSA Public Key: ";
        output = output + "\n Token: ";
        if (this.getToken() != null) {
            output = output + this.isToken;
        }
        output = output + "\n Private: ";
        if (this.getPrivate() != null) {
            output = output + this.isPrivate;
        }
        output = output + "\n Label: ";
        if (this.getLabel() != null) {
            output = output + this.label;
        }
        output = output + "\n Modifiable: ";
        if (this.getModifiable() != null) {
            output = output + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        output = output + "\n ID: ";
        if (this.getID() != null) {
            try {
                output = output + new String(this.ID, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                output = output + new String(this.ID);
            }
        }
        output = output + "\n Start Date: ";
        if (this.getStartDate() != null) {
            output = output + this.startDate.toString();
        }
        output = output + "\n End Date: ";
        if (this.getEndDate() != null) {
            output = output + this.endDate.toString();
        }
        output = output + "\n Derive: ";
        if (this.getDerive() != null) {
            output = output + this.isDerive;
        }
        output = output + "\n Local: ";
        if (this.getLocal() != null) {
            output = output + this.isLocal;
        }
        output = output + "\n Subject: ";
        if (this.getSubject() != null) {
            try {
                X500Name x500name = new X500Name(this.subject);
                output = output + x500name.toString();
            }
            catch (IOException ex) {
                try {
                    UnstructuredName uname = new UnstructuredName(this.subject);
                    output = output + uname.toString();
                }
                catch (IOException ex2) {
                    try {
                        output = output + new String(this.subject, "8859_1");
                    }
                    catch (UnsupportedEncodingException e) {
                        output = output + new String(this.subject);
                    }
                }
            }
        }
        output = output + "\n Encrypt: ";
        if (this.getEncrypt() != null) {
            output = output + this.isEncrypt;
        }
        output = output + "\n Verify: ";
        if (this.getVerify() != null) {
            output = output + this.isVerify;
        }
        output = output + "\n VerifyRecover: ";
        if (this.getVerifyRecover() != null) {
            output = output + this.isVerifyRecover;
        }
        output = output + "\n Wrap: ";
        if (this.getWrap() != null) {
            output = output + this.isWrap;
        }
        output = output + "\n modulus: ";
        if (this.getModulus() != null) {
            output = output + this.modulus.toString();
        }
        output = output + "\n modulus bits: ";
        if (this.getModulusBits() != null) {
            output = output + this.modulusBits.toString();
        }
        output = output + "\n public exponent: ";
        if (this.getPublicExponent() != null) {
            output = output + this.publicExponent.toString();
        }
        return output;
    }

    @Override
    public String getFormat() {
        return "PKCS#11";
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Session session = this.sessionManager.getOpSession();
        Object result = null;
        result = session.getAttrValue(pkcs11obj, attr);
        this.sessionManager.releaseSession(session);
        return result;
    }

    private String genLabel(String providerSuffix) {
        byte[] labelName = new byte[32];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        String provName = null;
        provName = providerSuffix == null ? "IBMPKCS11Impl" : "IBMPKCS11Impl" + providerSuffix;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", provName);
            random.nextBytes(labelSaltData);
        }
        catch (Exception random) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 23) {
            labelLength = 23;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        String label = null;
        try {
            label = new String(labelName, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            label = new String(labelName);
        }
        return label;
    }
}

