/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.CK_SSL3_KEY_MAT_OUT;
import com.ibm.pkcs11.CK_SSL3_KEY_MAT_PARAMS;
import com.ibm.pkcs11.CK_SSL3_RANDOM_DATA;
import com.ibm.pkcs11.PKCS11Object;
import ibm.security.internal.spec.TlsKeyMaterialParameterSpec;
import ibm.security.internal.spec.TlsKeyMaterialSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class PKCS11TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsKeyMaterialGenerator";
    private SessionManager sessionManager = null;
    private Config config = null;
    private Provider provider;
    private KeyMechanismBuilder mechanismBuilder;
    private TlsKeyMaterialParameterSpec spec;
    private GeneralKey generalKey;
    private int version;
    private int mechanism;
    private static final HashMap<String, Integer> keyTypes = new HashMap();

    private static void addKeyType(String name, Integer id) {
        keyTypes.put(name.toUpperCase(Locale.ENGLISH), id);
    }

    private int getKeyType(String algorithm) {
        Integer l = keyTypes.get(algorithm.toUpperCase(Locale.ENGLISH));
        return l != null ? l : -1;
    }

    public PKCS11TlsKeyMaterialGenerator(Provider provider, String algorithm, int mechanism) {
        IBMPKCS11Impl.verifyJceJar();
        this.provider = provider;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanism = mechanism;
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException("TlsKeyMaterialGenerator must be initialized with TlsKeyMaterialParameterSpec");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException("TlsKeyMaterialGenerator must be initialized with TlsKeyMaterialParameterSpec");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException("TlsKeyMaterialGenerator must be initialized with TlsKeyMaterialParameterSpec");
        }
        this.spec = (TlsKeyMaterialParameterSpec)params;
        SecretKey secretKey = this.spec.getMasterSecret();
        GeneralPKCS11KeyFactory factory = new GeneralPKCS11KeyFactory(this.provider, "TlsMasterSecret");
        SecretKey key = null;
        try {
            key = factory.engineTranslateKey(secretKey);
        }
        catch (InvalidKeyException ex) {
            throw new InvalidAlgorithmParameterException(ex);
        }
        if (!(key instanceof GeneralKey)) {
            throw new InvalidAlgorithmParameterException("cannot covert to appropriate key from AlgorithmParameterSpec");
        }
        this.generalKey = (GeneralKey)key;
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        int major = this.spec.getMajorVersion();
        int minor = this.spec.getMinorVersion();
        if (major != 3) throw new InvalidAlgorithmParameterException("not a supported major version " + major);
        if (minor == 0) {
            if (this.mechanism == 882) return;
            throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
        }
        if (minor != 1) throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
        if (this.mechanism == 886) return;
        throw new InvalidAlgorithmParameterException("not a supported minor version " + minor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        boolean isExportable;
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        int macBits = this.spec.getMacKeyLength() << 3;
        int ivBits = this.spec.getIvLength() << 3;
        int expandedKeyBits = this.spec.getExpandedCipherKeyLength() << 3;
        int keyBits = this.spec.getCipherKeyLength() << 3;
        if (expandedKeyBits != 0) {
            isExportable = true;
        } else {
            isExportable = false;
            expandedKeyBits = keyBits;
        }
        CK_SSL3_RANDOM_DATA random = new CK_SSL3_RANDOM_DATA(this.spec.getClientRandom(), this.spec.getServerRandom());
        CK_SSL3_KEY_MAT_PARAMS params = new CK_SSL3_KEY_MAT_PARAMS(macBits, keyBits, ivBits, isExportable, random);
        String cipherAlgorithm = this.spec.getCipherAlgorithm();
        int keyType = this.getKeyType(cipherAlgorithm);
        if (keyType < 0) {
            if (keyBits != 0) {
                throw new ProviderException("Unknown algorithm: " + this.spec.getCipherAlgorithm());
            }
            keyType = PKCS11Object.GENERIC_SECRET;
        }
        HashMap<Integer, Object> attributes = new HashMap<Integer, Object>();
        if (this.config != null) {
            attributes.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, new Integer(keyType)));
        }
        if (keyBits != 0) {
            attributes.put(0, PKCS11Object.SECRET_KEY);
            attributes.put(256, new Integer(keyType));
            attributes.put(353, expandedKeyBits >> 3);
        }
        int[] secretKeyTypes = new int[attributes.size()];
        Object[] secretKeyValues = new Object[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            secretKeyTypes[i] = (Integer)entry.getKey();
            secretKeyValues[i] = entry.getValue();
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGenerateKey", "attrType=" + secretKeyTypes[i] + ", attrValue=" + secretKeyValues[i]);
            }
            ++i;
        }
        PKCS11Object generatedSecret = null;
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            generatedSecret = session.deriveKey(this.mechanism, params, this.generalKey.getObject(), secretKeyTypes, secretKeyValues);
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey", (Throwable)ex);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(ex.getMessage());
        }
        CK_SSL3_KEY_MAT_OUT out = params.getReturnedKeyMaterial();
        GeneralKey clientMacKey = null;
        GeneralKey serverMacKey = null;
        GeneralKey clientCipherKey = null;
        GeneralKey serverCipherKey = null;
        try {
            clientMacKey = new GeneralKey(session, out.clientMacSecret, "MAC");
            serverMacKey = new GeneralKey(session, out.serverMacSecret, "MAC");
            if (keyBits != 0) {
                clientCipherKey = new GeneralKey(session, out.clientKey, cipherAlgorithm);
                serverCipherKey = new GeneralKey(session, out.serverKey, cipherAlgorithm);
            }
        }
        catch (InvalidKeyException ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey", (Throwable)ex);
                debug.text(16384L, (Object)className, "engineGenerateKey", "clientMacKey, serverMacKey, clientCipherKey, serverCipherKey all set to null");
            }
            clientMacKey = null;
            serverMacKey = null;
            clientCipherKey = null;
            serverCipherKey = null;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        IvParameterSpec clientIv = null;
        IvParameterSpec serverIv = null;
        if (out.ivClient != null) {
            clientIv = new IvParameterSpec(out.ivClient);
        }
        if (out.ivServer != null) {
            serverIv = new IvParameterSpec(out.ivServer);
        }
        TlsKeyMaterialSpec specKey = new TlsKeyMaterialSpec((SecretKey)clientMacKey, (SecretKey)serverMacKey, (SecretKey)clientCipherKey, clientIv, (SecretKey)serverCipherKey, serverIv);
        return specKey;
    }

    static {
        PKCS11TlsKeyMaterialGenerator.addKeyType("RC4", PKCS11Object.RC4);
        PKCS11TlsKeyMaterialGenerator.addKeyType("ARCFOUR", PKCS11Object.RC4);
        PKCS11TlsKeyMaterialGenerator.addKeyType("DES", PKCS11Object.DES);
        PKCS11TlsKeyMaterialGenerator.addKeyType("DESede", PKCS11Object.DES3);
        PKCS11TlsKeyMaterialGenerator.addKeyType("AES", PKCS11Object.AES);
        PKCS11TlsKeyMaterialGenerator.addKeyType("Blowfish", PKCS11Object.BLOWFISH);
        PKCS11TlsKeyMaterialGenerator.addKeyType("RC2", PKCS11Object.RC2);
        PKCS11TlsKeyMaterialGenerator.addKeyType("IDEA", PKCS11Object.IDEA);
        PKCS11TlsKeyMaterialGenerator.addKeyType("Generic", PKCS11Object.GENERIC_SECRET);
    }
}

