/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class GeneralPKCS11Hmac
extends MacSpi
implements Cloneable {
    private SessionManager sessionManager = null;
    private MechanismBuilder mechanismBuilder = null;
    private Key pkcs11Key = null;
    private Provider provider;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static HashMap<String, Integer> MacOutputSizes = new HashMap();
    private boolean initialized;
    private GeneralKey key_to_be_deleted;
    private Session session;

    public GeneralPKCS11Hmac(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.provider = provider;
        this.mechanismBuilder = MechanismBuilderImpl.createMechanismBuilder(algorithm, "Mac");
    }

    @Override
    protected int engineGetMacLength() {
        Integer len = MacOutputSizes.get(this.mechanismBuilder.getAlgorithm());
        return len != null ? len : 0;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec neverUsed) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCs11Hmac", "engineInit-2");
            debug.text(16384L, (Object)"GeneralPKCs11Hmac", "engineInit-2", "init-2 for " + this);
        }
        PKCS11SecretKey pkcs11sk = null;
        GeneralKey new_key_to_be_deleted = null;
        if (key == null) {
            throw new InvalidKeyException("Key can not be null");
        }
        if (!(key instanceof PKCS11SecretKey)) {
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)"GeneralPKCS11Hmac", "engineInit", "translate the key" + key + ", key format=" + key.getFormat() + ", key algo=" + key.getAlgorithm());
                }
                SecretKeyFactory kf = SecretKeyFactory.getInstance(key.getAlgorithm(), this.provider);
                SecretKey sk = kf.translateKey((SecretKey)key);
                new_key_to_be_deleted = (GeneralKey)sk;
                pkcs11sk = new_key_to_be_deleted;
            }
            catch (Exception ex) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"GeneralPKCS11Hmac", "engineInit", (Throwable)ex);
                }
                throw new InvalidKeyException("PKCS11 Secret key expected");
            }
        } else {
            pkcs11sk = (PKCS11SecretKey)key;
        }
        this.pkcs11Key = key;
        if (this.session != null) {
            this.cancelOperation();
        }
        this.key_to_be_deleted = new_key_to_be_deleted;
        this.session = this.sessionManager.getOpSession();
        try {
            this.session.signInit(this.mechanismBuilder.getMechanism(), null, pkcs11sk.getObject());
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw new InvalidKeyException(ex);
        }
        this.initialized = true;
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCs11Hmac", "engineInit-2");
        }
    }

    protected void engineInit(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCs11Hmac", "engineInit-1");
            debug.text(16384L, (Object)"GeneralPKCs11Hmac", "engineInit-1", "init-1 with " + this);
        }
        this.engineInit(key, null);
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCs11Hmac", "engineInit-1");
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCs11Hmac", "engineUpdate-1");
            debug.text(16384L, (Object)"GeneralPKCs11Hmac", "engineUpdate-1", "update-1 for " + this);
        }
        byte[] tempBuffer = new byte[]{input};
        if (!this.initialized) {
            if (this.pkcs11Key == null) {
                throw new RuntimeException("Mac is not initialized");
            }
            try {
                this.engineInit(this.pkcs11Key, null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            this.session.signUpdate(tempBuffer, 0, 1);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCs11Hmac", "engineUpdate-1");
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCs11Hmac", "engineUpdate-2");
            debug.text(16384L, (Object)"GeneralPKCs11Hmac", "engineUpdate-2", "update-2 for " + this);
        }
        if (!this.initialized) {
            if (this.pkcs11Key == null) {
                throw new RuntimeException("Mac is not initialized");
            }
            try {
                this.engineInit(this.pkcs11Key, null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            this.session.signUpdate(input, offset, len);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCs11Hmac", "engineUpdate-2");
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Hmac", "engineDoFinal");
            debug.text(16384L, (Object)"GeneralPKCS11Hmac", "engineDoFinal", "do final for " + this);
        }
        byte[] tempBuffer = new byte[this.engineGetMacLength()];
        if (debug != null) {
            debug.text(16384L, (Object)"GeneralPKCS11Hmac", "engineDoFinal", "buffer size=" + tempBuffer.length + ", algorithm=" + this.mechanismBuilder.getAlgorithm() + ", mechanism=" + this.mechanismBuilder.getMechanism());
        }
        int outputLen = 0;
        if (!this.initialized) {
            if (this.pkcs11Key == null) {
                throw new RuntimeException("Mac is not initialized");
            }
            try {
                this.engineInit(this.pkcs11Key, null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            outputLen = this.session.signFinal(tempBuffer, 0);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
        this.initialized = false;
        if (this.key_to_be_deleted != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"GeneralPKCS11Hmac", "engineInit", "delete generated general key");
            }
            this.key_to_be_deleted.rm();
            this.key_to_be_deleted = null;
        }
        byte[] returnVal = new byte[outputLen];
        System.arraycopy(tempBuffer, 0, returnVal, 0, outputLen);
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Hmac", "engineDoFinal");
        }
        return returnVal;
    }

    @Override
    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Hmac", "engineReset");
        }
        try {
            this.engineInit(this.pkcs11Key, null);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Hmac", "engineReset");
        }
    }

    private void cancelOperation() {
        if (this.key_to_be_deleted != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"GeneralPKCS11Hmac", "engineInit", "delete generated general key");
            }
            this.key_to_be_deleted.rm();
            this.key_to_be_deleted = null;
        }
        if (this.session == null) {
            return;
        }
        if (!this.session.hasObjects()) {
            this.sessionManager.closeSession(this.session);
            this.session = null;
            return;
        }
        try {
            this.engineDoFinal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionManager.releaseSession(this.session);
        this.session = null;
    }

    static {
        MacOutputSizes.put("HmacMD5", new Integer(16));
        MacOutputSizes.put("HmacSHA1", new Integer(20));
        MacOutputSizes.put("HmacSHA224", new Integer(28));
        MacOutputSizes.put("HmacSHA256", new Integer(32));
        MacOutputSizes.put("HmacSHA384", new Integer(48));
        MacOutputSizes.put("HmacSHA512", new Integer(64));
    }
}

