/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.commands.BaseCommand;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.Entry;
import java.net.URL;

public abstract class PluginConfig {
    protected final Entry entry;
    protected Throwable t = null;
    protected boolean cacheOutput = true;

    public PluginConfig(Entry entry) {
        this.entry = entry;
    }

    public String getName() {
        return this.entry.getName();
    }

    public ICommand newInstance(ClassLoader loader) throws CommandException {
        ClassInfo info = (ClassInfo)this.entry.getData();
        try {
            Class<?> clazz = Class.forName(info.getClassname(), true, loader);
            Object instance = clazz.newInstance();
            if (instance instanceof BaseCommand) {
                ((BaseCommand)instance).setConfig(this);
            }
            return (ICommand)instance;
        }
        catch (Throwable e) {
            this.t = e;
            throw new CommandException("Failed to create a new instance of command " + info.getClassname(), e);
        }
    }

    public abstract String toCSV();

    public String getClassName() {
        ClassInfo info = (ClassInfo)this.entry.getData();
        return info.getClassname();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PluginConfig)) {
            return false;
        }
        PluginConfig compareTo = (PluginConfig)o;
        Object o1 = this.entry.getData();
        Object o2 = compareTo.entry.getData();
        return o1.equals(o2);
    }

    public int hashCode() {
        return this.getClassName().hashCode();
    }

    public String getId() {
        return this.getClassName();
    }

    public Throwable getError() {
        return this.t;
    }

    public boolean isEnabled() {
        return this.t == null;
    }

    public URL getURL() {
        return this.entry.toURL();
    }

    public boolean cacheOutput() {
        return this.cacheOutput;
    }
}

