/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class JavaHeapRegion {
    private JavaHeap _parentHeap;
    private JavaRuntime _javaVM;
    private int _objectAlignment;
    private int _minimumObjectSize;
    private Vector _extents = new Vector();
    private long _arrayletLeafSize;
    private HeapSection _section;

    public JavaHeapRegion(JavaRuntime javaVM, String name, ImagePointer id, int objectAlignment, int minimumObjectSize, long arrayletLeafSize, JavaHeap parentHeap, ImagePointer heapSectionBase, long heapSectionSize) {
        this._parentHeap = parentHeap;
        this._javaVM = javaVM;
        this._objectAlignment = objectAlignment;
        this._minimumObjectSize = minimumObjectSize;
        this._arrayletLeafSize = arrayletLeafSize;
        if (null != heapSectionBase) {
            this._section = new HeapSection(heapSectionBase, heapSectionSize);
        }
    }

    public void addExtent(ImagePointer startAddress, int size, int count) {
        this._extents.add(new HeapExtent(startAddress, size, count));
    }

    public Iterator getSections() {
        List<Object> sections = null;
        sections = null != this._section ? Collections.singletonList(this._section) : this._extents;
        return sections.iterator();
    }

    public Iterator getObjects() {
        return new ExtentWalker(this._parentHeap, this, this._javaVM, this._extents.iterator(), this._objectAlignment, this._minimumObjectSize);
    }

    public void addNewHeapRegionExtent(long start, long end, int count) {
        ImagePointer baseAddress = this._javaVM.pointerInAddressSpace(start);
        int size = (int)(end - start);
        this.addExtent(baseAddress, size, count);
    }

    public int getArrayletSpineSize() {
        return this._minimumObjectSize;
    }

    public long getArrayletLeafSize() {
        return this._arrayletLeafSize;
    }

    public com.ibm.dtfj.java.JavaObject getObjectAtAddress(ImagePointer address) throws CorruptDataException, IllegalArgumentException {
        JavaObject object = null;
        if (null != address && 0L != address.getAddress()) {
            com.ibm.dtfj.java.JavaObject specialObject = this._javaVM.getSpecialObject(address);
            if (null != specialObject) {
                return specialObject;
            }
            if ((address.getAddress() & (long)(this._objectAlignment - 1)) != 0L) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject should be " + this._objectAlignment + " aligned. Address = " + address.toString());
            }
            long arrayletIdentificationBitmask = 0L;
            long arrayletIdentificationResult = 0L;
            int arrayletIdentificationWidth = 0;
            int arrayletIdentificationOffset = 0;
            int arrayletSpineSize = 0;
            long arrayletLeafSize = 0L;
            arrayletIdentificationBitmask = this._parentHeap.getArrayletIdentificationBitmask();
            arrayletIdentificationResult = this._parentHeap.getArrayletIdentificationResult();
            arrayletIdentificationWidth = this._parentHeap.getArrayletIdentificationWidth();
            arrayletIdentificationOffset = this._parentHeap.getArrayletIdentificationOffset();
            arrayletSpineSize = this.getArrayletSpineSize();
            arrayletLeafSize = this.getArrayletLeafSize();
            boolean isArraylet = false;
            if (0L != arrayletIdentificationResult) {
                long maskedFlags = 0L;
                if (4 == arrayletIdentificationWidth) {
                    try {
                        maskedFlags = 0xFFFFFFFFL & (long)address.getIntAt(arrayletIdentificationOffset);
                    }
                    catch (MemoryAccessException e) {
                        throw new CorruptDataException(new CorruptData("unable to access object flags", address));
                    }
                } else if (8 == arrayletIdentificationWidth) {
                    try {
                        maskedFlags = address.getLongAt(arrayletIdentificationOffset);
                    }
                    catch (MemoryAccessException e) {
                        throw new CorruptDataException(new CorruptData("unable to access object flags", address));
                    }
                } else {
                    System.err.println("Arraylet identification width is invalid: " + arrayletIdentificationWidth + " (should be 4 or 8)");
                }
                isArraylet = arrayletIdentificationResult == (arrayletIdentificationBitmask & maskedFlags);
            }
            object = new JavaObject(this._javaVM, address, this._parentHeap, arrayletSpineSize, arrayletLeafSize, isArraylet, this._objectAlignment);
        }
        return object;
    }

    class ExtentWalker
    implements Iterator {
        private Iterator _extentIterator;
        private HeapExtent _currentExtent;
        private int _objectsRemainingInExtent;
        private long _nextOffsetInExtent;
        private int _alignment;
        private int _minimumObjectSize;

        public ExtentWalker(JavaHeap heap, JavaHeapRegion region, JavaRuntime vm, Iterator extents, int alignment, int minimumObjectSize) {
            JavaHeapRegion.this._parentHeap = heap;
            JavaHeapRegion.this._javaVM = vm;
            this._extentIterator = extents;
            this._alignment = alignment;
            this._minimumObjectSize = minimumObjectSize;
            this._advanceExtentMarker();
        }

        private void _advanceExtentMarker() {
            if (this._extentIterator.hasNext()) {
                this._currentExtent = (HeapExtent)this._extentIterator.next();
                this._nextOffsetInExtent = 0L;
                this._objectsRemainingInExtent = this._currentExtent.objectsInExtent();
            } else {
                this._currentExtent = null;
            }
        }

        @Override
        public boolean hasNext() {
            boolean moreAvailable = false;
            if (null != this._currentExtent) {
                if (this._objectsRemainingInExtent > 0) {
                    moreAvailable = true;
                } else {
                    this._advanceExtentMarker();
                    moreAvailable = null != this._currentExtent;
                }
            }
            return moreAvailable;
        }

        public Object next() {
            try {
                ImagePointer objectAddress = this._currentExtent.getBaseAddress().add(this._nextOffsetInExtent);
                com.ibm.dtfj.java.JavaObject instance = null;
                try {
                    instance = JavaHeapRegion.this.getObjectAtAddress(objectAddress);
                }
                catch (IllegalArgumentException e) {
                    CorruptData cd = new CorruptData("Invalid alignment for JavaObject : should be " + JavaHeapRegion.this._objectAlignment + " aligned", objectAddress);
                    throw new CorruptDataException(cd);
                }
                int spaceOccupied = (int)this.getSpaceOccupied((JavaObject)instance);
                JavaAbstractClass objectClass = (JavaAbstractClass)instance.getJavaClass();
                try {
                    int flags;
                    int HEADER_HAS_BEEN_MOVED = 65536;
                    if (JavaHeapRegion.this._parentHeap.isSWH()) {
                        HEADER_HAS_BEEN_MOVED = 4;
                    }
                    if (((flags = objectClass.readFlagsFromInstance(instance)) & HEADER_HAS_BEEN_MOVED) == HEADER_HAS_BEEN_MOVED) {
                        spaceOccupied += objectClass.getHashcodeSlotSize();
                    }
                }
                catch (MemoryAccessException e) {
                    throw new CorruptDataException(new CorruptData("Flags in object header unreadable", objectAddress));
                }
                int spaceConsumed = Math.max(spaceOccupied, this._minimumObjectSize);
                int slack = spaceConsumed % this._alignment;
                int filler = 0 == slack ? 0 : this._alignment - slack;
                this._nextOffsetInExtent += (long)(spaceConsumed += filler);
                --this._objectsRemainingInExtent;
                return instance;
            }
            catch (CorruptDataException e) {
                this._advanceExtentMarker();
                return e.getCorruptData();
            }
        }

        private long getSpaceOccupied(JavaObject instance) throws CorruptDataException {
            ImagePointer _basePointer = instance.getID();
            if (instance.isArraylet()) {
                JavaArrayClass arrayForm = (JavaArrayClass)instance.getJavaClass();
                int objectHeaderSize = arrayForm.getFirstElementOffset();
                int bytesPerPointer = JavaHeapRegion.this._javaVM.bytesPerPointer();
                try {
                    int instanceSize = arrayForm.getInstanceSize(instance);
                    long contentDataSize = instanceSize - objectHeaderSize;
                    int fullSizeLeaves = (int)(contentDataSize / JavaHeapRegion.this._arrayletLeafSize);
                    long tailLeafSize = contentDataSize % JavaHeapRegion.this._arrayletLeafSize;
                    int totalLeafCount = 0L == tailLeafSize ? fullSizeLeaves : fullSizeLeaves + 1;
                    String nestedType = arrayForm.getLeafClass().getName();
                    boolean alignmentCandidate = 4 == JavaHeapRegion.this._objectAlignment && ("double".equals(nestedType) || "long".equals(nestedType));
                    long headerAndLeafPointers = -1L;
                    if (totalLeafCount == 0) {
                        if (this._objectsRemainingInExtent > 1) {
                            ImagePointer peek = _basePointer.getPointerAt(objectHeaderSize);
                            ImagePointer possibleArrayletLeafTarget = null;
                            possibleArrayletLeafTarget = bytesPerPointer == 8 || "double".equals(nestedType) || "long".equals(nestedType) ? _basePointer.getPointerAt(objectHeaderSize + 8) : _basePointer.getPointerAt(objectHeaderSize + 4);
                            headerAndLeafPointers = peek.getAddress() == possibleArrayletLeafTarget.getAddress() || peek.getAddress() == 0L ? (long)(objectHeaderSize + bytesPerPointer) : (long)objectHeaderSize;
                        }
                    } else {
                        headerAndLeafPointers = objectHeaderSize + totalLeafCount * bytesPerPointer;
                    }
                    long spineSectionSize = headerAndLeafPointers;
                    long nextExpectedInteriorLeafAddress = _basePointer.getAddress() + headerAndLeafPointers;
                    boolean doesHaveTailPadding = false;
                    if (alignmentCandidate && totalLeafCount > 0) {
                        if (0L == nextExpectedInteriorLeafAddress % 8L) {
                            doesHaveTailPadding = true;
                        } else {
                            spineSectionSize += 4L;
                            if (0L != (nextExpectedInteriorLeafAddress += 4L) % 8L) {
                                throw new CorruptDataException(new CorruptData("Arraylet leaf pointer misaligned for object", _basePointer));
                            }
                        }
                    }
                    for (int i = 0; i < totalLeafCount; ++i) {
                        ImagePointer leafPointer = _basePointer.getPointerAt(objectHeaderSize + i * bytesPerPointer);
                        if (leafPointer.getAddress() != nextExpectedInteriorLeafAddress) continue;
                        long internalLeafSize = JavaHeapRegion.this._arrayletLeafSize;
                        if (fullSizeLeaves == i) {
                            internalLeafSize = tailLeafSize;
                        }
                        spineSectionSize += internalLeafSize;
                        nextExpectedInteriorLeafAddress += internalLeafSize;
                    }
                    if (doesHaveTailPadding) {
                        spineSectionSize += 4L;
                    }
                    return spineSectionSize;
                }
                catch (MemoryAccessException e) {
                    throw new CorruptDataException(new CorruptData("failed to walk arraylet spine", e.getPointer()));
                }
            }
            long size = ((JavaAbstractClass)instance.getJavaClass()).getInstanceSize(instance);
            return size;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeapExtent
    extends HeapSection {
        private int _residentObjectCount;

        public HeapExtent(ImagePointer base, long size, int count) {
            super(base, size);
            this._residentObjectCount = count;
        }

        @Override
        public String getName() {
            return "Heap Extent at " + Long.toHexString(this.getBaseAddress().getAddress()) + " (" + this.getSize() + " bytes long)";
        }

        public int objectsInExtent() {
            return this._residentObjectCount;
        }

        @Override
        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof HeapExtent) {
                HeapExtent local = (HeapExtent)obj;
                isEqual = super.equals(local) && this._residentObjectCount == local._residentObjectCount;
            }
            return isEqual;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this._residentObjectCount;
        }
    }

    class HeapSection
    implements ImageSection {
        private ImagePointer _base;
        private long _size;

        public HeapSection(ImagePointer base, long size) {
            if (null == base) {
                throw new IllegalArgumentException("Heap extents cannot have null base pointers");
            }
            this._base = base;
            this._size = size;
        }

        @Override
        public ImagePointer getBaseAddress() {
            return this._base;
        }

        @Override
        public long getSize() {
            return this._size;
        }

        @Override
        public String getName() {
            return "Heap extent at 0x" + Long.toHexString(this._base.getAddress()) + " (0x" + Long.toHexString(this._size) + " bytes)";
        }

        @Override
        public boolean isExecutable() throws DataUnavailable {
            return this._base.isExecutable();
        }

        @Override
        public boolean isReadOnly() throws DataUnavailable {
            return this._base.isReadOnly();
        }

        @Override
        public boolean isShared() throws DataUnavailable {
            return this._base.isShared();
        }

        @Override
        public Properties getProperties() {
            return this._base.getProperties();
        }

        public boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj instanceof HeapSection) {
                HeapSection local = (HeapSection)obj;
                isEqual = this._base.equals(local._base) && this._size == local._size;
            }
            return isEqual;
        }

        public int hashCode() {
            return (int)((long)this._base.hashCode() ^ this._size);
        }
    }
}

