/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ReleasingImage;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Image
implements ReleasingImage,
ManagedImage {
    private String _osType;
    private String _osSubType;
    private String _cpuType;
    private String _cpuSubType;
    private int _cpuCount;
    private long _bytesMem;
    private long _creationTime;
    private Vector _addressSpaces = new Vector();
    private String _hostname;
    private List _ipAddresses = new Vector();
    private List _closables = new Vector();
    private URI source = null;
    private ManagedImageSource imageSource = null;

    public Image(String osType, String osSubType, String cpuType, String cpuSubType, int cpuCount, long bytesMem, long creationTime) {
        this._osType = osType;
        this._osSubType = osSubType;
        this._cpuType = cpuType;
        this._cpuSubType = cpuSubType;
        this._cpuCount = cpuCount;
        this._bytesMem = bytesMem;
        this._creationTime = creationTime;
    }

    @Override
    public Iterator getAddressSpaces() {
        return this._addressSpaces.iterator();
    }

    @Override
    public String getProcessorType() throws DataUnavailable, CorruptDataException {
        if (null == this._cpuType) {
            throw new DataUnavailable();
        }
        return this._cpuType;
    }

    @Override
    public String getProcessorSubType() throws DataUnavailable, CorruptDataException {
        if (null == this._cpuSubType) {
            throw new DataUnavailable();
        }
        return this._cpuSubType;
    }

    @Override
    public int getProcessorCount() throws DataUnavailable {
        if (0 == this._cpuCount) {
            throw new DataUnavailable("Processor count could not be found");
        }
        return this._cpuCount;
    }

    @Override
    public String getSystemType() throws DataUnavailable, CorruptDataException {
        if (null == this._osType) {
            throw new DataUnavailable();
        }
        return this._osType;
    }

    @Override
    public String getSystemSubType() throws DataUnavailable, CorruptDataException {
        if (null == this._osSubType) {
            throw new DataUnavailable("Operating System did not identify its sub-type");
        }
        return this._osSubType;
    }

    @Override
    public long getInstalledMemory() throws DataUnavailable {
        if (0L == this._bytesMem) {
            throw new DataUnavailable("Installed memory size not found");
        }
        return this._bytesMem;
    }

    @Override
    public long getCreationTime() throws DataUnavailable {
        if (0L == this._creationTime) {
            throw new DataUnavailable("Creation time not specified in platform core file");
        }
        return this._creationTime;
    }

    public void addAddressSpace(ImageAddressSpace addressSpace) {
        this._addressSpaces.add(addressSpace);
    }

    @Override
    public String getHostName() throws DataUnavailable {
        if (null != this._hostname) {
            return this._hostname;
        }
        throw new DataUnavailable();
    }

    @Override
    public Iterator getIPAddresses() throws DataUnavailable {
        if (this._ipAddresses.size() > 0) {
            return this._ipAddresses.iterator();
        }
        throw new DataUnavailable();
    }

    public void setHostName(String hostname) {
        if (null == this._hostname) {
            if (hostname.length() <= 0) {
                throw new UnsupportedOperationException("hostname cannot be an empty string");
            }
        } else {
            throw new UnsupportedOperationException("hostname cannot be set more than once");
        }
        this._hostname = hostname;
    }

    public void addIPAddress(Object newAddress) {
        this._ipAddresses.add(newAddress);
    }

    @Override
    public void addReleasable(ResourceReleaser o) {
        this._closables.add(o);
    }

    @Override
    public void close() {
        for (Object o : this._closables) {
            if (!(o instanceof ResourceReleaser)) continue;
            try {
                ((ResourceReleaser)o).releaseResources();
            }
            catch (IOException e) {
                Logger.getLogger("com.ibm.dtfj.log").log(Level.INFO, e.getMessage());
            }
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
            if (this.imageSource.getMetadata() != null && this.imageSource.getMetadata().getExtractedTo() != null) {
                this.imageSource.getMetadata().getExtractedTo().delete();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    public void SetSource(URI source) {
        this.source = source;
    }

    @Override
    public URI getSource() {
        try {
            if (this.source == null) {
                return new URI("jx:" + this._hostname + ":" + this._creationTime);
            }
            return this.source;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(ManagedImageSource source) {
        this.imageSource = source;
    }

    @Override
    public long getCreationTimeNanos() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable();
    }
}

