/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.dumpreader;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.SearchListener;
import com.ibm.dtfj.corereaders.zos.util.CharConversion;
import com.ibm.dtfj.corereaders.zos.util.Clib;
import com.ibm.dtfj.corereaders.zos.util.CompressedRecordArray;
import com.ibm.dtfj.corereaders.zos.util.ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class Dump
extends ImageInputStreamImpl {
    private String filename;
    private long fp;
    private boolean isMvsDataset;
    private ImageInputStream raf;
    private AddressSpace[] spaces;
    private String title;
    private String productName;
    private String productVersion;
    private String productRelease;
    private String productModification;
    private Date creationDate;
    AddressSpace rootSpace;
    private CompressedRecordArray fposArray;
    private int[] fpos = new int[8];
    static final int HEADERSIZE = 64;
    static final int DATABLOCKSIZE = 4096;
    static final int BLOCKSIZE = 4160;
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static Logger log = Logger.getLogger(Dump.class.getName());

    public static boolean isValid(String filename) {
        try {
            new Dump(filename, null, false, null, true);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public Dump(String filename) throws FileNotFoundException {
        this(filename, null, true, null, false);
    }

    public Dump(String filename, ImageInputStream stream, boolean createCacheFile) throws FileNotFoundException {
        this(filename, null, true, stream, createCacheFile);
    }

    public Dump(String filename, SearchListener[] listeners) throws FileNotFoundException {
        this(filename, listeners, true, null, true);
    }

    private Dump(String filename, SearchListener[] listeners, boolean buildAddressSpaces, ImageInputStream instream, boolean createCacheFile) throws FileNotFoundException {
        log.fine("opening dump " + filename + " stream " + instream);
        this.filename = filename;
        if (listeners != null) {
            throw new Error("tbc");
        }
        try {
            this.raf = instream != null ? instream : new FileImageInputStream(new RandomAccessFile(filename, "r"));
            if (buildAddressSpaces) {
                this.buildAddressSpaces(createCacheFile);
                log.fine("finished building address spaces");
            }
            return;
        }
        catch (Exception e) {
            if (!System.getProperty("os.arch").equals("390")) {
                FileNotFoundException e2 = new FileNotFoundException("Could not find: " + filename + " stream " + instream);
                e2.initCause(e);
                throw e2;
            }
            this.openMvsDataset();
            if (buildAddressSpaces) {
                this.buildAddressSpaces(createCacheFile);
                log.fine("finished building address spaces");
            }
            return;
        }
    }

    private void openMvsDataset() throws FileNotFoundException {
        try {
            log.fine("trying to open dump as an MVS dataset");
            String version = System.getProperty("java.version");
            InputStream is = this.getClass().getResourceAsStream("libzebedee" + version.charAt(2) + ".so");
            BufferedInputStream bis = new BufferedInputStream(is);
            File tmp = File.createTempFile("lib", ".so");
            Process proc = Runtime.getRuntime().exec("chmod +x " + tmp.getPath());
            proc.waitFor();
            int exitcode = proc.exitValue();
            FileOutputStream fos = new FileOutputStream(tmp);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            byte[] b = new byte[10000];
            int n = 0;
            while ((n = bis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            bos.close();
            tmp.deleteOnExit();
            System.load(tmp.getPath());
            log.fine("lib loaded ok");
            this.fp = Clib.fopen("//'" + this.filename + "'", "rb");
            if (this.fp == 0L) {
                throw new FileNotFoundException("Could not find either " + this.filename + " or //" + this.filename);
            }
            this.isMvsDataset = true;
            log.fine("MVS dataset opened ok");
        }
        catch (Exception e) {
            throw new FileNotFoundException("Could not find: " + this.filename);
        }
    }

    private void buildAddressSpaces(boolean createCacheFile) {
        try {
            try {
                if (this.filename == null) {
                    throw new FileNotFoundException("No filename supplied so no cache available");
                }
                File fn = new File(this.filename + ".zcache");
                this.readCacheFile(fn);
            }
            catch (Exception e) {
                log.log(Level.FINE, "cache read failed: ", e);
                log.fine("no cache file, scanning file");
                byte[] blockHeader = null;
                this.fposArray = new CompressedRecordArray(5, this.fpos.length);
                ObjectMap asidMap = new ObjectMap();
                long offset = 0L;
                while (true) {
                    int rc;
                    if (this.isMvsDataset) {
                        if (offset > 0L) {
                            rc = Clib.fseek(this.fp, 4096L, 1);
                            assert (rc == 0) : rc;
                        }
                    } else {
                        this.raf.seek(offset);
                    }
                    if (offset == 0L) {
                        blockHeader = new byte[512];
                    } else if (offset == 4160L) {
                        blockHeader = new byte[64];
                    }
                    try {
                        this.readFully(blockHeader);
                    }
                    catch (EOFException eof) {
                        break;
                    }
                    if (this.isMvsDataset) {
                        rc = Clib.fgetpos(this.fp, this.fpos);
                        assert (rc == 0) : rc;
                        this.fposArray.add(this.fpos);
                    }
                    int eye = Dump.readInt(blockHeader, 0);
                    boolean oldFormat = false;
                    if (eye == -992349888) {
                        oldFormat = true;
                    } else if (eye != -992349632) {
                        throw new Error("bad eyecatcher " + Dump.hex(eye) + " at offset " + offset);
                    }
                    int asid = Dump.readInt(blockHeader, 12);
                    if (asid >= 0) {
                        AddressSpace space;
                        long address;
                        long l = address = oldFormat ? (long)Dump.readInt(blockHeader, 20) : Dump.readLong(blockHeader, 20);
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("read block, asid = " + Dump.hex(asid) + " address = " + Dump.hex(address));
                        }
                        if ((space = (AddressSpace)asidMap.get(asid)) == null) {
                            space = new AddressSpace(this, asid);
                            asidMap.put(asid, space);
                        }
                        space.mapAddressToFileOffset(address, offset + 64L);
                        if (asid == 1) {
                            this.rootSpace = space;
                        }
                        if (offset == 0L) {
                            byte[] titlebuf = new byte[100];
                            System.arraycopy(blockHeader, 88, titlebuf, 0, 100);
                            this.title = CharConversion.getEbcdicString(titlebuf);
                            this.productName = CharConversion.getEbcdicString(blockHeader, 244, 16);
                            this.productVersion = CharConversion.getEbcdicString(blockHeader, 260, 2);
                            this.productRelease = CharConversion.getEbcdicString(blockHeader, 262, 2);
                            long c1 = Dump.readInt(blockHeader, 72);
                            long c2 = Dump.readInt(blockHeader, 76);
                            this.creationDate = Dump.mvsClockToDate(c1 << 32 | c2 & 0xFFFFFFFFL);
                        }
                    }
                    offset += 4160L;
                }
                this.fposArray.close();
                if (this.isMvsDataset) {
                    log.fine("fposArray used " + this.fposArray.memoryUsage());
                }
                this.spaces = (AddressSpace[])asidMap.toArray(new AddressSpace[0]);
                Arrays.sort(this.spaces, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        AddressSpace space1 = (AddressSpace)o1;
                        AddressSpace space2 = (AddressSpace)o2;
                        return space1.getAsid() - space2.getAsid();
                    }
                });
                this.seek(0L);
                log.fine("scan complete");
                if (createCacheFile && this.filename != null) {
                    File cacheFile = new File(this.filename + ".zcache");
                    this.createCacheFile(cacheFile);
                }
            }
        }
        catch (IOException e) {
            throw new Error("Unexpected exception reading address spaces", e);
        }
    }

    private void readCacheFile(File cacheFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(cacheFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        log.fine("cache file exists, reading contents");
        this.spaces = (AddressSpace[])ois.readObject();
        for (int i = 0; i < this.spaces.length; ++i) {
            this.spaces[i].setDump(this);
            if (this.spaces[i].getAsid() != 1) continue;
            this.rootSpace = this.spaces[i];
        }
        this.fposArray = (CompressedRecordArray)ois.readObject();
        this.title = (String)ois.readObject();
        this.creationDate = (Date)ois.readObject();
        this.productName = (String)ois.readObject();
        this.productVersion = (String)ois.readObject();
        this.productRelease = (String)ois.readObject();
        this.productModification = (String)ois.readObject();
        ois.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCacheFile(File cacheFile) {
        try (FileOutputStream fos = new FileOutputStream(cacheFile);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(this.spaces);
            oos.writeObject(this.fposArray);
            oos.writeObject(this.title);
            oos.writeObject(this.creationDate);
            oos.writeObject(this.productName);
            oos.writeObject(this.productVersion);
            oos.writeObject(this.productRelease);
            oos.writeObject(this.productModification);
            log.fine("created cache file " + cacheFile);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Unable to create cache file " + cacheFile, e);
        }
    }

    static int readInt(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("read int 0x" + Dump.hex(n) + " at offset 0x" + Dump.hex(offset));
        }
        return n;
    }

    static long readLong(byte[] buf, int offset) {
        long upper = Dump.readInt(buf, offset);
        long lower = Dump.readInt(buf, offset + 4);
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    @Override
    public void seek(long offset) throws IOException {
        super.seek(offset);
        if (this.isMvsDataset) {
            long blockNumber = offset / 4160L;
            this.fposArray.get((int)blockNumber, this.fpos);
            int rc = Clib.fsetpos(this.fp, this.fpos);
            if (rc != 0) {
                throw new IOException("fsetpos failed");
            }
            long remainder = offset - (blockNumber * 4160L + 64L);
            if (remainder != 0L) {
                throw new Error("TEMP!");
            }
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.finer("raf seek to offset 0x" + Dump.hex(offset));
            }
            this.raf.seek(offset);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int r = this.read(buf);
        if (r <= 0) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int n;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read into " + buf + " " + Dump.hex(off) + " " + Dump.hex(len));
        }
        if (this.isMvsDataset) {
            if (off == 0) {
                n = Clib.fread(buf, 1, len, this.fp);
            } else {
                byte[] buf2 = new byte[len];
                n = Clib.fread(buf2, 1, len, this.fp);
                if (n > 0) {
                    System.arraycopy(buf2, 0, buf, off, n);
                }
            }
        } else {
            n = this.raf.read(buf, off, len);
        }
        if (n > 0) {
            this.streamPos += (long)n;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("read 0x" + Dump.hex(n) + " bytes");
        }
        return n;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int n;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read into " + buf + " " + Dump.hex(buf.length));
        }
        if ((n = this.isMvsDataset ? Clib.fread(buf, 1, buf.length, this.fp) : this.raf.read(buf)) > 0) {
            this.streamPos += (long)n;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("read 0x" + Dump.hex(n) + " bytes");
        }
        return n;
    }

    @Override
    public long length() {
        if (this.isMvsDataset) {
            return -1L;
        }
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public AddressSpace[] getAddressSpaces() {
        return this.spaces;
    }

    public boolean is64bit() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public String getProductModification() {
        return this.productModification;
    }

    public static Date mvsClockToDate(long clock) {
        clock >>>= 12;
        clock /= 1000L;
        long epoch = 613608L;
        epoch *= 3600L;
        return new Date(clock -= (epoch *= 1000L));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static String hex(long n) {
        return Long.toHexString(n);
    }
}

