/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.j9.J9RAS;
import com.ibm.dtfj.corereaders.j9.Memory;

public class J9RASReader {
    private Memory memory = null;
    private J9RAS j9ras = null;

    public J9RASReader(IAbstractAddressSpace space, boolean is64Bit) {
        this.memory = new Memory(space);
    }

    private void findJ9RAS() throws MemoryAccessException {
        if (this.j9ras == null || !this.j9ras.isValid()) {
            long address = this.memory.findPattern(J9RAS.J9RAS_EYECATCHER_BYTES, 0, 0L);
            while (address != -1L) {
                this.j9ras = new J9RAS(this.memory, address);
                if (this.j9ras.isValid()) {
                    return;
                }
                address = this.memory.findPattern(J9RAS.J9RAS_EYECATCHER_BYTES, 0, address + 1L);
            }
        }
    }

    protected long getThreadID() throws UnsupportedOperationException, MemoryAccessException, CorruptCoreException {
        this.findJ9RAS();
        if (this.j9ras == null || !this.j9ras.isValid()) {
            throw new CorruptCoreException("Could not find a valid J9RAS structure in the core file");
        }
        return this.j9ras.getTID();
    }

    protected long getProcessID() throws UnsupportedOperationException, MemoryAccessException, CorruptCoreException {
        this.findJ9RAS();
        if (this.j9ras == null || !this.j9ras.isValid()) {
            throw new CorruptCoreException("Could not find a valid J9RAS structure in the core file");
        }
        return this.j9ras.getPID();
    }
}

