/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkCASetUp;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Vector;

public final class PkSsCertFactory
implements PkConstants {
    private PkSsCertFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static PkSsCertificate newSsCert(String string) throws PkRejectionException {
        return new PkSsCertImpl(string, null);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(String string, Date date) throws PkRejectionException {
        return new PkSsCertImpl(string, date);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, boolean bl, boolean bl2, String string2) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, null, bl, bl2, string2);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, Date date, boolean bl, boolean bl2, String string2) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, date, bl, bl2, string2);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, boolean bl, boolean bl2, String string2, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, null, bl, bl2, string2, keyPair);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, Date date, boolean bl, boolean bl2, String string2, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, date, bl, bl2, string2, keyPair);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, null, bl, bl2, list, list2, list3, string2);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, Date date, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, date, bl, bl2, list, list2, list3, string2);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, null, bl, bl2, list, list2, list3, string2, keyPair, false);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, Date date, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, date, bl, bl2, list, list2, list3, string2, keyPair, false);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int n, String string, int n2, Date date, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair, boolean bl3) throws PkRejectionException {
        return new PkSsCertImpl(n, string, n2, date, bl, bl2, list, list2, list3, string2, keyPair, bl3);
    }

    public static PkSsCertificate newSsCert(int n, String string, String string2, String string3, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, KeyPair keyPair, boolean bl2) throws PkRejectionException {
        return new PkSsCertImpl(n, string, string2, string3, n2, date, bl, list, list2, list3, string4, keyPair, bl2);
    }

    public static SubjectAlternativeNameExtension createSubjectAltName(List<String> list, Debug debug, Object object) throws Exception {
        SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
        if (list != null) {
            int n;
            String[] stringArray;
            GeneralNames generalNames = new GeneralNames();
            boolean bl = false;
            int n2 = list.size();
            if (list.get(0) != null) {
                if (debug != null) {
                    debug.text(0L, object, "createSubjectAltName", "Processing {0}", (Object)list.get(0));
                }
                stringArray = PkNewCertFactory.getTrimmedSanValues(list.get(0));
                for (n = 0; n < stringArray.length; ++n) {
                    generalNames.addElement((Object)new RFC822Name(stringArray[n]));
                }
                bl = true;
            }
            if (n2 > 1 && list.get(1) != null) {
                if (debug != null) {
                    debug.text(0L, object, "createSubjectAltName", "Processing {1}", (Object)list.get(1));
                }
                stringArray = PkNewCertFactory.getTrimmedSanValues(list.get(1));
                for (n = 0; n < stringArray.length; ++n) {
                    generalNames.addElement((Object)new DNSName(stringArray[n], true, true));
                }
                bl = true;
            }
            if (n2 > 2 && list.get(2) != null) {
                if (debug != null) {
                    debug.text(0L, object, "createSubjectAltName", "Processing {2}", (Object)list.get(2));
                }
                stringArray = PkNewCertFactory.getTrimmedSanValues(list.get(2));
                for (n = 0; n < stringArray.length; ++n) {
                    generalNames.addElement((Object)new URIName(stringArray[n]));
                }
                bl = true;
            }
            if (n2 > 3 && list.get(3) != null) {
                if (debug != null) {
                    debug.text(0L, object, "createSubjectAltName", "Processing {3}", (Object)list.get(3));
                }
                stringArray = PkNewCertFactory.getTrimmedSanValues(list.get(3));
                for (n = 0; n < stringArray.length; ++n) {
                    generalNames.addElement((Object)new IPAddressName(PkSsCertImpl.getIPAddress(stringArray[n])));
                }
                bl = true;
            }
            if (bl) {
                subjectAlternativeNameExtension = new SubjectAlternativeNameExtension(generalNames);
            }
        } else if (debug != null) {
            debug.text(0L, object, "createSubjectAltName", "No subject Alt Names provided");
        }
        return subjectAlternativeNameExtension;
    }

    private static final class PkSsCertImpl
    implements PkSsCertificate,
    PkConstants {
        private KeyPair ssKey;
        private X509Certificate ssCert;
        private Date notBefore;
        private byte[] ssKeyIdentifier = null;
        private static int OID_LIST_SIZE = 18;
        private static List<ObjectIdentifier> algList = new ArrayList<ObjectIdentifier>(OID_LIST_SIZE);
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private static final Object className = "com.ibm.security.certclient.PkSsCertImpl";

        @Deprecated
        PkSsCertImpl(String string, Date date) throws PkRejectionException {
            this(1024, string, 365, date, true, false, null, null, null, "IBMJCE", null, false);
        }

        @Deprecated
        PkSsCertImpl(int n, String string, int n2, Date date, boolean bl, boolean bl2, String string2) throws PkRejectionException {
            this(n, string, n2, date, bl, bl2, null, null, null, string2, null, false);
        }

        @Deprecated
        PkSsCertImpl(int n, String string, int n2, Date date, boolean bl, boolean bl2, String string2, KeyPair keyPair) throws PkRejectionException {
            this(n, string, n2, date, bl, bl2, null, null, null, string2, keyPair, false);
        }

        @Deprecated
        PkSsCertImpl(int n, String string, int n2, Date date, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2) throws PkRejectionException {
            this(n, string, n2, date, bl, bl2, list, list2, list3, string2, null, false);
        }

        @Deprecated
        PkSsCertImpl(int n, String string, int n2, Date date, boolean bl, boolean bl2, List<String> list, List<String> list2, List<String> list3, String string2, KeyPair keyPair, boolean bl3) throws PkRejectionException {
            String string3 = "RSA";
            String string4 = "SHA1withRSA";
            if (keyPair == null) {
                if (!bl) {
                    string3 = "DSA";
                    string4 = "SHA1withDSA";
                }
            } else {
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("RSA")) {
                    string4 = "SHA1withRSA";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("DSA")) {
                    string4 = "SHA1withDSA";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("EC")) {
                    string4 = "SHA1withECDSA";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("Ed25519")) {
                    string4 = "Ed25519";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("Ed448")) {
                    string4 = "Ed448";
                }
            }
            this.generateKeyPairNCert(n, string3, string4, string, n2, date, bl2, list, list2, list3, string2, keyPair, bl3);
        }

        PkSsCertImpl(int n, String string, String string2, String string3, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, KeyPair keyPair, boolean bl2) throws PkRejectionException {
            this.generateKeyPairNCert(n, string, string2, string3, n2, date, bl, list, list2, list3, string4, keyPair, bl2);
        }

        void generateKeyPairNCert(int n, String string, String string2, String string3, int n2, Date date, boolean bl, List<String> list, List<String> list2, List<String> list3, String string4, KeyPair keyPair, boolean bl2) throws PkRejectionException {
            X500Name x500Name = this.validSubject(string3);
            this.notBefore = date;
            this.ssKey = keyPair != null ? keyPair : this.generateLocalKey(string, n, "IBMSecureRandom", string4);
            this.ssCert = this.generateSsCertificate(2, string2, x500Name, this.ssKey.getPublic(), n2, this.generateKID(bl), list, list2, list3, string4, bl2);
            this.ssCertSign(string2, string4);
        }

        private byte[] generateKID(boolean bl) throws PkRejectionException {
            try {
                byte[] byArray = PkCASetUp.computeKID(this.ssKey.getPublic(), bl);
                if (debug != null) {
                    debug.text(0L, className, "generateKID", "Subject Key Identifier is {0}", (Object)byArray);
                }
                return byArray;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
        }

        private X500Name validSubject(String string) throws PkRejectionException {
            X500Name x500Name;
            try {
                x500Name = new X500Name(string);
                if (debug != null) {
                    debug.text(0L, className, "validSubject", "X500Name is {0}", (Object)x500Name);
                }
            }
            catch (IOException iOException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_SUBJECT_NAME, iOException);
            }
            return x500Name;
        }

        private KeyPair generateLocalKey(String string, int n, String string2, String string3) throws PkRejectionException {
            KeyPair keyPair;
            int n2;
            String string4 = string == null || string.length() == 0 ? "RSA" : string;
            int n3 = n2 = n == 0 ? 1024 : n;
            if (debug != null) {
                debug.text(0L, className, "generateLocalKey", "Keytype is {0}", (Object)string4);
                debug.text(0L, className, "generateLocalKey", "Provider is {0}", (Object)string3);
                debug.text(0L, className, "generateLocalKey", "KeySize is {0}", (Object)new Integer(n2));
            }
            if ("IBMJCEPlusFIPS".equalsIgnoreCase(string3) && "IBMSecureRandom".equalsIgnoreCase(string2)) {
                string2 = "SHA2DRBG";
            }
            try {
                KeyPairGenerator keyPairGenerator = string3 != null && string3.length() != 0 ? KeyPairGenerator.getInstance(string4, string3) : KeyPairGenerator.getInstance(string4);
                SecureRandom secureRandom = string2 == null || string2.length() == 0 ? SecureRandom.getInstance("IBMJCE") : SecureRandom.getInstance(string2, "IBMJCE");
                if (debug != null) {
                    debug.text(0L, className, "generateLocalKey", "RNG is {0}", (Object)secureRandom);
                }
                keyPairGenerator.initialize(n, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, noSuchProviderException);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + n, invalidParameterException);
            }
            return keyPair;
        }

        private X509Certificate generateSsCertificate(int n, String string, X500Name x500Name, PublicKey publicKey, int n2, byte[] byArray, List<String> list, List<String> list2, List<String> list3, String string2, boolean bl) throws PkRejectionException {
            X509CertImpl x509CertImpl;
            BigInteger bigInteger;
            Date date;
            AlgorithmId algorithmId;
            String string3;
            X509CertInfo x509CertInfo = new X509CertInfo();
            if (debug != null) {
                debug.text(0L, className, "generateSsCertificate", "Version is {0}", (Object)new Integer(n));
            }
            if (n != 2) {
                throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_INVALID);
            }
            if (debug != null) {
                debug.text(0L, className, "generateSsCertificate", "Validity Period is {0}", (Object)new Integer(n2));
            }
            if (n2 <= 0) {
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            String string4 = string3 = string2 == null || string2.length() == 0 ? "IBMJCE" : string2;
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Signing algorithm is {0}", (Object)string);
                debug.text(0L, className, "createSubjectAltName", "Provider is {0}", (Object)string3);
            }
            try {
                algorithmId = AlgorithmId.get((String)string, (String)string3);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
            ObjectIdentifier objectIdentifier = algorithmId.getOID();
            if (!algList.contains(objectIdentifier)) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM);
            }
            Date date2 = new Date();
            Date date3 = new Date();
            if (this.notBefore != null) {
                date = new Date();
                if (this.notBefore.getTime() < date.getTime() - 259200000L) {
                    throw new PkRejectionException("notBefore Time cannot exceed more than 3 days prior to the UTC time");
                }
                date2.setTime(this.notBefore.getTime());
                date3.setTime(this.notBefore.getTime());
            }
            date3.setTime(date3.getTime() + (long)(n2 * 24 * 60 * 60) * 1000L);
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Start date {0}", (Object)date2);
                debug.text(0L, className, "createSubjectAltName", "End date {0}", (Object)date3);
            }
            date = new CertificateValidity(date2, date3);
            CertificateExtensions certificateExtensions = new CertificateExtensions();
            if (debug != null) {
                debug.text(0L, className, "createBasicConstraints", "Want CA {0}", Optional.of(bl));
            }
            try {
                SubjectAlternativeNameExtension subjectAlternativeNameExtension;
                x509CertInfo.set("version", (Object)new CertificateVersion(n));
                bigInteger = BigInteger.valueOf(System.nanoTime());
                x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber(bigInteger));
                x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
                x509CertInfo.set("subject", (Object)x500Name);
                x509CertInfo.set("issuer", (Object)x500Name);
                x509CertInfo.set("key", (Object)new CertificateX509Key(publicKey));
                x509CertInfo.set("validity", (Object)date);
                if (list != null && list.size() > 0) {
                    subjectAlternativeNameExtension = PkSsCertFactory.createSubjectAltName(list, debug, className);
                    certificateExtensions.set("x509.info.extensions.SubjectAlternativeName", (Object)subjectAlternativeNameExtension);
                }
                if (byArray != null) {
                    this.ssKeyIdentifier = byArray;
                    subjectAlternativeNameExtension = new SubjectKeyIdentifierExtension(byArray);
                    certificateExtensions.set("x509.info.extensions.SubjectKeyIdentifier", (Object)subjectAlternativeNameExtension);
                }
                if (list2 != null && !list2.isEmpty()) {
                    subjectAlternativeNameExtension = this.setKeyUsageExt(list2);
                    certificateExtensions.set("x509.info.extensions.KeyUsage", (Object)subjectAlternativeNameExtension);
                }
                if (bl) {
                    subjectAlternativeNameExtension = new BasicConstraintsExtension(true, -1);
                    certificateExtensions.set("x509.info.extensions.BasicConstraints", (Object)subjectAlternativeNameExtension);
                }
                if (list3 != null && !list3.isEmpty()) {
                    subjectAlternativeNameExtension = this.setextKeyUsageExt(list3);
                    certificateExtensions.set("x509.info.extensions.ExtKeyUsage", (Object)subjectAlternativeNameExtension);
                }
                x509CertInfo.set("extensions", (Object)certificateExtensions);
            }
            catch (CertificateException certificateException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, certificateException);
            }
            catch (IOException iOException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, iOException);
            }
            catch (Exception exception) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, exception);
            }
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Raw certificate request created with serial {0}", (Object)bigInteger);
            }
            try {
                x509CertImpl = new X509CertImpl(x509CertInfo, string3);
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, certificateParsingException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, certificateEncodingException);
            }
            return x509CertImpl;
        }

        private KeyUsageExtension setKeyUsageExt(List<String> list) throws IOException, PkRejectionException {
            KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
            for (String string : list) {
                if (debug != null) {
                    debug.text(0L, className, "setKeyUsageExt", "Processing {0}", (Object)string);
                }
                if (string.equalsIgnoreCase("digital_signature")) {
                    keyUsageExtension.set("digital_signature", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("data_encipherment")) {
                    keyUsageExtension.set("data_encipherment", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("encipher_only")) {
                    keyUsageExtension.set("encipher_only", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("decipher_only")) {
                    keyUsageExtension.set("decipher_only", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("non_repudiation")) {
                    keyUsageExtension.set("non_repudiation", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("key_encipherment")) {
                    keyUsageExtension.set("key_encipherment", (Object)Boolean.TRUE);
                    continue;
                }
                if (string.equalsIgnoreCase("key_agreement")) {
                    keyUsageExtension.set("key_agreement", (Object)Boolean.TRUE);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            return keyUsageExtension;
        }

        private ExtKeyUsageExtension setextKeyUsageExt(List<String> list) throws IOException, PkRejectionException {
            ExtKeyUsageExtension extKeyUsageExtension = null;
            Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>();
            for (String string : list) {
                if (debug != null) {
                    debug.text(0L, className, "setextKeyUsageExt", "Processing {0}", (Object)string);
                }
                if (string.equalsIgnoreCase("ServerAuth_Id")) {
                    vector.add(PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("ClientAuth_Id")) {
                    vector.add(PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("CodeSigning_Id")) {
                    vector.add(PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("EmailProtection_Id")) {
                    vector.add(PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("IPSecEndSystem_Id")) {
                    vector.add(PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("IPSecTunnel_Id")) {
                    vector.add(PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("IPSecUser_Id")) {
                    vector.add(PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("TimeStamping_Id")) {
                    vector.add(PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            if (vector.size() > 0) {
                extKeyUsageExtension = new ExtKeyUsageExtension(vector);
            }
            return extKeyUsageExtension;
        }

        static byte[] getIPAddress(String string) {
            String[] stringArray = PkString.split(string, ".");
            byte[] byArray = new byte[]{new Integer(stringArray[0]).byteValue(), new Integer(stringArray[1]).byteValue(), new Integer(stringArray[2]).byteValue(), new Integer(stringArray[3]).byteValue()};
            return byArray;
        }

        private void ssCertSign(String string, String string2) throws PkRejectionException {
            if (debug != null) {
                debug.text(0L, className, "ssCertSign", "Signing with {0}", (Object)string);
            }
            try {
                ((X509CertImpl)this.ssCert).sign(this.ssKey.getPrivate(), string, string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE, invalidKeyException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, noSuchProviderException);
            }
            catch (SignatureException signatureException) {
                throw new PkRejectionException(PkNLSConstants.BAD_SS_CERT_SIGNATURE, signatureException);
            }
            catch (CertificateException certificateException) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, certificateException);
            }
            if (debug != null) {
                debug.text(0L, className, "ssCertSign", "Signed OK by provider {0}", (Object)string2);
            }
        }

        @Override
        public PrivateKey getKey() {
            return this.ssKey.getPrivate();
        }

        @Override
        public X509Certificate getCertificate() {
            return this.ssCert;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.ssKey.getPublic();
        }

        @Override
        public String getSubjectName() {
            return this.ssCert.getSubjectDN().getName();
        }

        @Override
        public String getSigAlg() {
            return this.ssCert.getSigAlgName();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.ssKeyIdentifier;
        }

        @Override
        public void setToKeyStore(String string, String string2, KeyStore keyStore) throws PkException {
            if (string == null || string.length() == 0) {
                throw new PkException(PkNLSConstants.HTTP_BAD_OR_MISSING_ALIAS);
            }
            if (keyStore == null) {
                throw new PkException(PkNLSConstants.MISSING_KEYSTORE);
            }
            if (string2 == null || string2.length() == 0) {
                throw new PkException(PkNLSConstants.TUI_INVALIDPWD);
            }
            Certificate[] certificateArray = new X509Certificate[]{this.ssCert};
            try {
                keyStore.setKeyEntry(string, this.ssKey.getPrivate(), string2.toCharArray(), certificateArray);
            }
            catch (KeyStoreException keyStoreException) {
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE);
            }
        }

        static {
            algList.add(AlgorithmId.sha1WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithRSAEncryption_OIW_oid);
            algList.add(AlgorithmId.sha1WithDSA_oid);
            algList.add(AlgorithmId.sha1WithDSA_OIW_oid);
            algList.add(AlgorithmId.shaWithDSA_OIW_oid);
            algList.add(AlgorithmId.md5WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithECDSA_oid);
            algList.add(AlgorithmId.sha224WithECDSA_oid);
            algList.add(AlgorithmId.sha256WithECDSA_oid);
            algList.add(AlgorithmId.sha384WithECDSA_oid);
            algList.add(AlgorithmId.sha512WithECDSA_oid);
            algList.add(AlgorithmId.md2WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha256WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha384WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha512WithRSAEncryption_oid);
            algList.add(AlgorithmId.Ed25519_oid);
            algList.add(AlgorithmId.Ed448_oid);
        }
    }
}

