/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkBase64InputStream;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.tools.CertAndKeyGen;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class PkCertUtils {
    private static final String sccsid = "@(#) 86 1.13    com/tivoli/pki/util/PkCertUtils.java, PkUtil, javapki2, 10222004 6/25/04 14:34:08";
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "PkCertUtils";
    private static final String RSA_KEY = "RSA";
    private static final String DSA_KEY = "DSA";
    private static final String ECC_KEY = "EC";
    private static final String EDD_KEY = "ED";

    public static void screenCert(X509Certificate x509Certificate, boolean bl) throws PkException {
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new PkRejectionException(certificateExpiredException.getMessage());
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new PkRejectionException(certificateNotYetValidException.getMessage());
        }
        if (bl && x509Certificate.getBasicConstraints() == -1) {
            throw new PkRejectionException(PkNLSConstants.CERT_MUST_BE_CA_CERT);
        }
    }

    public static void writeCrlToFile(X509CRL x509CRL, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(x509CRL.getEncoded());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to write crl to file. Error = " + exception.getMessage());
        }
    }

    public static void writeCertToFile(X509Certificate x509Certificate, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(x509Certificate.getEncoded());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to write cert to file. Error = " + exception.getMessage());
            System.out.println("cert file written to file tmp#$!.cer instead");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("tmp#$!.cer");
                fileOutputStream.write(x509Certificate.getEncoded());
            }
            catch (Exception exception2) {
                System.out.println("Unable to write cert to file tmp#$!.cer . Error = " + exception.getMessage());
            }
        }
    }

    public static Key[] generateKeyPair0(boolean bl, int n) throws Exception {
        Key[] keyArray = new Key[2];
        CertAndKeyGen certAndKeyGen = bl ? new CertAndKeyGen(RSA_KEY, "SHA1WithRSA") : new CertAndKeyGen(DSA_KEY, "SHA1WithDSA");
        certAndKeyGen.generate(n);
        Key key = certAndKeyGen.newGetPublicKey();
        PrivateKey privateKey = certAndKeyGen.getPrivateKey();
        KeyFactory keyFactory = bl ? KeyFactory.getInstance(RSA_KEY, PkEeFactory.getProvider()) : KeyFactory.getInstance(DSA_KEY, PkEeFactory.getProvider());
        X509Key x509Key = (X509Key)keyFactory.translateKey(key);
        keyArray[0] = x509Key;
        keyArray[1] = privateKey;
        return keyArray;
    }

    @Deprecated
    public static Key[] generateKeyPair(boolean bl, int n) throws Exception {
        return PkCertUtils.generateKeyPair(bl ? RSA_KEY : DSA_KEY, n, null);
    }

    public static Key[] generateKeyPair(String string, int n, String string2) throws Exception {
        KeyFactory keyFactory;
        KeyPairGenerator keyPairGenerator;
        Key[] keyArray = new Key[2];
        KeyPair keyPair = null;
        if (string2 != null && string2.length() != 0) {
            keyPairGenerator = KeyPairGenerator.getInstance(string, string2);
            keyFactory = KeyFactory.getInstance(string, string2);
        } else {
            keyPairGenerator = KeyPairGenerator.getInstance(string);
            keyFactory = KeyFactory.getInstance(string);
        }
        keyPairGenerator.initialize(n);
        keyPair = keyPairGenerator.generateKeyPair();
        X509Key x509Key = null;
        x509Key = (X509Key)keyFactory.translateKey(keyPair.getPublic());
        keyArray[0] = x509Key;
        keyArray[1] = keyPair.getPrivate();
        return keyArray;
    }

    private static X509CertImpl readCert(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        fileInputStream.close();
        X509CertImpl x509CertImpl = new X509CertImpl(x509Certificate.getEncoded());
        return x509CertImpl;
    }

    public static X509Certificate readCert64(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PkBase64InputStream pkBase64InputStream = new PkBase64InputStream(byteArrayInputStream);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(pkBase64InputStream);
        ((InputStream)byteArrayInputStream).close();
        fileInputStream.close();
        return x509Certificate;
    }

    public static X509CRL readCRL(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        fileInputStream.close();
        return x509CRL;
    }

    private static CertificationRequest readPKCS10CertReq64(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return PkCertUtils.readPKCS10CertReq64(byArray);
    }

    private static CertificationRequest readPKCS10CertReq64(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DerValue derValue = new DerValue((InputStream)new PkBase64InputStream(byteArrayInputStream));
        CertificationRequest certificationRequest = new CertificationRequest(derValue.toByteArray());
        ((InputStream)byteArrayInputStream).close();
        return certificationRequest;
    }

    private static CertificationRequest readPKCS10CertReq(String string, boolean bl) throws Exception {
        return new CertificationRequest(string, bl);
    }

    private static CertificationRequest createPKCS10CertReq(String string, PublicKey publicKey, PrivateKey privateKey, String string2) throws IOException, NoSuchAlgorithmException, PKCSException {
        CertificationRequest certificationRequest = null;
        X500Name x500Name = new X500Name(string);
        PKCSAttributes pKCSAttributes = null;
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(x500Name, publicKey, pKCSAttributes);
        certificationRequest = new CertificationRequest(certificationRequestInfo, privateKey, string2);
        return certificationRequest;
    }

    public static KeyStore keyStore(String string, String string2, char[] cArray) throws PkException {
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(string, PkEeFactory.getProvider());
            try {
                fileInputStream = new FileInputStream(string2);
                keyStore.load(fileInputStream, cArray);
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                keyStore.load(null, cArray);
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                keyStore.store(fileOutputStream, cArray);
                fileOutputStream.close();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (debug != null) {
                debug.exception(4L, className, "keyStore", (Throwable)generalSecurityException);
            }
            throw new PkException(generalSecurityException);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(4L, className, "keyStore", (Throwable)iOException);
            }
            throw new PkException(iOException);
        }
        return keyStore;
    }
}

