/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.cmp.CertRepMessage;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class PkCertRepEvent
extends PkRepEvent {
    private static final long serialVersionUID = 7268145541632707758L;
    private Certificate cert;
    private Object message = null;

    public PkCertRepEvent(Object object, Object object2, PkReqEvent pkReqEvent, Certificate certificate) {
        super(object, object2, pkReqEvent);
        this.cert = certificate;
        this.message = object2;
    }

    public Certificate getCert() {
        return this.cert;
    }

    public X509Certificate[] getCertificateChain() {
        Object object;
        X509Certificate[] x509CertificateArray = null;
        X509Certificate[] x509CertificateArray2 = null;
        X509Certificate x509Certificate = null;
        if (this.message != null && this.message instanceof PKIMessage && (object = ((PKIMessage)this.message).getBody()) != null && object instanceof CertRepMessage) {
            x509CertificateArray = (X509Certificate[])((CertRepMessage)object).getCAPubs();
            x509CertificateArray = this.sortSignerCerts(x509CertificateArray);
            x509Certificate = (X509Certificate)this.getCert();
            if (x509CertificateArray != null && x509Certificate != null) {
                x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
                System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 1, x509CertificateArray.length);
                x509CertificateArray2[0] = x509Certificate;
            }
        }
        return x509CertificateArray2;
    }

    private X509Certificate[] sortSignerCerts(X509Certificate[] x509CertificateArray) {
        Principal principal;
        if (x509CertificateArray.length <= 1) {
            return x509CertificateArray;
        }
        Principal principal2 = x509CertificateArray[x509CertificateArray.length - 1].getSubjectDN();
        if (principal2.equals(principal = x509CertificateArray[x509CertificateArray.length - 1].getIssuerDN())) {
            return x509CertificateArray;
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length];
        int n = x509CertificateArray.length - 1;
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray2[i] = x509CertificateArray[n];
            --n;
        }
        return x509CertificateArray2;
    }

    public String getSubjectDn() {
        return this.getSubjectX500Name().toString();
    }

    private X500Name getSubjectX500Name() {
        return (X500Name)((X509CertImpl)this.cert).getSubjectDN();
    }

    public BigInteger getSerialNumber() {
        return ((X509CertImpl)this.cert).getSerialNumber();
    }

    public byte[] getEncodedCert() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    @Override
    public void write(PkEventFormatter pkEventFormatter, OutputStream outputStream) throws IOException, PkException {
        pkEventFormatter.writeCertRep(this, outputStream);
    }

    @Override
    public String toString() {
        if (this.cert != null) {
            return super.toString() + "\n" + this.cert.toString();
        }
        return super.toString() + "\nEither no cert present or encrypted cert could not be decrypted";
    }
}

