/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeCertReqFactory;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.PkEeReqTransaction;
import com.ibm.security.certclient.base.PkActiveSource;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.beans.PkEeXMgr;
import com.ibm.security.certclient.beans.PkTcpClient;
import com.ibm.security.certclient.util.JPKI;
import com.ibm.security.certclient.util.PkConnector;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.pkcs10.CertificationRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class PkEeCertReq10Factory
extends PkEeFactory {
    private PkEeCertReq10Factory() {
        throw new UnsupportedOperationException();
    }

    public static PkEeReqTransaction newCertRequestPKCS10(String string, String string2, String string3) throws PkException {
        return new CertRequestPKCS10Impl(string, string2, string3);
    }

    private static final class CertRequestPKCS10Impl
    implements PkEeReqTransaction {
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();
        private PkEe3 ee = new PkEe3();
        private boolean eeRun = false;

        CertRequestPKCS10Impl(String string, String string2, String string3) throws PkException {
            this.ee.setCertReqFileName(string);
            this.ee.setiafile(string2);
            this.ee.setrevoPwd(string3);
            this.ee.setCaDn(PkEeFactory.caDn);
            this.ee.setCaPort(PkEeFactory.caPort);
        }

        @Override
        public void actionRequest() throws PkException {
            this.runCertReqPkcs10();
        }

        @Override
        public X509Certificate getSignedCert() {
            if (this.eeRun) {
                return this.ee.getSignedCert();
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain() {
            if (this.eeRun) {
                return this.ee.getCertificateChain();
            }
            return null;
        }

        @Override
        public byte[] getPKCS10CertReq() throws PkRejectionException {
            PkAttrs pkAttrs = this.ee.getAttributes();
            String string = (String)pkAttrs.get("cert.oper.PROVIDER").getValue();
            try {
                CertificationRequest certificationRequest = new CertificationRequest(this.ee.getCertReqFileName(), true, string);
                return certificationRequest.encode();
            }
            catch (IOException iOException) {
                throw new PkRejectionException(iOException.getMessage());
            }
        }

        private void runCertReqPkcs10() throws PkException {
            try {
                String string = this.ee.getCaDn();
                int n = this.ee.getCaPort();
                if (debug != null) {
                    debug.text(1L, this.className, "runCertReqPkcs10", "CARA_HOST={0}", (Object)string);
                    debug.text(1L, this.className, "runCertReqPkcs10", "RA_CMP_PORT={0}", (Object)new Integer(n));
                }
                PkTcpClient pkTcpClient = new PkTcpClient(string, n, PkEeFactory.getCmpFmt(), 1);
                PkConnector.connect((PkActiveSource)this.ee, new PkPipe[]{new PkEeXMgr(), pkTcpClient}).run();
                if (this.ee.getRunFailed()) {
                    throw this.ee.getRunException();
                }
                this.eeRun = true;
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "runCertReqPkcs10()", (Throwable)exception);
                }
                throw new PkException(exception);
            }
        }
    }

    static final class PkEe3
    extends PkActiveSource
    implements PkConstants {
        private String certReqFileName;
        private String refNumber;
        private String passPhrase;
        private String iafile;
        private String revoPwd;
        private String caDn;
        private int caPort;
        private Exception runException = null;
        private boolean runFailed = false;
        private X509Certificate signedCert = null;
        private X509Certificate[] certificateChain = null;
        private PkAttrs attributes = null;
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private final Object className = this.toString();

        protected PkEe3() {
            if (debug != null) {
                debug.text(1L, this.className, "PkEe3", "Begin");
            }
        }

        protected boolean getRunFailed() {
            return this.runFailed;
        }

        protected Exception getRunException() {
            return this.runException;
        }

        protected void setCertReqFileName(String string) throws PkException {
            if (string == null || string.length() <= 0) {
                if (debug != null) {
                    debug.text(1L, this.className, "setCertReqFileName", "CertReqFileName cannot be null");
                }
                throw new PkException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED);
            }
            this.certReqFileName = string;
        }

        protected void setrevoPwd(String string) {
            this.revoPwd = string;
        }

        protected void setrefNumber(String string) {
            this.refNumber = string;
        }

        protected void setpassPhrase(String string) {
            this.passPhrase = string;
        }

        protected void setiafile(String string) throws PkException {
            this.iafile = string;
            this.readIAFile(this.iafile);
        }

        protected void setCaDn(String string) {
            this.caDn = string != null && string.length() != 0 ? string : PkEeFactory.caDn;
        }

        protected void setCaPort(int n) {
            this.caPort = n != 0 ? n : PkEeFactory.caPort;
        }

        protected String getCertReqFileName() {
            return this.certReqFileName;
        }

        protected X509Certificate getSignedCert() {
            return this.signedCert;
        }

        protected X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }

        protected PkAttrs getAttributes() throws PkRejectionException {
            this.attributes = this.getAttrs();
            return this.attributes;
        }

        protected String getCaDn() {
            return this.caDn;
        }

        protected int getCaPort() {
            return this.caPort;
        }

        protected PkAttrs getAttrs() throws PkRejectionException {
            String string = PkEeCertReqFactory.CA_DN;
            String string2 = this.refNumber;
            String string3 = this.passPhrase;
            PkAttrs pkAttrs = new PkAttrs();
            String string4 = new Long(new Date().getTime()).toString();
            long l = 6L;
            l = l * 31L * 24L * 60L * 60L;
            String string5 = new Long(l *= 1000L).toString();
            if (debug != null) {
                debug.text(1L, this.className, "PkAttrs", "issuedCertValidity {0}", (Object)string5);
            }
            JPKI jPKI = new JPKI();
            String[] stringArray = new String[]{string, "3", string2, string3, string4, string5};
            CertificationRequest certificationRequest = null;
            try {
                certificationRequest = new CertificationRequest(this.certReqFileName, true);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "PkAttrs", (Throwable)iOException);
                }
                throw new PkRejectionException(PkNLSConstants.FILE_IO_FAILED, iOException);
            }
            try {
                pkAttrs = jPKI.initialCertRequest(certificationRequest, stringArray);
                PkEeFactory.provider = (String)pkAttrs.get("cert.oper.PROVIDER").getValue();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(4L, this.className, "PkAttrs", (Throwable)exception);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_CERTREQ_FROM_PKCS10_FAILED, exception);
            }
            return pkAttrs;
        }

        @Override
        public void run() {
            PkInitReqEvent pkInitReqEvent;
            PkCertRepEvent pkCertRepEvent = null;
            this.runFailed = false;
            this.runException = null;
            try {
                if (this.attributes == null) {
                    this.attributes = this.getAttrs();
                }
                pkInitReqEvent = new PkInitReqEvent(this, null, this.attributes);
                pkCertRepEvent = this.propagate((PkCertReqEvent)pkInitReqEvent);
                this.signedCert = (X509Certificate)pkCertRepEvent.getCert();
                this.certificateChain = pkCertRepEvent.getCertificateChain();
            }
            catch (Exception exception) {
                this.runFailed = true;
                this.runException = exception;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe3.run", (Throwable)exception);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe3.run", "propagated cert-request");
            }
            pkInitReqEvent = (PKIMessage)pkCertRepEvent.getMsg();
            PKIHeader pKIHeader = pkInitReqEvent.getHeader();
            Object[] objectArray = new Object[]{pKIHeader, this.passPhrase, this.refNumber, this.revoPwd};
            JPKI jPKI = new JPKI();
            try {
                PkConfReqEvent pkConfReqEvent = new PkConfReqEvent(this, null, jPKI.confRequest(objectArray, null));
                this.propagate(pkConfReqEvent);
            }
            catch (Exception exception) {
                this.runFailed = true;
                this.runException = exception;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe3.run", (Throwable)exception);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe3.run", "propagated conf-request");
            }
        }

        private void readIAFile(String string) throws PkException {
            File file;
            if (string == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "readIAFile", "iafile cannot be null");
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
            try {
                file = new File(string);
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    debug.exception(4L, this.className, "readIAFile", (Throwable)nullPointerException);
                }
                throw new PkException("", nullPointerException);
            }
            if (file.exists()) {
                try {
                    if (debug != null) {
                        debug.text(1L, this.className, "readIAFile", "file found now processing");
                    }
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                    String string2 = bufferedReader.readLine();
                    this.refNumber = new String(string2);
                    this.passPhrase = new String(bufferedReader.readLine());
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.text(1L, this.className, "readIAFile", "file processing failed");
                    }
                    throw new PkException(exception.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.text(4L, this.className, "readIAFile", PkNLSConstants.IA_FILE_FORMAT_FAILURE);
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
        }
    }
}

