/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ActiveSection;
import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.ProcessorSection;
import com.ibm.jvm.trace.format.api.ServiceSection;
import com.ibm.jvm.trace.format.api.StartupSection;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TraceSection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class TraceFileHeader {
    TraceContext context;
    String textSummary;
    int recordSize;
    int endianSignature;
    ByteOrder byteOrder;
    boolean ascii = true;
    protected DataHeader dataHeader;
    protected TraceSection traceSection;
    protected ServiceSection serviceSection;
    protected StartupSection startupSection;
    protected ActiveSection activeSection;
    protected ProcessorSection processorSection;
    private static final int BIG_ENDIAN_SIG = 305419896;
    private static final int LITTLE_ENDIAN_SIG = 2018915346;
    private static final int eyecatcherASCII = 0x55545448;
    private static final int eyecatcherEBCDIC = -454827064;

    TraceFileHeader(int recordSize, ByteOrder byteOrder) {
        this.recordSize = recordSize;
        this.byteOrder = byteOrder;
    }

    protected TraceFileHeader(TraceContext context, ByteBuffer data) throws IllegalArgumentException {
        int traceFileHeaderStart = data.position();
        context.metadata = this;
        try {
            this.endianSignature = data.getInt(traceFileHeaderStart + 16 + 4);
            switch (this.endianSignature) {
                case 305419896: {
                    this.byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case 2018915346: {
                    this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid endian signature in trace file header: " + Long.toString(this.endianSignature, 16));
                }
            }
            context.debug(this, 1, "Data is " + this.byteOrder.toString());
            data.order(this.byteOrder);
            this.dataHeader = new DataHeader(context, data, "UTTH");
            if (this.dataHeader.ascii) {
                context.debug(this, 1, "Eyecatchers are in ASCII");
                this.ascii = true;
            } else {
                context.debug(this, 1, "Eyecatchers are in EBCDIC");
                this.ascii = false;
            }
            this.recordSize = data.getInt();
            this.endianSignature = data.getInt();
            int traceStart = data.getInt();
            int serviceStart = data.getInt();
            int startupStart = data.getInt();
            int activeStart = data.getInt();
            int processorStart = data.getInt();
            if (context.debugStream != null) {
                context.debug(this, 1, this.summary());
            }
            this.processorSection = new ProcessorSection(context, (ByteBuffer)data.position(processorStart + traceFileHeaderStart));
            this.traceSection = new TraceSection(context, (ByteBuffer)data.position(traceStart + traceFileHeaderStart));
            this.serviceSection = new ServiceSection(context, (ByteBuffer)data.position(serviceStart + traceFileHeaderStart));
            this.startupSection = new StartupSection(context, (ByteBuffer)data.position(startupStart + traceFileHeaderStart));
            this.activeSection = new ActiveSection(context, (ByteBuffer)data.position(activeStart + traceFileHeaderStart));
            context.version = (float)this.dataHeader.version + (float)this.dataHeader.modification / 10.0f;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Truncated trace file header");
        }
    }

    public String toString() {
        return "Trace file header";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder s = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            s.append("recordSize:     ").append(this.recordSize).append(System.getProperty("line.separator"));
            s.append("endianSignature: 0x").append(Long.toString(this.endianSignature, 16)).append(System.getProperty("line.separator"));
            this.textSummary = s.toString();
        }
        return this.textSummary;
    }
}

