/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

class InputFile
extends ProgramOption {
    List inputFiles = new LinkedList();

    InputFile() {
    }

    String getDescription() {
        return "The binary trace file generated by IBM JVMs. For multi-generational trace files specify the file pattern instead. This option is required";
    }

    String getName() {
        return "input_file";
    }

    Object getValue() {
        return this.inputFiles;
    }

    boolean required() {
        return true;
    }

    void setDefault() {
        if (ProgramOption.AnonymousArgs.isEmpty()) {
            throw new IllegalArgumentException("An input file must be specified");
        }
        this.setValue((String)ProgramOption.AnonymousArgs.get(0));
    }

    void setValue(String value) throws IllegalArgumentException {
        try {
            this.inputFiles.add(new RandomAccessFile(value, "r"));
        }
        catch (FileNotFoundException e) {
            boolean i = false;
            String generation = value;
            if (value.indexOf(35) != -1) {
                throw new IllegalArgumentException("Support for generational files has been removed until file level sorting is implemented");
            }
            throw new IllegalArgumentException("The file \"" + value + "\" specified as the input file could not be found");
        }
    }
}

