/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.vmControl.data;

import com.ibm.java.diagnostics.common.datamodel.data.ControllableData;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataChangedEvent;
import com.ibm.java.diagnostics.common.datamodel.impl.data.ControllableSingleConfigurableItemData;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.healthcenter.sources.ConfigurableSource;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.TraceConfigurableElement;
import com.ibm.java.diagnostics.healthcenter.vmControl.data.VmControlLabels;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TraceControlDataImpl
extends DataImpl {
    private final ConfigurableSource source;
    private final Set<String> requestedTracePoints = new HashSet<String>();
    private final Object tracePointsLock = new Object();

    public TraceControlDataImpl(ConfigurableSource configurableSource) {
        super(VmControlLabels.TRACECONTROL);
        this.source = configurableSource;
    }

    public void enable(String string) {
        this.setEnabled(string, true);
    }

    public void disable(String string) {
        this.setEnabled(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String string, boolean bl) {
        DataBuilder dataBuilder = this.getData(string);
        if (dataBuilder == null) {
            if (this.source != null) {
                Object object = this.tracePointsLock;
                synchronized (object) {
                    this.requestedTracePoints.add(string);
                }
                if (bl) {
                    this.source.enable(string);
                } else {
                    this.source.disable(string);
                }
            }
        } else if (dataBuilder instanceof ControllableData) {
            ControllableData controllableData = (ControllableData)((Object)dataBuilder);
            if (bl) {
                controllableData.enable();
            } else {
                controllableData.disable();
            }
        }
    }

    private ControllableSingleConfigurableItemData createTraceItem(String string, String string2) {
        TraceConfigurableElement traceConfigurableElement = new TraceConfigurableElement(string, string, string2);
        ControllableSingleConfigurableItemData controllableSingleConfigurableItemData = new ControllableSingleConfigurableItemData(traceConfigurableElement, this.source);
        return controllableSingleConfigurableItemData;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String string, boolean bl) {
        DataBuilder dataBuilder = this.getData(string);
        if (dataBuilder instanceof ControllableData) {
            ControllableData controllableData = (ControllableData)((Object)dataBuilder);
            controllableData.setEnabled(bl);
            DataChangedEvent dataChangedEvent = new DataChangedEvent(controllableData);
            this.notifyListeners(dataChangedEvent);
        } else {
            ControllableSingleConfigurableItemData controllableSingleConfigurableItemData = null;
            Object object = this.tracePointsLock;
            synchronized (object) {
                if (this.requestedTracePoints.remove(string)) {
                    String string2 = string;
                    controllableSingleConfigurableItemData = this.createTraceItem(string, string2);
                    this.addData(controllableSingleConfigurableItemData);
                }
            }
            if (controllableSingleConfigurableItemData != null) {
                object = new DataChangedEvent(this, Collections.singleton(controllableSingleConfigurableItemData), null);
                this.notifyListeners((DataChangedEvent)object);
            }
        }
    }
}

