/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.threads.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadLabels;
import java.util.logging.Logger;

public abstract class AbstractThreadParser
implements LineParser {
    protected static final String EYECATCHER = "startThreads";
    protected static String CLASSNAME = AbstractThreadParser.class.getName();
    protected static final Logger TRACE = LogFactory.getTrace(AbstractThreadParser.class);
    protected static final DataFactory factory = DataFactory.getFactory();
    protected AxisPair numberAxisPair = null;
    protected static final String DELIMITER = "@#";
    protected int position = 0;

    protected abstract boolean populateThreadData(DataBuilder var1, String[] var2);

    protected abstract boolean canHandleVersion(String var1);

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "parse");
        if (this.numberAxisPair == null) {
            XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            YDataAxis yDataAxis = AxisUtil.prepareNumberAxis(outputProperties);
            this.numberAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        if (this.populateThreadData(dataBuilder, stringArray)) {
            TRACE.exiting(CLASSNAME, "parse");
            return new ProgressIndicatorImpl(stringArray.length, stringArray.length);
        }
        TRACE.exiting(CLASSNAME, "parse");
        return ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
    }

    protected int findNextDelimeter(String string) {
        return string.indexOf(DELIMITER);
    }

    protected int readNextInteger(String string) {
        int n = this.findNextDelimeter(string);
        int n2 = Integer.valueOf(string.substring(0, n));
        this.position = this.position + n + DELIMITER.length();
        return n2;
    }

    protected double readNextDouble(String string) {
        int n = this.findNextDelimeter(string);
        double d = Double.valueOf(string.substring(0, n));
        this.position = this.position + n + DELIMITER.length();
        return d;
    }

    protected String readNextString(String string, int n, int n2) {
        this.position += n2;
        return string.substring(n, n + n2);
    }

    protected int readNextInteger(String string, int n) {
        return this.readNextInteger(string.substring(n));
    }

    protected double readNextDouble(String string, int n) {
        return this.readNextDouble(string.substring(n));
    }

    protected long readNextLong(String string, int n) {
        return this.readNextLong(string.substring(n));
    }

    protected long readNextLong(String string) {
        int n = this.findNextDelimeter(string);
        long l = Long.valueOf(string.substring(0, n));
        this.position = this.position + n + DELIMITER.length();
        return l;
    }

    protected SubsystemDataBuilder getThreadSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(ThreadLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createThreadSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createThreadSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(ThreadLabels.DATA_LABEL, "com.ibm.java.diagnostics.healthcenter.threads.perspective.ThreadPerspective");
        return subsystemDataBuilder;
    }
}

