/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.DateUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.AbstractClockCyclesConverter;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ClockCyclesToDateConverter
extends AbstractClockCyclesConverter {
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(UnitLabels.CLOCKCYCLES, UnitLabels.TIMESTAMP, UnitLabels.DATE);
    private final DateFormat format = new SimpleDateFormat(DateUnitConverter.formatString);

    public ClockCyclesToDateConverter(TraceMetaData traceMetaData) {
        super(traceMetaData, false, false);
    }

    @Override
    protected double getConversionConstant() {
        return 1.0;
    }

    @Override
    public String unconvertedFormat(double d) {
        long l = Math.round(d);
        return this.format.format(new Date(l));
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return this.unconvertedFormat(d);
    }

    @Override
    public double parseUnconverted(String string) {
        try {
            double d = this.format.parse(string).getTime();
            return d;
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }

    @Override
    public boolean shouldFormatWithUnits() {
        return false;
    }
}

