/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.constants;

import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.Enumerator;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.Messages;

public class GCType
extends Enumerator {
    public static final String IMMORTAL = Messages.getString("VGCGCScopes.immortal");
    public static final String PERMANENT = Messages.getString("VGCGCScopes.permanent");
    public static final String HEAP = Messages.getString("VGCGCScopes.heap");
    public static final String GLOBAL = Messages.getString("VGCGCScopes.global");
    public static final String PGC = "pgc";
    public static final String GMP = "gmp";
    public static final String NURSERY_DISPLAY = "nursery";
    public static final String NURSERY = Messages.getString("VGCGCScopes.scavenger");
    private static final String[] STRINGS = new String[]{NURSERY, GLOBAL, HEAP, IMMORTAL, PERMANENT, "pgc", "gmp"};
    private static final String[] DISPLAY_NAMES = new String[]{"nursery", GLOBAL, HEAP, IMMORTAL, PERMANENT, "pgc", "gmp"};
    private static final Enumerator instance = new GCType();
    public static final int GLOBAL_INT = GCType.nameToInt(GLOBAL);
    public static final int NURSERY_INT = GCType.nameToInt(NURSERY);
    public static final int GMP_INT = GCType.nameToInt("gmp");
    public static final int PGC_INT = GCType.nameToInt("pgc");

    @Override
    protected String[] getStrings() {
        return STRINGS;
    }

    public static int nameToInt(String string) {
        return instance.internalNameToInt(string);
    }

    public static String intToName(int n) {
        return instance.internalIntToName(n);
    }

    public static String intToDisplayName(int n) {
        if (n < 0 || n > DISPLAY_NAMES.length - 1) {
            return UNKNOWN;
        }
        return DISPLAY_NAMES[n];
    }
}

