/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.environment.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.progress.ProgressIndicatorImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.parsers.LineParser;
import com.ibm.java.diagnostics.common.extensions.parsers.ProgressIndicator;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.environment.data.EnvironmentDataImpl;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.environment.parser.Messages;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvironmentParser
implements LineParser {
    private static final String CLASSNAME = EnvironmentParser.class.getName();
    private static final String UNLIMITED = "unlimited";
    private static final int AIX_BLOCKSIZE = 512;
    private static final int LINUX_BLOCKSIZE = 1024;
    private static final String LAUNCHER_FULL_VERSION = "launcher.full.version";
    private static final String COLON = ":";
    private static final String EQUALS = "=";
    private static final String ESCAPED_EQUALS = "\\\\=";
    private static final String BACKSLASH = "\\";
    private static final String ESCAPED_BACKSLASH = "\\\\";
    private static final String ESCAPED_COLON = "\\\\:";
    private static final String DASH = "-";
    private static final String NEW_LINE_BREAK = "linebreak";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String SPACE_LINE = " " + NEWLINE;
    private static final String COMMAND_LINE_SPLITTER = " -";
    public static final Logger TRACE = LogFactory.getTrace(EnvironmentParser.class);
    public static final String VARIABLE_NAME = Messages.getString("EnvironmentParser.2");
    public static final String PROPERTY_NAME = Messages.getString("EnvironmentParser.3");
    public static final String PROPERTY = Messages.getString("EnvironmentParser.4");
    public static final String VALUE = Messages.getString("EnvironmentParser.5");
    private static final String[] TABLE_HEADINGS = new String[]{PROPERTY, VALUE};
    private static final String[] SYSTEM_PROPERTY_TABLE_HEADINGS = new String[]{PROPERTY_NAME, VALUE};
    private static final String[] SECURITY_PROPERTY_TABLE_HEADINGS = new String[]{PROPERTY_NAME, VALUE};
    private static final String[] ENVIRONMENT_VARIABLE_TABLE_COLUMN_HEADINGS = new String[]{VARIABLE_NAME, VALUE};
    public static final String ARGUMENT_SEPARATOR = "@@@";
    private static final String OS_NAME_PROPERTY = "system.os.name";
    private static final String OS_VERSION_PROPERTY = "system.os.version";
    private static final String BITMODE_PROPERTY = "system.com.ibm.bitmode";
    private static final String JAVA_VENDOR_PROPERTY = "system.java.vendor";
    private static final String JAVA_HOME_PROPERTY = "system.java.home";
    private static final String VM_NAME = "system.java.vm.name";
    private static final String PATH_SEPARATOR_PROPERTY = "system.path.separator";
    private static final String CLASSPATH = "system.java.class.path";
    private static final String BOOTCLASSPATH = "system.sun.boot.class.path";
    private static final String JAVAFULLVERSION = "system.java.fullversion";
    private static final String RUNTIME_VERSION = "runtime.version";
    private static final String RUNTIME_VENDOR = "runtime.vendor";
    private static final String RUNTIME_NAME = "runtime.name";
    private static final String OS_ARCH = "os.arch";
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final String NOT_SLASH = "[^\\\\]";
    private static final String ESCAPED_EQUAL_PATTERN = "(?:\\\\=)";
    private static final String NO_UNESCAPED_EQUALS = "(?:[^=]?(?:\\\\=)*)*";
    private static final String PATTERN_STRING = "((?:[^=]?(?:\\\\=)*)*[^\\\\])=(.*)";
    private static final Pattern PATTERN = Pattern.compile("((?:[^=]?(?:\\\\=)*)*[^\\\\])=(.*)");
    private static final String SPECIFICATION_VERSION_PROPERTY = "system.java.specification.version";
    private static final String OS_ARCH_PROPERTY = "system.os.arch";
    private static final String UNIX_HOSTNAME_PROPERTY = "environment.HOSTNAME";
    private static final String WINDOWS_HOSTNAME_PROPERTY = "environment.COMPUTERNAME";
    private static final String JAVA_COMMAND = "environment.IBM_JAVA_COMMAND_LINE";
    private static final Pattern FULL_VERSION_PATTERN = Pattern.compile("java full version \"([^%]*)\"");
    private Map<String, String> map = new HashMap<String, String>();
    private boolean gotGoodData = false;
    private String cleanedCommandLine = null;

    @Override
    public ProgressIndicator parse(DynamicSource dynamicSource, String[] stringArray, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "parse");
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (!(dataBuilder2 instanceof EnvironmentDataImpl)) {
            if (dataBuilder2 != null) {
                dataBuilder.removeData(EnvironmentLabels.ENVIRONMENT_LABEL);
                if (TRACE.isLoggable(Level.FINE)) {
                    TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
                }
            }
            dataBuilder2 = new EnvironmentDataImpl();
        }
        int n = this.populateEnvironmentData(outputProperties, (EnvironmentDataImpl)dataBuilder2, stringArray);
        if (this.gotGoodData) {
            dataBuilder.addData(dataBuilder2);
        }
        ProgressIndicator progressIndicator = this.gotGoodData ? new ProgressIndicatorImpl(stringArray.length, n) : ProgressIndicatorImpl.NOT_INTERESTED_PROGRESS;
        TRACE.exiting(CLASSNAME, "parse");
        return progressIndicator;
    }

    private int populateEnvironmentData(OutputProperties outputProperties, EnvironmentDataImpl environmentDataImpl, String[] stringArray) {
        Object object;
        String[] stringArray2;
        List<String> list;
        String[] stringArray3;
        TableDataBuilder tableDataBuilder = this.getTableData(environmentDataImpl, EnvironmentLabels.SYSTEM_PROPERTIES, SYSTEM_PROPERTY_TABLE_HEADINGS);
        TableDataBuilder tableDataBuilder2 = this.getTableData(environmentDataImpl, EnvironmentLabels.ENVIRONMENT_VARIABLES, ENVIRONMENT_VARIABLE_TABLE_COLUMN_HEADINGS);
        TableDataBuilder tableDataBuilder3 = this.getTableData(environmentDataImpl, EnvironmentLabels.SECURITY_PROPERTIES, SECURITY_PROPERTY_TABLE_HEADINGS);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3 = stringArray[i];
            if (!this.gotGoodData && stringArray3.startsWith("#") && stringArray3.contains("EnvironmentSource") && !stringArray3.contains("#Configuration saved by")) {
                this.gotGoodData = true;
                continue;
            }
            if (!this.gotGoodData) continue;
            n += stringArray3.getBytes().length;
            list = PATTERN.matcher((CharSequence)stringArray3);
            try {
                boolean bl;
                boolean bl2;
                Object object2;
                String string;
                int n2;
                if (!((Matcher)((Object)list)).matches()) continue;
                stringArray2 = ((Matcher)((Object)list)).group(1);
                object = ((Matcher)((Object)list)).group(2);
                for (n2 = i + 1; n2 < stringArray.length && !stringArray[n2].contains(EQUALS); ++n2) {
                    object = ((String)object).concat(NEWLINE + stringArray[n2]);
                }
                this.map.put((String)stringArray2, (String)object);
                n2 = stringArray2.startsWith("system.") ? 1 : 0;
                if (n2 != 0) {
                    String string2 = stringArray2.substring("system.".length());
                    string = this.cleanProperty((String)object);
                    this.updateTableData(tableDataBuilder, string2, string);
                    if (string2.equalsIgnoreCase("user.timezone") && (object2 = TimeZone.getTimeZone(string)) != null) {
                        outputProperties.setTimeZone((TimeZone)object2);
                    }
                }
                if (bl2 = stringArray2.startsWith("security.")) {
                    string = stringArray2.substring("security.".length());
                    object2 = this.cleanProperty((String)object);
                    this.updateTableData(tableDataBuilder3, string, (String)object2);
                }
                if (!(bl = stringArray2.startsWith("environment."))) continue;
                object2 = stringArray2.substring("environment.".length());
                String string3 = this.cleanProperty((String)object2);
                String string4 = this.cleanProperty((String)object);
                this.updateTableData(tableDataBuilder2, string3, string4);
                continue;
            }
            catch (Throwable throwable) {
                TRACE.fine(throwable.toString());
            }
        }
        if (this.gotGoodData) {
            String string;
            String string5;
            String string6 = this.map.get("command.line.arguments");
            if (string6 != null) {
                this.cleanedCommandLine = this.cleanProperty(string6);
                this.updateData(environmentDataImpl, EnvironmentLabels.COMMAND_LINE, this.cleanedCommandLine, false);
                stringArray3 = this.cleanedCommandLine.split(ARGUMENT_SEPARATOR);
                list = this.toList(stringArray3);
                environmentDataImpl.setCommandLineOptions(list);
                this.updateData(environmentDataImpl, EnvironmentLabels.JAVA_PARAMETERS, this.cleanedCommandLine, false);
            }
            if ((stringArray3 = this.map.get("dump.options")) != null) {
                list = this.cleanProperty((String)stringArray3);
                this.updateData(environmentDataImpl, EnvironmentLabels.DUMP_OPTIONS, (String)((Object)list), false);
                stringArray2 = ((String)((Object)list)).split(ARGUMENT_SEPARATOR);
                object = this.toList(stringArray2);
                environmentDataImpl.setDumpOptions((List<String>)object);
            }
            if ((list = this.map.get("pid")) != null) {
                this.updateData(environmentDataImpl, EnvironmentLabels.PID, (String)((Object)list), false);
            }
            if ((stringArray2 = this.map.get("jar.version")) != null) {
                this.updateData(environmentDataImpl, EnvironmentLabels.AGENT_JAR_VERSION, (String)stringArray2, false);
            }
            if ((object = this.map.get("appmetrics.version")) != null) {
                this.updateData(environmentDataImpl, EnvironmentLabels.APPMETRICS_VERSION, (String)object, false);
            }
            if ((string5 = this.map.get("agentcore.version")) != null) {
                this.updateData(environmentDataImpl, EnvironmentLabels.AGENTCORE_VERSION, string5, false);
            }
            if ((string = this.map.get("native.library.date")) != null) {
                this.updateData(environmentDataImpl, EnvironmentLabels.NATIVE_LIBRARY_BUILD_DATE, string, false);
            }
            this.populateSystemTable(environmentDataImpl, this.map);
            this.populateJVMTable(environmentDataImpl, this.map);
            this.populateConfigurationTable(environmentDataImpl, this.map);
        }
        return n;
    }

    private void updateData(DataBuilder dataBuilder, String string, String string2, boolean bl) {
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder.addData(new StringDataImpl(string, string2));
        } else if (dataBuilder2 instanceof StringDataImpl) {
            if (!dataBuilder2.isEnabled()) {
                dataBuilder.removeData(string);
                dataBuilder.addData(new StringDataImpl(string, string2));
            } else {
                StringDataImpl stringDataImpl = (StringDataImpl)dataBuilder2;
                String string3 = stringDataImpl.getValue();
                if (!string2.equals(string3)) {
                    if (bl) {
                        dataBuilder.removeData(string);
                    }
                    dataBuilder.addData(new StringDataImpl(string, string2));
                }
            }
        }
    }

    private List<String> toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private String cleanProperty(String string) {
        String string2 = string.replaceAll(ESCAPED_COLON, COLON).replaceAll(ESCAPED_EQUALS, EQUALS).replace(ESCAPED_BACKSLASH, BACKSLASH);
        return string2;
    }

    private void populateSystemTable(DataBuilder dataBuilder, Map<String, String> map) {
        TableDataBuilder tableDataBuilder = this.getTableData(dataBuilder, EnvironmentLabels.SYSTEM, TABLE_HEADINGS);
        this.updateRow(map, tableDataBuilder, OS_NAME_PROPERTY, EnvironmentLabels.OS);
        this.updateRow(map, tableDataBuilder, OS_VERSION_PROPERTY, EnvironmentLabels.OS_VERSION);
        this.updateRow(map, tableDataBuilder, OS_ARCH_PROPERTY, EnvironmentLabels.ARCHITECTURE);
        this.updateRow(map, tableDataBuilder, "number.of.processors", EnvironmentLabels.NUMBER_OF_PROCESSORS);
        this.updateRow(map, tableDataBuilder, UNIX_HOSTNAME_PROPERTY, EnvironmentLabels.HOSTNAME);
        this.updateRow(map, tableDataBuilder, WINDOWS_HOSTNAME_PROPERTY, EnvironmentLabels.HOSTNAME);
        this.updateRow(map, tableDataBuilder, OS_NAME, EnvironmentLabels.OS);
        this.updateRow(map, tableDataBuilder, OS_ARCH, EnvironmentLabels.ARCHITECTURE);
        this.updateRow(map, tableDataBuilder, OS_VERSION, EnvironmentLabels.OS_VERSION);
    }

    private void populateConfigurationTable(EnvironmentDataImpl environmentDataImpl, Map<String, String> map) {
        int n;
        int n2;
        String string;
        Object object;
        String[] stringArray;
        Object object2;
        String string2;
        Object object3;
        String[] stringArray2;
        TableDataBuilder tableDataBuilder = this.getTableData(environmentDataImpl, EnvironmentLabels.CONFIGURATION_INFORMATION, TABLE_HEADINGS);
        if (this.cleanedCommandLine != null) {
            stringArray2 = this.cleanedCommandLine.split(ARGUMENT_SEPARATOR);
            object3 = this.toList(stringArray2);
            this.updateTableDataWithList(tableDataBuilder, EnvironmentLabels.JAVA_PARAMETERS, (List<String>)object3);
        }
        if ((stringArray2 = environmentDataImpl.getDumpOptions()) != null) {
            this.updateTableDataWithList(tableDataBuilder, EnvironmentLabels.DUMP_OPTIONS, (List<String>)stringArray2);
        }
        if ((object3 = map.get("command.line")) == null) {
            object3 = map.get(JAVA_COMMAND);
        }
        if (object3 != null) {
            string2 = this.cleanProperty((String)object3);
            object2 = string2.split(COMMAND_LINE_SPLITTER);
            stringArray = new ArrayList<String>(((String[])object2).length);
            stringArray.add(0, object2[0]);
            for (int i = 1; i < ((Object)object2).length; ++i) {
                stringArray.add(i, DASH + (String)object2[i]);
            }
            this.updateTableDataWithList(tableDataBuilder, EnvironmentLabels.COMMAND_LINE, (List<String>)stringArray);
        }
        if ((string2 = map.get(PATH_SEPARATOR_PROPERTY)) != null) {
            object2 = map.get(CLASSPATH);
            if (object2 != null) {
                stringArray = this.cleanProperty((String)object2).split(string2);
                List<String> list = this.toList(stringArray);
                this.updateTableDataWithList(tableDataBuilder, EnvironmentLabels.CLASS_PATH, list);
            }
            if ((stringArray = map.get(BOOTCLASSPATH)) != null) {
                String[] stringArray3 = this.cleanProperty((String)stringArray).split(string2);
                object = this.toList(stringArray3);
                this.updateTableDataWithList(tableDataBuilder, EnvironmentLabels.BOOT_CLASS_PATH, (List<String>)object);
            }
        }
        object2 = map.get("ulimit.all");
        stringArray = new ArrayList();
        if (object2 != null && !((String)object2).equals("")) {
            int n3;
            String[] stringArray4 = ((String)object2).split(NEW_LINE_BREAK);
            for (n3 = 0; n3 < stringArray4.length; ++n3) {
                stringArray.add(stringArray4[n3]);
            }
            this.updateTableDataWithList(tableDataBuilder, EnvironmentLabels.ULIMIT_LABEL, (List<String>)stringArray);
            if (stringArray4.length > 0) {
                for (n3 = 0; n3 < stringArray.size(); ++n3) {
                    String string3;
                    int n4;
                    int n5;
                    String string4;
                    StringDataImpl stringDataImpl;
                    string = (String)stringArray.get(n3);
                    if (string.contains("-c")) {
                        if (string.contains(UNLIMITED)) {
                            stringDataImpl = new StringDataImpl(EnvironmentLabels.ULIMIT_CORE_LABEL, UNLIMITED);
                        } else {
                            int n6;
                            n2 = -1;
                            n = -1;
                            string4 = "";
                            n5 = -1;
                            n4 = -1;
                            for (n6 = 0; n6 < string.length(); ++n6) {
                                if (!Character.isDigit(string.charAt(n6))) continue;
                                n2 = n6;
                                break;
                            }
                            if (n2 != -1) {
                                for (n6 = n2; n6 < string.length(); ++n6) {
                                    if (Character.isDigit(string.charAt(n6))) continue;
                                    n = n6;
                                }
                            }
                            if (n2 != -1 && n == -1) {
                                n = string.length();
                            }
                            string3 = "";
                            if (n2 != -1) {
                                string3 = (String)string.subSequence(n2, n);
                            }
                            if (string3.length() > 0) {
                                n4 = Integer.parseInt(string3);
                                if (map.get(OS_NAME_PROPERTY).equals("Linux")) {
                                    n5 = n4 * 1024;
                                }
                                if (map.get(OS_NAME_PROPERTY).equals("AIX")) {
                                    n5 = n4 * 512;
                                }
                                string4 = Integer.toString(n5);
                            }
                            stringDataImpl = new StringDataImpl(EnvironmentLabels.ULIMIT_CORE_LABEL, string4);
                        }
                        environmentDataImpl.addData(stringDataImpl);
                    }
                    if (!string.contains("-f")) continue;
                    if (string.contains(UNLIMITED)) {
                        stringDataImpl = new StringDataImpl(EnvironmentLabels.ULIMIT_FILE_LABEL, UNLIMITED);
                    } else {
                        int n7;
                        n2 = -1;
                        n = -1;
                        string4 = "";
                        n5 = -1;
                        n4 = -1;
                        for (n7 = 0; n7 < string.length(); ++n7) {
                            if (!Character.isDigit(string.charAt(n7))) continue;
                            n2 = n7;
                            break;
                        }
                        if (n2 != -1) {
                            for (n7 = n2; n7 < string.length(); ++n7) {
                                if (Character.isDigit(string.charAt(n7))) continue;
                                n = n7;
                            }
                        }
                        if (n2 != -1 && n == -1) {
                            n = string.length();
                        }
                        string3 = "";
                        if (n2 != -1) {
                            string3 = (String)string.subSequence(n2, n);
                        }
                        if (string3.length() > 0) {
                            n4 = Integer.parseInt(string3);
                            if (map.get(OS_NAME_PROPERTY).equals("Linux")) {
                                n5 = n4 * 1024;
                            }
                            if (map.get(OS_NAME_PROPERTY).equals("AIX")) {
                                n5 = n4 * 512;
                            }
                            string4 = Integer.toString(n5);
                        }
                        stringDataImpl = new StringDataImpl(EnvironmentLabels.ULIMIT_FILE_LABEL, string4);
                    }
                    environmentDataImpl.addData(stringDataImpl);
                }
            }
        }
        if (environmentDataImpl.getData(EnvironmentLabels.ULIMIT_CORE_LABEL) == null) {
            String string5 = map.get("ulimit.core");
            object = null;
            if (string5 != null && string5.length() > 0) {
                this.updateTableData(tableDataBuilder, EnvironmentLabels.ULIMIT_CORE_LABEL, string5);
                if (string5.contains(UNLIMITED)) {
                    object = new StringDataImpl(EnvironmentLabels.ULIMIT_CORE_LABEL, UNLIMITED);
                    environmentDataImpl.addData((DataBuilder)object);
                } else {
                    boolean bl = true;
                    for (n2 = 0; n2 < string5.length(); ++n2) {
                        if (Character.isDigit(string5.charAt(n2))) continue;
                        bl = false;
                    }
                    if (bl) {
                        n2 = Integer.parseInt(string5);
                        n = 0;
                        if (map.get(OS_NAME_PROPERTY).equals("Linux")) {
                            n = n2 * 1024;
                        }
                        if (map.get(OS_NAME_PROPERTY).equals("AIX")) {
                            n = n2 * 512;
                        }
                        string = Integer.toString(n);
                        object = new StringDataImpl(EnvironmentLabels.ULIMIT_CORE_LABEL, string);
                        environmentDataImpl.addData((DataBuilder)object);
                    }
                }
            }
        }
    }

    private void populateJVMTable(DataBuilder dataBuilder, Map<String, String> map) {
        TableDataBuilder tableDataBuilder = this.getTableData(dataBuilder, EnvironmentLabels.JRE_INFORMATION, TABLE_HEADINGS);
        this.updateRow(map, tableDataBuilder, VM_NAME, EnvironmentLabels.VM_NAME);
        this.updateRow(map, tableDataBuilder, SPECIFICATION_VERSION_PROPERTY, EnvironmentLabels.JAVA_VERSION);
        this.updateRow(map, tableDataBuilder, JAVA_HOME_PROPERTY, EnvironmentLabels.JAVA_HOME);
        this.updateRow(map, tableDataBuilder, JAVA_VENDOR_PROPERTY, EnvironmentLabels.JAVA_VENDOR);
        this.updateRow(map, tableDataBuilder, BITMODE_PROPERTY, EnvironmentLabels.BIT_MODE);
        this.updateRow(map, tableDataBuilder, "jar.version", EnvironmentLabels.AGENT_JAR_VERSION);
        this.updateRow(map, tableDataBuilder, "native.library.date", EnvironmentLabels.NATIVE_LIBRARY_BUILD_DATE);
        this.updateRow(map, tableDataBuilder, "appmetrics.version", EnvironmentLabels.APPMETRICS_VERSION);
        this.updateRow(map, tableDataBuilder, "agentcore.version", EnvironmentLabels.AGENTCORE_VERSION);
        String string = map.get(LAUNCHER_FULL_VERSION);
        if (string != null) {
            String string2 = this.cleanProperty(string);
            Matcher matcher = FULL_VERSION_PATTERN.matcher(string2);
            if (matcher.matches()) {
                String string3 = matcher.group(1);
                this.updateTableData(tableDataBuilder, EnvironmentLabels.FULL_JAVA_VERSION, string3);
            } else {
                this.updateRow(map, tableDataBuilder, JAVAFULLVERSION, EnvironmentLabels.FULL_JAVA_VERSION);
            }
        } else {
            this.updateRow(map, tableDataBuilder, JAVAFULLVERSION, EnvironmentLabels.FULL_JAVA_VERSION);
        }
        this.updateRow(map, tableDataBuilder, "pid", EnvironmentLabels.PID);
        this.updateRow(map, tableDataBuilder, RUNTIME_VERSION, EnvironmentLabels.JAVA_VERSION);
        this.updateRow(map, tableDataBuilder, RUNTIME_VENDOR, EnvironmentLabels.JAVA_VENDOR);
        this.updateRow(map, tableDataBuilder, RUNTIME_NAME, EnvironmentLabels.VM_NAME);
    }

    private void updateRow(Map<String, String> map, TableDataBuilder tableDataBuilder, String string, String string2) {
        String string3 = map.get(string);
        if (string3 != null && string3.length() > 0) {
            String string4 = this.cleanProperty(string3);
            this.updateTableData(tableDataBuilder, string2, string4);
        }
    }

    private TableDataBuilder getTableData(DataBuilder dataBuilder, String string, String[] stringArray) {
        TableDataBuilder tableDataBuilder = (TableDataBuilder)dataBuilder.getData(string);
        if (tableDataBuilder == null) {
            tableDataBuilder = new TableDataImpl(string, stringArray);
            dataBuilder.addData(tableDataBuilder);
        }
        return tableDataBuilder;
    }

    private void updateTableData(TableDataBuilder tableDataBuilder, String string, String string2) {
        string2 = string2.replaceAll(NEWLINE, SPACE_LINE);
        TableDataRow tableDataRow = tableDataBuilder.get(string);
        if (tableDataRow == null) {
            tableDataBuilder.addRow(new Object[]{string, string2});
        } else if (!tableDataRow.get(1).equals(string2)) {
            tableDataBuilder.addRow(new Object[]{string, string2});
        }
    }

    private void updateTableDataWithList(TableDataBuilder tableDataBuilder, String string, List<String> list) {
        TableDataRow tableDataRow = tableDataBuilder.get(string);
        if (tableDataRow == null) {
            tableDataBuilder.addRow(new Object[]{string, list});
        } else {
            Object object = tableDataRow.get(1);
            if (object instanceof List) {
                List list2 = (List)object;
                if (list2.size() != list.size()) {
                    tableDataBuilder.addRow(new Object[]{string, list});
                } else {
                    for (Object e : list2) {
                        if (!(e instanceof String) || list.contains(e)) continue;
                        tableDataBuilder.addRow(new Object[]{string, list});
                        break;
                    }
                }
            }
        }
    }
}

