/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TraceCommandParser {
    private static final String XTRACE = "-Xtrace:";
    private static final Pattern PATTERN = Pattern.compile(".*-Xtrace:[^ ]*output=([^,]*)");
    private static final Pattern PID_PATTERN = Pattern.compile("(.*)%p(.*)");

    public static File getTraceOutputFile(String[] stringArray, int n) {
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().startsWith(XTRACE)) continue;
            file = TraceCommandParser.getTraceOutputFile(stringArray[i], n);
        }
        return file;
    }

    public static File getTraceOutputFile(String string, int n) {
        File file;
        block5: {
            file = null;
            Matcher matcher = PATTERN.matcher(string);
            if (!matcher.find()) break block5;
            String string2 = matcher.group(1);
            Matcher matcher2 = PID_PATTERN.matcher(string2);
            if (matcher2.matches()) {
                String[] stringArray;
                for (String string3 : stringArray = new String[]{Integer.toHexString(n), Integer.toString(n)}) {
                    String string4 = matcher2.group(1) + string3 + matcher2.group(2);
                    if (!TraceCommandParser.checkFileExists(string4)) continue;
                    file = new File(string4);
                }
            } else {
                file = new File(string2);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    String string5 = Messages.getString("TraceCommandParser.could.not.open.trace.file");
                    String string6 = MessageFormat.format(string5, string2);
                    System.err.println(string6);
                    iOException.printStackTrace(System.err);
                }
            }
        }
        return file;
    }

    private static boolean checkFileExists(String string) {
        File file = new File(string);
        return file.exists() && !file.isDirectory() && file.canRead();
    }
}

