/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class AgentLogFactory {
    private static boolean loggingInit = false;
    private static int pid = 0;

    public static Logger setUpLogging(Class<?> clazz) {
        if (clazz == null) {
            Logger logger = Logger.global;
            logger.warning(Messages.getString("AgentLogFactory.could.not.initialize.logging"));
            return logger;
        }
        try {
            Logger logger;
            LogManager logManager = LogManager.getLogManager();
            if (!loggingInit) {
                loggingInit = true;
                logger = Logger.getLogger("com.ibm.java.diagnostics.healthcenter.agent");
                logManager.addLogger(logger);
            }
            logger = Logger.getLogger(clazz.getName());
            logManager.addLogger(logger);
            String string = System.getProperty("com.ibm.java.diagnostics.healthcenter.agent.debug");
            if (string != null) {
                logger.setLevel(Level.FINEST);
            } else {
                logger.setLevel(Level.INFO);
            }
            return logger;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Logger logger = Logger.global;
            logger.warning(Messages.getString("AgentLogFactory.could.not.initialize.logging") + throwable.toString());
            return logger;
        }
    }

    public static void setPid(int n) {
        pid = n;
    }
}

