/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.properties;

import com.ibm.java.diagnostics.common.datamodel.data.ControlledData;
import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.properties.Messages;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.text.MessageFormat;
import java.util.logging.Logger;

public abstract class MissingDataPostProcessor
implements PostProcessor {
    protected static final String TRACE_NOT_SET = Messages.getString("MissingData.trace.not.set");
    protected static final String UPDATE_AGENT = Messages.getString("MissingData.agent.version.update.required");
    protected static final String NOT_CONNECTED = Messages.getString("MissingData.not.connected");
    protected static final String OLD_VM = Messages.getString("MissingData.old.vm.level");
    private static final Logger TRACE = LogFactory.getTrace(MissingDataPostProcessor.class);
    private final String className = this.getClass().getName();

    protected abstract String getDataLabel();

    protected abstract String getRecommendationLabel();

    protected String getSubsystemCapabilityId() {
        return null;
    }

    private ControlledData getConfigurationData(DataBuilder dataBuilder, String string) {
        DataBuilder dataBuilder2;
        DataBuilder dataBuilder3;
        if (string != null && (dataBuilder3 = dataBuilder.getTopLevelData(SubsystemDataBuilder.CONFIGURATION)) != null && (dataBuilder2 = dataBuilder3.getData(string)) instanceof ControlledData) {
            return (ControlledData)((Object)dataBuilder2);
        }
        return null;
    }

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        Object object;
        String string;
        TRACE.entering(this.className, "postprocess");
        String string2 = this.getDataLabel();
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(string2);
        boolean bl = dataBuilder2 != null;
        String string3 = this.getSubsystemCapabilityId();
        ControlledData controlledData = this.getConfigurationData(dataBuilder, string3);
        if (controlledData != null) {
            if (controlledData.isEnabled()) {
                if (!bl) {
                    string = this.getEnabledNoDataAdvice(dataBuilder, string2);
                    object = this.createSubsystemStubData(string);
                    dataBuilder.addData((DataBuilder)object);
                }
            } else if (!bl) {
                string = MessageFormat.format(Messages.getString("MissingDataPostProcessor.disabledNoData"), string2);
                object = this.createSubsystemStubData(string);
                dataBuilder.addData((DataBuilder)object);
            } else {
                DataBuilder dataBuilder3;
                string = MessageFormat.format(Messages.getString("MissingDataPostProcessor.disabledWithData"), string2);
                if (dataBuilder2.getStatus() != Status.PROBLEM) {
                    object = (SubsystemDataBuilder)dataBuilder2;
                    object.setStatus(Status.WARNING);
                    object.clearValue();
                    object.addValue(string);
                }
                if ((object = this.getRecommendationLabel()) != null && (dataBuilder3 = dataBuilder2.getData((String)object)) instanceof StructuredStringDataBuilder) {
                    StructuredStringDataBuilder structuredStringDataBuilder = (StructuredStringDataBuilder)dataBuilder3;
                    structuredStringDataBuilder.addWarning(string);
                }
            }
        }
        if (!bl) {
            string = this.getAdvice(dataBuilder);
            object = this.createSubsystemStubData(string);
            dataBuilder.addData((DataBuilder)object);
        }
        TRACE.exiting(this.className, "postprocess");
    }

    private SubsystemDataBuilder createSubsystemStubData(String string) {
        String string2 = this.getDataLabel();
        DataFactory dataFactory = DataFactory.getFactory();
        SubsystemDataBuilder subsystemDataBuilder = dataFactory.createSubsystemData(string2, null);
        subsystemDataBuilder.addValue(string);
        return subsystemDataBuilder;
    }

    protected abstract String getAdvice(Data var1);

    protected String getEnabledNoDataAdvice(DataBuilder dataBuilder, String string) {
        return MessageFormat.format(Messages.getString("MissingDataPostProcessor.enabledNoData"), string);
    }
}

