/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataRowImpl;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class TableDataImpl
extends DataImpl
implements TableDataBuilder {
    private static final Logger TRACE = LogFactory.getTrace(TableDataImpl.class);
    protected Map<String, TableDataRow> keyedData = new ConcurrentHashMap<String, TableDataRow>();
    protected String[] columnTitles;

    public TableDataImpl(String string) {
        this(string, (String[])null);
    }

    public TableDataImpl(String string, String[] stringArray) {
        super(string);
        if (stringArray != null) {
            this.columnTitles = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.columnTitles, 0, stringArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableDataRow[] getContents() {
        TableDataRow[] tableDataRowArray = new TableDataRow[]{};
        Map<String, TableDataRow> map = this.keyedData;
        synchronized (map) {
            tableDataRowArray = this.keyedData.values().toArray(tableDataRowArray);
        }
        return tableDataRowArray;
    }

    @Override
    public boolean isEmpty() {
        return this.keyedData.size() == 0;
    }

    @Override
    public void addRow(Object[] objectArray) {
        if (objectArray.length > 0) {
            TableDataRowImpl tableDataRowImpl = new TableDataRowImpl(objectArray);
            this.addRow(objectArray[0].toString(), tableDataRowImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRow(String string, TableDataRow tableDataRow) {
        Map<String, TableDataRow> map = this.keyedData;
        synchronized (map) {
            this.keyedData.put(string, tableDataRow);
        }
        this.notifyListeners();
    }

    @Override
    public String[] getColumnTitles() {
        if (this.columnTitles != null) {
            String[] stringArray = new String[this.columnTitles.length];
            System.arraycopy(this.columnTitles, 0, stringArray, 0, this.columnTitles.length);
            return stringArray;
        }
        return null;
    }

    @Override
    public boolean contains(String string) {
        return this.keyedData.containsKey(string);
    }

    @Override
    public TableDataRow get(String string) {
        return this.keyedData.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRow(String string) {
        TableDataRow tableDataRow;
        Map<String, TableDataRow> map = this.keyedData;
        synchronized (map) {
            tableDataRow = this.keyedData.remove(string);
        }
        if (tableDataRow != null) {
            this.notifyListeners();
        }
    }

    @Override
    public int size() {
        return this.keyedData.size();
    }
}

