/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.Recommendations;
import com.ibm.java.diagnostics.common.datamodel.data.Status;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StringDataImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class StructuredStringDataImpl
extends StringDataImpl
implements StructuredStringDataBuilder,
Recommendations {
    private static final String[] STRING_TEMPLATE_ARRAY = new String[0];
    private static final String NEWLINE = System.getProperty("line.separator");

    public StructuredStringDataImpl(String string) {
        super(string);
    }

    public StructuredStringDataImpl(String string, String string2) {
        this(string);
        this.addInformation(string2);
    }

    @Override
    public void addInformation(String string) {
        this.addStringDataAsChild(string, Status.INFORMATION);
    }

    @Override
    public void addGoodThing(String string) {
        this.addStringDataAsChild(string, Status.HEALTHY);
    }

    @Override
    public void addProblem(String string) {
        this.addStringDataAsChild(string, Status.PROBLEM);
    }

    @Override
    public void addWarning(String string) {
        this.addStringDataAsChild(string, Status.WARNING);
    }

    @Override
    public String[] getInformations() {
        Status status = Status.INFORMATION;
        return this.getDataWithGivenStatus(status);
    }

    @Override
    public String[] getGoodThings() {
        Status status = Status.HEALTHY;
        return this.getDataWithGivenStatus(status);
    }

    @Override
    public String[] getProblems() {
        Status status = Status.PROBLEM;
        return this.getDataWithGivenStatus(status);
    }

    @Override
    public String[] getWarnings() {
        Status status = Status.WARNING;
        return this.getDataWithGivenStatus(status);
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.appendContents(stringBuffer, this.getProblems());
            this.appendContents(stringBuffer, this.getWarnings());
            this.appendContents(stringBuffer, this.getInformations());
            this.appendContents(stringBuffer, this.getGoodThings());
            this.value = stringBuffer.toString().trim();
        }
        return this.value;
    }

    private void addStringDataAsChild(String string, Status status) {
        this.value = null;
        if (string != null && string.length() > 0) {
            StringDataBuilder stringDataBuilder = DataFactory.getFactory().createStringData(string);
            stringDataBuilder.addValue(string);
            stringDataBuilder.setStatus(status);
            this.addData(stringDataBuilder);
        }
    }

    private void appendContents(StringBuffer stringBuffer, String[] stringArray) {
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(NEWLINE);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getProblems().length > 0 || this.getWarnings().length > 0 || this.getGoodThings().length > 0 || this.getInformations().length > 0;
    }

    private String[] getDataWithGivenStatus(Status status) {
        DataBuilder[] dataBuilderArray = this.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataBuilder dataBuilder : dataBuilderArray) {
            if (dataBuilder.getStatus() != status || !(dataBuilder instanceof StringData)) continue;
            StringData stringData = (StringData)((Object)dataBuilder);
            String string = stringData.getValue();
            arrayList.add(string);
        }
        return arrayList.toArray(STRING_TEMPLATE_ARRAY);
    }

    @Override
    public Set<StringData> getAllRecommendations() {
        DataBuilder[] dataBuilderArray = this.getChildren();
        HashSet<StringData> hashSet = new HashSet<StringData>();
        for (DataBuilder dataBuilder : dataBuilderArray) {
            if (!(dataBuilder instanceof StringData)) continue;
            StringData stringData = (StringData)((Object)dataBuilder);
            hashSet.add(stringData);
        }
        return hashSet;
    }

    @Override
    public String[] getRecommendations(Status status) {
        return this.getDataWithGivenStatus(status);
    }

    @Override
    public Status getStatus() {
        Status status = this.getProblems().length > 0 ? Status.PROBLEM : (this.getWarnings().length > 0 ? Status.WARNING : (this.getGoodThings().length > 0 ? Status.HEALTHY : (this.getInformations().length > 0 ? Status.INFORMATION : Status.BLANK)));
        return status;
    }
}

