/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.converters;

import com.ibm.java.diagnostics.common.datamodel.data.axes.LinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AbstractUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;

public class ClockTimeUnitConverter
extends AbstractUnitConverter
implements LinearUnitConverter {
    private OutputProperties out = null;
    private long mostRecentDate = 0L;
    private final DateFormat hhmmssFormat = new SimpleDateFormat("HH:mm:ss");
    private final DateFormat yyyyMMddformat = new SimpleDateFormat("yyyy.MM.dd");
    private final DateFormat completeformat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(UnitLabels.MILLISECONDS_SINCE_EPOCH, UnitLabels.CLOCK_TIME, UnitLabels.TIME);
    private static final Logger TRACE = LogFactory.getTrace(ClockTimeUnitConverter.class);

    public ClockTimeUnitConverter(OutputProperties outputProperties) {
        this.out = outputProperties;
    }

    public ClockTimeUnitConverter() {
    }

    @Override
    public double convert(double d, int n) {
        return this.convert(d);
    }

    @Override
    public double convert(double d) {
        this.refreshMostRecentDate(d);
        return d;
    }

    @Override
    public double reverseConvert(double d) {
        return d;
    }

    @Override
    public String unconvertedFormat(double d) {
        TimeZone timeZone;
        this.refreshMostRecentDate(d);
        long l = Math.round(d);
        if (this.out != null && (timeZone = this.out.getTimeZone()) != null) {
            this.hhmmssFormat.setTimeZone(timeZone);
        }
        return this.hhmmssFormat.format(new Date(l));
    }

    private void refreshMostRecentDate(double d) {
        Date date = new Date((long)d);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        this.mostRecentDate = date.getTime();
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return this.unconvertedFormat(d);
    }

    @Override
    public double parseUnconverted(String string) {
        try {
            Date date = new Date(this.mostRecentDate);
            String string2 = this.yyyyMMddformat.format(date) + " " + string;
            Date date2 = this.completeformat.parse(string2);
            return date2.getTime();
        }
        catch (ParseException parseException) {
            TRACE.warning(parseException.toString());
            return this.mostRecentDate;
        }
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }

    @Override
    public void setOffset(double d) {
    }

    @Override
    public boolean shouldFormatWithUnits() {
        return false;
    }
}

