/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.XDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.YDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.EventDataPoint;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullDataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import java.text.MessageFormat;

public class AxisPairImpl
implements AxisPair {
    private static final String EMPTY_STRING = "";
    private XDataAxisImpl xAxis;
    private YDataAxisImpl yAxis;

    public AxisPairImpl(XDataAxis xDataAxis, YDataAxis yDataAxis) {
        this.xAxis = (XDataAxisImpl)xDataAxis;
        this.yAxis = (YDataAxisImpl)yDataAxis;
    }

    @Override
    public DataPointBuilder createDataPointBuilder(double d) {
        return this.createDataPointBuilder(d, null);
    }

    @Override
    public DataPointBuilder createDataPointBuilder(double d, String string) {
        if (string == null || string.equals(EMPTY_STRING)) {
            return new DataPointImpl(this.xAxis.getSequenceUID(), this.xAxis.getX(), d, this);
        }
        return new FullDataPointImpl(this.xAxis.getSequenceUID(), this.xAxis.getX(), d, string, this);
    }

    @Override
    public DataPointBuilder createDataPointBuilder(int n, double d, double d2) {
        return this.createDataPointBuilder(n, d, d2, null);
    }

    @Override
    public DataPointBuilder createDataPointBuilder(int n, double d, double d2, String string) {
        if (string == null || string.equals(EMPTY_STRING)) {
            return new DataPointImpl(n, d, d2, this);
        }
        return new FullDataPointImpl(n, d, d2, string, this);
    }

    @Override
    public DataPointBuilder createEventDataPoint() {
        return new EventDataPoint(this.xAxis.getSequenceUID(), this.xAxis.getX(), this);
    }

    public void addListener(TwoDimensionalDataImpl twoDimensionalDataImpl) {
        this.xAxis.addListener(twoDimensionalDataImpl);
        this.yAxis.addListener(twoDimensionalDataImpl);
    }

    @Override
    public XDataAxis getXAxis() {
        return this.xAxis;
    }

    @Override
    public YDataAxis getYAxis() {
        return this.yAxis;
    }

    public String toString() {
        return MessageFormat.format("({0}, {1})", this.xAxis.getUnits(), this.yAxis.getUnits());
    }
}

