/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.ibm.security.ec.ECParameters;
import com.ibm.security.ec.NamedCurve;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.cert.CertPathValidatorException;
import java.security.interfaces.ECKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.ConstraintsParameters;
import sun.security.util.Debug;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Debug debug = Debug.getInstance("certpath");
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_SECURITY_LEGACY_ALGS = "jdk.security.legacyAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    private static final String PROPERTY_DISABLED_EC_CURVES = "jdk.disabled.namedCurves";
    private final List<String> disabledAlgorithms;
    private final Constraints algorithmConstraints;
    private volatile SoftReference<Map<String, Boolean>> cacheRef = new SoftReference<Object>(null);

    public static DisabledAlgorithmConstraints certPathConstraints() {
        return CertPathHolder.CONSTRAINTS;
    }

    public static DisabledAlgorithmConstraints jarConstraints() {
        return JarHolder.CONSTRAINTS;
    }

    public DisabledAlgorithmConstraints(String string) {
        this(string, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String string, AlgorithmDecomposer algorithmDecomposer) {
        super(algorithmDecomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(string);
        int n = -1;
        int n2 = 0;
        for (String string2 : this.disabledAlgorithms) {
            if (string2.regionMatches(true, 0, "include ", 0, 8) && string2.regionMatches(true, 8, PROPERTY_DISABLED_EC_CURVES, 0, PROPERTY_DISABLED_EC_CURVES.length())) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n > -1) {
            this.disabledAlgorithms.remove(n);
            this.disabledAlgorithms.addAll(n, DisabledAlgorithmConstraints.getAlgorithms(PROPERTY_DISABLED_EC_CURVES));
        }
        this.algorithmConstraints = new Constraints(string, this.disabledAlgorithms);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        if (!this.cachedCheckAlgorithm(string)) {
            return false;
        }
        if (algorithmParameters != null) {
            return this.algorithmConstraints.permits(string, algorithmParameters);
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    public final void permits(String string, AlgorithmParameters algorithmParameters, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        this.permits(string, constraintsParameters);
        if (algorithmParameters != null) {
            this.permits(algorithmParameters, constraintsParameters);
        }
    }

    private void permits(AlgorithmParameters algorithmParameters, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        switch (algorithmParameters.getAlgorithm().toUpperCase(Locale.ENGLISH)) {
            case "RSASSA-PSS": {
                this.permitsPSSParams(algorithmParameters, constraintsParameters);
                break;
            }
        }
    }

    private void permitsPSSParams(AlgorithmParameters algorithmParameters, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        try {
            String string;
            PSSParameterSpec pSSParameterSpec = algorithmParameters.getParameterSpec(PSSParameterSpec.class);
            String string2 = pSSParameterSpec.getDigestAlgorithm();
            this.permits(string2, constraintsParameters);
            AlgorithmParameterSpec algorithmParameterSpec = pSSParameterSpec.getMGFParameters();
            if (algorithmParameterSpec instanceof MGF1ParameterSpec && !(string = ((MGF1ParameterSpec)algorithmParameterSpec).getDigestAlgorithm()).equalsIgnoreCase(string2)) {
                this.permits(string, constraintsParameters);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            // empty catch block
        }
    }

    public final void permits(String string, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        for (Key key : constraintsParameters.getKeys()) {
            for (String string2 : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
                if (this.cachedCheckAlgorithm(string2)) continue;
                throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + string2, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        this.algorithmConstraints.permits(string, constraintsParameters);
    }

    public final void permits(String string, com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
        for (Key key : constraintsParameters.getKeys()) {
            for (String string2 : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
                if (this.cachedCheckAlgorithm(string2)) continue;
                throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + string2, null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
        this.algorithmConstraints.permits(string, constraintsParameters);
    }

    private static List<String> getNamedCurveFromKey(Key key) {
        if (key instanceof ECKey) {
            ECParameterSpec eCParameterSpec = ((ECKey)((Object)key)).getParams();
            return eCParameterSpec == null ? Collections.emptyList() : Arrays.asList(ECParameters.getCurveName((ECParameterSpec)eCParameterSpec));
        }
        return Collections.emptyList();
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        for (String string2 : DisabledAlgorithmConstraints.getNamedCurveFromKey(key)) {
            if (this.permits(set, string2, null)) continue;
            return false;
        }
        return this.algorithmConstraints.permits(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cachedCheckAlgorithm(String string) {
        Object object;
        Map<String, Boolean> map = this.cacheRef.get();
        if (map == null) {
            object = this;
            synchronized (object) {
                map = this.cacheRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, Boolean>();
                    this.cacheRef = new SoftReference<Map<String, Boolean>>(map);
                }
            }
        }
        if ((object = map.get(string)) != null) {
            return (Boolean)object;
        }
        object = DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, string, this.decomposer);
        map.put(string, (Boolean)object);
        return (Boolean)object;
    }

    private static class DisabledConstraint
    extends Constraint {
        DisabledConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }

        @Override
        public void permits(com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            throw new CertPathValidatorException("Algorithm constraints check failed on disabled algorithm: " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    private static class KeySizeConstraint
    extends Constraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(String string, Constraint.Operator operator, int n) {
            this.algorithm = string;
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n;
                    break;
                }
                case NE: {
                    this.minSize = n;
                    this.maxSize = n;
                    break;
                }
                case LT: {
                    this.minSize = n;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = n + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = n;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = n > 1 ? n - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            for (Key key : constraintsParameters.getKeys()) {
                if (this.permitsImpl(key)) continue;
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(constraintsParameters);
                    continue;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits: " + this.algorithm + " " + KeyUtil.getKeySize(key) + " bit key" + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public void permits(com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            for (Key key : constraintsParameters.getKeys()) {
                if (this.permitsImpl(key)) continue;
                if (this.nextConstraint != null) {
                    this.nextConstraint.permits(constraintsParameters);
                    continue;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on keysize limits: " + this.algorithm + " " + KeyUtil.getKeySize(key) + " bit key" + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.nextConstraint != null && this.nextConstraint.permits(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("KeySizeConstraints.permits(): " + this.algorithm);
            }
            return this.permitsImpl(key);
        }

        @Override
        public boolean permits(AlgorithmParameters algorithmParameters) {
            Collection<String> collection;
            String string = algorithmParameters.getAlgorithm();
            if (!this.algorithm.equalsIgnoreCase(algorithmParameters.getAlgorithm()) && !(collection = AlgorithmDecomposer.getAliases(this.algorithm)).contains(string)) {
                return true;
            }
            int n = KeyUtil.getKeySize(algorithmParameters);
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                return n >= this.minSize && n <= this.maxSize && this.prohibitedSize != n;
            }
            return true;
        }

        private boolean permitsImpl(Key key) {
            if (this.algorithm.compareToIgnoreCase(key.getAlgorithm()) != 0) {
                return true;
            }
            int n = KeyUtil.getKeySize(key);
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                return n >= this.minSize && n <= this.maxSize && this.prohibitedSize != n;
            }
            return true;
        }
    }

    private static class UsageConstraint
    extends Constraint {
        String[] usages;

        UsageConstraint(String string, String[] stringArray) {
            this.algorithm = string;
            this.usages = stringArray;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            String string = constraintsParameters.getVariant();
            for (String string2 : this.usages) {
                boolean bl = false;
                switch (string2.toLowerCase()) {
                    case "tlsserver": {
                        bl = string.equals("tls server");
                        break;
                    }
                    case "tlsclient": {
                        bl = string.equals("tls client");
                        break;
                    }
                    case "signedjar": {
                        boolean bl2 = bl = string.equals("plugin code signing") || string.equals("code signing") || string.equals("tsa server");
                    }
                }
                if (debug != null) {
                    debug.println("Checking if usage constraint \"" + string2 + "\" matches \"" + constraintsParameters.getVariant() + "\"");
                    Object object = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream((OutputStream)object);
                    new Exception().printStackTrace(printStream);
                    debug.println(((ByteArrayOutputStream)object).toString());
                }
                if (!bl) continue;
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Usage constraint " + string2 + " check failed: " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public void permits(com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            String string = constraintsParameters.getVariant();
            for (String string2 : this.usages) {
                boolean bl = false;
                switch (string2.toLowerCase()) {
                    case "tlsserver": {
                        bl = string.equals("tls server");
                        break;
                    }
                    case "tlsclient": {
                        bl = string.equals("tls client");
                        break;
                    }
                    case "signedjar": {
                        boolean bl2 = bl = string.equals("plugin code signing") || string.equals("code signing") || string.equals("tsa server");
                    }
                }
                if (debug != null) {
                    debug.println("Checking if usage constraint \"" + string2 + "\" matches \"" + constraintsParameters.getVariant() + "\"");
                    Object object = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream((OutputStream)object);
                    new Exception().printStackTrace(printStream);
                    debug.println(((ByteArrayOutputStream)object).toString());
                }
                if (!bl) continue;
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Usage constraint " + string2 + " check failed: " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static class DenyAfterConstraint
    extends Constraint {
        private Date denyAfterDate;

        DenyAfterConstraint(String string, int n, int n2, int n3) {
            Calendar calendar;
            this.algorithm = string;
            if (debug != null) {
                debug.println("DenyAfterConstraint read in as:  year " + n + ", month = " + n2 + ", day = " + n3);
            }
            if (n > (calendar = new Calendar.Builder().setTimeZone(TimeZone.getTimeZone("GMT")).setDate(n, n2 - 1, n3).build()).getActualMaximum(1) || n < calendar.getActualMinimum(1)) {
                throw new IllegalArgumentException("Invalid year given in constraint: " + n);
            }
            if (n2 - 1 > calendar.getActualMaximum(2) || n2 - 1 < calendar.getActualMinimum(2)) {
                throw new IllegalArgumentException("Invalid month given in constraint: " + n2);
            }
            if (n3 > calendar.getActualMaximum(5) || n3 < calendar.getActualMinimum(5)) {
                throw new IllegalArgumentException("Invalid Day of Month given in constraint: " + n3);
            }
            this.denyAfterDate = calendar.getTime();
            if (debug != null) {
                debug.println("DenyAfterConstraint date set to: " + this.denyAfterDate);
            }
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            Date date = constraintsParameters.getDate() != null ? constraintsParameters.getDate() : new Date();
            if (!this.denyAfterDate.after(date)) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("denyAfter constraint check failed: " + this.algorithm + " used with Constraint date: " + this.denyAfterDate + "; params date: " + date + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public void permits(com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            Date date = constraintsParameters.getDate() != null ? constraintsParameters.getDate() : new Date();
            if (!this.denyAfterDate.after(date)) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("denyAfter constraint check failed: " + this.algorithm + " used with Constraint date: " + this.denyAfterDate + "; params date: " + date + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public boolean permits(Key key) {
            if (this.next(key)) {
                return true;
            }
            if (debug != null) {
                debug.println("DenyAfterConstraints.permits(): " + this.algorithm);
            }
            return this.denyAfterDate.after(new Date());
        }
    }

    private static class jdkCAConstraint
    extends Constraint {
        jdkCAConstraint(String string) {
            this.algorithm = string;
        }

        @Override
        public void permits(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (constraintsParameters.anchorIsJdkCA()) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits. " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }

        @Override
        public void permits(com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("jdkCAConstraints.permits(): " + this.algorithm);
            }
            if (constraintsParameters.anchorIsJdkCA()) {
                if (this.next(constraintsParameters)) {
                    return;
                }
                throw new CertPathValidatorException("Algorithm constraints check failed on certificate anchor limits. " + this.algorithm + constraintsParameters.extendedExceptionMsg(), null, null, -1, CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED);
            }
        }
    }

    private static abstract class Constraint {
        String algorithm;
        Constraint nextConstraint = null;

        private Constraint() {
        }

        public boolean permits(Key key) {
            return true;
        }

        public boolean permits(AlgorithmParameters algorithmParameters) {
            return true;
        }

        public abstract void permits(ConstraintsParameters var1) throws CertPathValidatorException;

        boolean next(ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (this.nextConstraint != null) {
                this.nextConstraint.permits(constraintsParameters);
                return true;
            }
            return false;
        }

        public abstract void permits(com.ibm.security.util.ConstraintsParameters var1) throws CertPathValidatorException;

        boolean next(com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (this.nextConstraint != null) {
                this.nextConstraint.permits(constraintsParameters);
                return true;
            }
            return false;
        }

        boolean next(Key key) {
            return this.nextConstraint != null && this.nextConstraint.permits(key);
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException("Error in security property. " + string + " is not a legal Operator");
            }
        }
    }

    private static class Constraints {
        private Map<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();

        /*
         * WARNING - void declaration
         */
        public Constraints(String string, List<String> list) {
            for (String string2 : list) {
                int n;
                if (string2 == null || string2.isEmpty()) continue;
                string2 = string2.trim();
                if (debug != null) {
                    debug.println("Constraints: " + string2);
                }
                String string3 = AlgorithmDecomposer.hashName((n = string2.indexOf(32)) > 0 ? string2.substring(0, n) : string2);
                List list2 = this.constraintsMap.getOrDefault(string3.toUpperCase(Locale.ENGLISH), new ArrayList(1));
                for (String string4 : AlgorithmDecomposer.getAliases(string3)) {
                    this.constraintsMap.putIfAbsent(string4.toUpperCase(Locale.ENGLISH), list2);
                }
                if (n <= 0 || NamedCurve.getECParameterSpec((String)string2) != null) {
                    list2.add(new DisabledConstraint(string3));
                    continue;
                }
                String string4 = string2.substring(n + 1);
                Object var10_16 = null;
                boolean bl = false;
                boolean bl2 = false;
                for (String string5 : string4.split("&")) {
                    void var9_15;
                    Matcher matcher;
                    String[] stringArray;
                    if ((string5 = string5.trim()).startsWith("keySize")) {
                        if (debug != null) {
                            debug.println("Constraints set to keySize: " + string5);
                        }
                        if (!"keySize".equals((stringArray = new StringTokenizer(string5)).nextToken())) {
                            throw new IllegalArgumentException("Error in security property. Constraint unknown: " + string5);
                        }
                        KeySizeConstraint keySizeConstraint = new KeySizeConstraint(string3, Constraint.Operator.of(stringArray.nextToken()), Integer.parseInt(stringArray.nextToken()));
                    } else if (string5.equalsIgnoreCase("jdkCA")) {
                        if (debug != null) {
                            debug.println("Constraints set to jdkCA.");
                        }
                        if (bl) {
                            throw new IllegalArgumentException("Only one jdkCA entry allowed in property. Constraint: " + string2);
                        }
                        jdkCAConstraint jdkCAConstraint2 = new jdkCAConstraint(string3);
                        bl = true;
                    } else if (string5.startsWith("denyAfter") && (matcher = Holder.DENY_AFTER_PATTERN.matcher(string5)).matches()) {
                        if (debug != null) {
                            debug.println("Constraints set to denyAfter");
                        }
                        if (bl2) {
                            throw new IllegalArgumentException("Only one denyAfter entry allowed in property. Constraint: " + string2);
                        }
                        int n2 = Integer.parseInt(matcher.group(1));
                        int n3 = Integer.parseInt(matcher.group(2));
                        int n4 = Integer.parseInt(matcher.group(3));
                        DenyAfterConstraint denyAfterConstraint = new DenyAfterConstraint(string3, n2, n3, n4);
                        bl2 = true;
                    } else if (string5.startsWith("usage")) {
                        stringArray = string5.substring(5).trim().split(" ");
                        UsageConstraint usageConstraint = new UsageConstraint(string3, stringArray);
                        if (debug != null) {
                            debug.println("Constraints usage length is " + stringArray.length);
                        }
                    } else {
                        throw new IllegalArgumentException("Error in security property. Constraint unknown: " + string5);
                    }
                    if (var10_16 == null) {
                        list2.add(var9_15);
                    } else {
                        var10_16.nextConstraint = var9_15;
                    }
                    var10_16 = var9_15;
                }
            }
        }

        private List<Constraint> getConstraints(String string) {
            return this.constraintsMap.get(string.toUpperCase(Locale.ENGLISH));
        }

        public boolean permits(Key key) {
            List<Constraint> list = this.getConstraints(key.getAlgorithm());
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(key)) continue;
                if (debug != null) {
                    debug.println("Constraints: failed key sizeconstraint check " + KeyUtil.getKeySize(key));
                }
                return false;
            }
            return true;
        }

        public boolean permits(String string, AlgorithmParameters algorithmParameters) {
            List<Constraint> list = this.getConstraints(string);
            if (list == null) {
                return true;
            }
            for (Constraint constraint : list) {
                if (constraint.permits(algorithmParameters)) continue;
                if (debug != null) {
                    debug.println("Constraints: failed algorithm parameters constraint check " + algorithmParameters);
                }
                return false;
            }
            return true;
        }

        public void permits(String string, ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("Constraints.permits(): " + string + ", " + constraintsParameters.toString());
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (string != null) {
                hashSet.addAll(AlgorithmDecomposer.decomposeOneHash(string));
                hashSet.add(string);
            }
            for (Key object : constraintsParameters.getKeys()) {
                hashSet.add(object.getAlgorithm());
            }
            for (String string2 : hashSet) {
                List<Constraint> list = this.getConstraints(string2);
                if (list == null) continue;
                for (Constraint constraint : list) {
                    constraint.permits(constraintsParameters);
                }
            }
        }

        public void permits(String string, com.ibm.security.util.ConstraintsParameters constraintsParameters) throws CertPathValidatorException {
            if (debug != null) {
                debug.println("Constraints.permits(): " + string + ", " + constraintsParameters.toString());
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (string != null) {
                hashSet.addAll(AlgorithmDecomposer.decomposeOneHash(string));
                hashSet.add(string);
            }
            for (Key object : constraintsParameters.getKeys()) {
                hashSet.add(object.getAlgorithm());
            }
            for (String string2 : hashSet) {
                List<Constraint> list = this.getConstraints(string2);
                if (list == null) continue;
                for (Constraint constraint : list) {
                    constraint.permits(constraintsParameters);
                }
            }
        }

        private static class Holder {
            private static final Pattern DENY_AFTER_PATTERN = Pattern.compile("denyAfter\\s+(\\d{4})-(\\d{2})-(\\d{2})");

            private Holder() {
            }
        }
    }

    private static class JarHolder {
        static final DisabledAlgorithmConstraints CONSTRAINTS = new DisabledAlgorithmConstraints("jdk.jar.disabledAlgorithms");

        private JarHolder() {
        }
    }

    private static class CertPathHolder {
        static final DisabledAlgorithmConstraints CONSTRAINTS = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms");

        private CertPathHolder() {
        }
    }
}

