/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;
import sun.security.action.GetPropertyAction;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    @Override
    public String historicalName() {
        return "UTF8";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    private static final class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private String bidiParms;
        private boolean bidiEnabled = false;
        private static String bidiInit;
        private static boolean UseBuffer;
        private String csName;
        private Surrogate.Parser sgp;
        private byte repl = (byte)63;

        private Encoder(Charset charset) {
            super(charset, 1.1f, 3.0f);
            this.csName = charset.name();
            this.bidiParms = bidiInit;
            if (null == this.bidiParms) {
                if (VM.isBooted()) {
                    this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                    if (null == this.bidiParms) {
                        this.bidiParms = "NO";
                    }
                    bidiInit = this.bidiParms;
                } else {
                    this.bidiParms = "NO";
                }
            }
            this.bidiEnabled = !"NO".equals(this.bidiParms);
        }

        @Override
        public boolean canEncode(char c) {
            return !Character.isSurrogate(c);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n, ByteBuffer byteBuffer, int n2) {
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n2);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n) {
            charBuffer.position(n);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            int n5 = Math.min(n2 - n, n4 - n3);
            int n6 = Encoder.encodeUTF_8(cArray, n, n5, byArray, n3);
            n += n6;
            n3 += n6;
            while (n < n2) {
                char c = cArray[n];
                if (c < '\u0080') {
                    if (n3 >= n4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)c;
                } else if (c < '\u0800') {
                    if (n4 - n3 < 2) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xC0 | c >> 6);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                } else if (Character.isSurrogate(c)) {
                    int n7;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n7 = this.sgp.parse(c, cArray, n, n2)) < 0) {
                        UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
                        return this.sgp.error();
                    }
                    if (n4 - n3 < 4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xF0 | n7 >> 18);
                    byArray[n3++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n7 & 0x3F);
                    ++n;
                } else {
                    if (n4 - n3 < 3) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xE0 | c >> 12);
                    byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                }
                ++n;
            }
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)c);
                } else if (c < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xC0 | c >> 6));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate(c)) {
                    int n2;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n2 = this.sgp.parse(c, charBuffer)) < 0) {
                        charBuffer.position(n);
                        return this.sgp.error();
                    }
                    if (byteBuffer.remaining() < 4) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xF0 | n2 >> 18));
                    byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 & 0x3F));
                    ++n;
                } else {
                    if (byteBuffer.remaining() < 3) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xE0 | c >> 12));
                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                }
                ++n;
            }
            charBuffer.position(n);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            BidiConvert bidiConvert;
            if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.csName)) {
                int n;
                int n2;
                int n3;
                int n4;
                if (charBuffer.hasArray() && !UseBuffer) {
                    char[] cArray = charBuffer.array();
                    n4 = charBuffer.arrayOffset() + charBuffer.position();
                    n3 = charBuffer.arrayOffset() + charBuffer.limit();
                    int n5 = 0;
                    int n6 = byteBuffer.remaining();
                    for (n2 = n4; n2 < n3; ++n2) {
                        char c = cArray[n2];
                        if (c < '\u0080') {
                            n = 1;
                        } else if (c < '\u0800') {
                            n = 2;
                        } else if (!Surrogate.is(c)) {
                            n = 3;
                        } else {
                            if (Surrogate.isHigh(c) ? n2 + 1 >= n3 || !Surrogate.isLow(cArray[n2 + 1]) : n2 == n4 || !Surrogate.isHigh(cArray[n2 - 1])) break;
                            n = 2;
                        }
                        if (n5 + n > n6) break;
                        n5 += n;
                    }
                    n = n2 - n4;
                } else {
                    int n7 = charBuffer.position();
                    n3 = 0;
                    n2 = byteBuffer.remaining();
                    while (charBuffer.hasRemaining()) {
                        n4 = charBuffer.get();
                        if (n4 < 128) {
                            n = 1;
                        } else if (n4 < 2048) {
                            n = 2;
                        } else if (!Surrogate.is(n4)) {
                            n = 3;
                        } else {
                            if (Surrogate.isHigh(n4) ? !charBuffer.hasRemaining() || !Surrogate.isLow(charBuffer.get(charBuffer.position())) : charBuffer.position() - 2 < n7 || !Surrogate.isHigh(charBuffer.get(charBuffer.position() - 2))) break;
                            n = 2;
                        }
                        if (n3 + n > n2) break;
                        n3 += n;
                    }
                    n = charBuffer.position() - n7;
                    charBuffer.position(n7);
                }
                int n8 = charBuffer.limit();
                charBuffer.limit(charBuffer.position() + n);
                CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.csName);
                charBuffer.limit(n8);
                n3 = charBuffer2.position();
                CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
                n3 = charBuffer.position() + charBuffer2.position() - n3;
                charBuffer.position(n3);
                if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                    coderResult = CoderResult.OVERFLOW;
                }
                return coderResult;
            }
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            BidiConvert bidiConvert;
            int n3 = n + n2;
            int n4 = 0;
            int n5 = Math.min(n2, byArray.length);
            if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n, n3, this.bidiParms, this.csName)) {
                cArray = bidiConvert.toSbcs(cArray, n, n3, this.bidiParms, this.csName);
                n3 = n2;
                n = 0;
            }
            int n6 = Encoder.encodeUTF_8(cArray, n, n5, byArray, n4);
            n += n6;
            n4 += n6;
            while (n < n3) {
                char c;
                if ((c = cArray[n++]) < '\u0080') {
                    byArray[n4++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    byArray[n4++] = (byte)(0xC0 | c >> 6);
                    byArray[n4++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    int n7;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n7 = this.sgp.parse(c, cArray, n - 1, n3)) < 0) {
                        if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                            return -1;
                        }
                        byArray[n4++] = this.repl;
                        continue;
                    }
                    byArray[n4++] = (byte)(0xF0 | n7 >> 18);
                    byArray[n4++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n7 & 0x3F);
                    ++n;
                    continue;
                }
                byArray[n4++] = (byte)(0xE0 | c >> 12);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            return n4;
        }

        private static int encodeUTF_8(char[] cArray, int n, int n2, byte[] byArray, int n3) {
            int n4 = 0;
            int n5 = n3 + n2;
            while (n3 < n5 && cArray[n] < '\u0080') {
                byArray[n3++] = (byte)cArray[n++];
                ++n4;
            }
            return n4;
        }

        static {
            UseBuffer = false;
        }
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private String bidiParms;
        private boolean bidiEnabled = false;
        private static String bidiInit;
        private String csName;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
            this.csName = charset.name();
            this.bidiParms = bidiInit;
            if (null == this.bidiParms) {
                if (VM.isBooted()) {
                    this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                    if (null == this.bidiParms) {
                        this.bidiParms = "NO";
                    }
                    bidiInit = this.bidiParms;
                } else {
                    this.bidiParms = "NO";
                }
            }
            this.bidiEnabled = !"NO".equals(this.bidiParms);
        }

        private static boolean isNotContinuation(int n) {
            return (n & 0xC0) != 128;
        }

        private static boolean isMalformed3(int n, int n2, int n3) {
            return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static boolean isMalformed3_2(int n, int n2) {
            return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed4(int n, int n2, int n3) {
            return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
        }

        private static boolean isMalformed4_2(int n, int n2) {
            return n == 240 && (n2 < 144 || n2 > 191) || n == 244 && (n2 & 0xF0) != 128 || (n2 & 0xC0) != 128;
        }

        private static boolean isMalformed4_3(int n) {
            return (n & 0xC0) != 128;
        }

        private static CoderResult lookupN(ByteBuffer byteBuffer, int n) {
            for (int i = 1; i < n; ++i) {
                if (!Decoder.isNotContinuation(byteBuffer.get())) continue;
                return CoderResult.malformedForLength(i);
            }
            return CoderResult.malformedForLength(n);
        }

        private static CoderResult malformedN(ByteBuffer byteBuffer, int n) {
            switch (n) {
                case 1: 
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || Decoder.isNotContinuation(by2) ? 1 : 2);
                }
                case 4: {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n2 > 244 || n2 == 240 && (n3 < 144 || n3 > 191) || n2 == 244 && (n3 & 0xF0) != 128 || Decoder.isNotContinuation(n3)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(byteBuffer.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n3);
            UTF_8.updatePositions(byteBuffer, n, charBuffer, n2);
            return coderResult;
        }

        private static CoderResult malformed(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.position(n);
            CoderResult coderResult = Decoder.malformedN(byteBuffer, n2);
            byteBuffer.position(n);
            return coderResult;
        }

        private static CoderResult malformedForLength(ByteBuffer byteBuffer, int n, CharBuffer charBuffer, int n2, int n3) {
            UTF_8.updatePositions(byteBuffer, n, charBuffer, n2);
            return CoderResult.malformedForLength(n3);
        }

        private static CoderResult malformedForLength(ByteBuffer byteBuffer, int n, int n2) {
            byteBuffer.position(n);
            return CoderResult.malformedForLength(n2);
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
            UTF_8.updatePositions(buffer, n, buffer2, n3);
            return n4 == 0 || n2 - n < n4 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer buffer, int n, int n2) {
            buffer.position(n);
            return n2 == 0 || buffer.remaining() < n2 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            int n5 = Math.min(n2 - n, n4 - n3);
            int n6 = this.decodeUTF_8(byArray, n, n5, cArray, n3);
            n += n6;
            n3 += n6;
            while (n < n2) {
                char c;
                byte by;
                byte by2;
                int n7;
                int n8 = byArray[n];
                if (n8 >= 0) {
                    if (n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 1);
                    }
                    cArray[n3++] = (char)n8;
                    ++n;
                    continue;
                }
                if (n8 >> 5 == -2 && (n8 & 0x1E) != 0) {
                    if (n2 - n < 2 || n3 >= n4) {
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 2);
                    }
                    n7 = byArray[n + 1];
                    if (Decoder.isNotContinuation(n7)) {
                        return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 1);
                    }
                    cArray[n3++] = (char)(n8 << 6 ^ n7 ^ 0xF80);
                    n += 2;
                    continue;
                }
                if (n8 >> 4 == -2) {
                    n7 = n2 - n;
                    if (n7 < 3 || n3 >= n4) {
                        if (n7 > 1 && Decoder.isMalformed3_2(n8, byArray[n + 1])) {
                            return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 1);
                        }
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 3);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    if (Decoder.isMalformed3(n8, by2, by)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 3);
                    }
                    c = (char)(n8 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 3);
                    }
                    cArray[n3++] = c;
                    n += 3;
                    continue;
                }
                if (n8 >> 3 == -2) {
                    n7 = n2 - n;
                    if (n7 < 4 || n4 - n3 < 2) {
                        if ((n8 &= 0xFF) > 244 || n7 > 1 && Decoder.isMalformed4_2(n8, byArray[n + 1] & 0xFF)) {
                            return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 1);
                        }
                        if (n7 > 2 && Decoder.isMalformed4_3(byArray[n + 2])) {
                            return Decoder.malformedForLength(byteBuffer, n, charBuffer, n3, 2);
                        }
                        return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 4);
                    }
                    by2 = byArray[n + 1];
                    by = byArray[n + 2];
                    c = byArray[n + 3];
                    int n9 = n8 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                    if (Decoder.isMalformed4(by2, by, c) || !Character.isSupplementaryCodePoint(n9)) {
                        return Decoder.malformed(byteBuffer, n, charBuffer, n3, 4);
                    }
                    cArray[n3++] = Character.highSurrogate(n9);
                    cArray[n3++] = Character.lowSurrogate(n9);
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, charBuffer, n3, 1);
            }
            return Decoder.xflow(byteBuffer, n, n2, charBuffer, n3, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = byteBuffer.limit();
            while (n < n2) {
                char c;
                byte by;
                byte by2;
                int n3;
                int n4 = byteBuffer.get();
                if (n4 >= 0) {
                    if (charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 1);
                    }
                    charBuffer.put((char)n4);
                    ++n;
                    continue;
                }
                if (n4 >> 5 == -2 && (n4 & 0x1E) != 0) {
                    if (n2 - n < 2 || charBuffer.remaining() < 1) {
                        return Decoder.xflow(byteBuffer, n, 2);
                    }
                    n3 = byteBuffer.get();
                    if (Decoder.isNotContinuation(n3)) {
                        return Decoder.malformedForLength(byteBuffer, n, 1);
                    }
                    charBuffer.put((char)(n4 << 6 ^ n3 ^ 0xF80));
                    n += 2;
                    continue;
                }
                if (n4 >> 4 == -2) {
                    n3 = n2 - n;
                    if (n3 < 3 || charBuffer.remaining() < 1) {
                        if (n3 > 1 && Decoder.isMalformed3_2(n4, byteBuffer.get())) {
                            return Decoder.malformedForLength(byteBuffer, n, 1);
                        }
                        return Decoder.xflow(byteBuffer, n, 3);
                    }
                    by2 = byteBuffer.get();
                    if (Decoder.isMalformed3(n4, by2, by = byteBuffer.get())) {
                        return Decoder.malformed(byteBuffer, n, 3);
                    }
                    c = (char)(n4 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return Decoder.malformedForLength(byteBuffer, n, 3);
                    }
                    charBuffer.put(c);
                    n += 3;
                    continue;
                }
                if (n4 >> 3 == -2) {
                    n3 = n2 - n;
                    if (n3 < 4 || charBuffer.remaining() < 2) {
                        if ((n4 &= 0xFF) > 244 || n3 > 1 && Decoder.isMalformed4_2(n4, byteBuffer.get() & 0xFF)) {
                            return Decoder.malformedForLength(byteBuffer, n, 1);
                        }
                        if (n3 > 2 && Decoder.isMalformed4_3(byteBuffer.get())) {
                            return Decoder.malformedForLength(byteBuffer, n, 2);
                        }
                        return Decoder.xflow(byteBuffer, n, 4);
                    }
                    by2 = byteBuffer.get();
                    by = byteBuffer.get();
                    c = byteBuffer.get();
                    int n5 = n4 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                    if (Decoder.isMalformed4(by2, by, c) || !Character.isSupplementaryCodePoint(n5)) {
                        return Decoder.malformed(byteBuffer, n, 4);
                    }
                    charBuffer.put(Character.highSurrogate(n5));
                    charBuffer.put(Character.lowSurrogate(n5));
                    n += 4;
                    continue;
                }
                return Decoder.malformed(byteBuffer, n, 1);
            }
            return Decoder.xflow(byteBuffer, n, 0);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult = null;
            Boolean bl = false;
            int n = charBuffer.position();
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                bl = true;
                coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            } else {
                bl = false;
                coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            }
            if (this.bidiEnabled) {
                int n2;
                int n3;
                char[] cArray;
                int n4 = charBuffer.position();
                if (bl.booleanValue()) {
                    cArray = charBuffer.array();
                    n3 = charBuffer.arrayOffset() + n;
                    n2 = charBuffer.arrayOffset() + n4;
                } else {
                    n3 = 0;
                    n2 = n4 - n;
                    cArray = new char[n2];
                    charBuffer.position(n);
                    charBuffer.get(cArray);
                    charBuffer.position(n4);
                }
                BidiConvert bidiConvert = new BidiConvert();
                if (bidiConvert.isBidiData(cArray, n3, n2, this.bidiParms, this.csName)) {
                    cArray = bidiConvert.toUnicode(cArray, n3, n2, this.bidiParms, this.csName);
                    if (bl.booleanValue()) {
                        System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n, cArray.length);
                    } else {
                        charBuffer.position(n);
                        charBuffer.put(cArray);
                    }
                }
            }
            return coderResult;
        }

        private static ByteBuffer getByteBuffer(ByteBuffer byteBuffer, byte[] byArray, int n) {
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.wrap(byArray);
            }
            byteBuffer.position(n);
            return byteBuffer;
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            int n3 = n + n2;
            int n4 = 0;
            int n5 = Math.min(n2, cArray.length);
            ByteBuffer byteBuffer = null;
            int n6 = this.decodeUTF_8(byArray, n, n5, cArray, n4);
            n += n6;
            n4 += n6;
            while (n < n3) {
                char c;
                byte by;
                byte by2;
                int n7;
                if ((n7 = byArray[n++]) >= 0) {
                    cArray[n4++] = (char)n7;
                    continue;
                }
                if (n7 >> 5 == -2 && (n7 & 0x1E) != 0) {
                    if (n < n3) {
                        if (Decoder.isNotContinuation(by2 = byArray[n++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            --n;
                            continue;
                        }
                        cArray[n4++] = (char)(n7 << 6 ^ by2 ^ 0xF80);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    cArray[n4++] = this.replacement().charAt(0);
                    this.bidiToUnicode(cArray, n4);
                    return n4;
                }
                if (n7 >> 4 == -2) {
                    if (n + 1 < n3) {
                        if (Decoder.isMalformed3(n7, by2 = byArray[n++], by = byArray[n++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, n -= 3);
                            n += Decoder.malformedN(byteBuffer, 3).length();
                            continue;
                        }
                        c = (char)(n7 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                        if (Character.isSurrogate(c)) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            continue;
                        }
                        cArray[n4++] = c;
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if (n < n3 && Decoder.isMalformed3_2(n7, byArray[n])) {
                        cArray[n4++] = this.replacement().charAt(0);
                        continue;
                    }
                    cArray[n4++] = this.replacement().charAt(0);
                    this.bidiToUnicode(cArray, n4);
                    return n4;
                }
                if (n7 >> 3 == -2) {
                    if (n + 2 < n3) {
                        by2 = byArray[n++];
                        by = byArray[n++];
                        c = byArray[n++];
                        int n8 = n7 << 18 ^ by2 << 12 ^ by << 6 ^ (c ^ 0x381F80);
                        if (Decoder.isMalformed4(by2, by, c) || !Character.isSupplementaryCodePoint(n8)) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            cArray[n4++] = this.replacement().charAt(0);
                            byteBuffer = Decoder.getByteBuffer(byteBuffer, byArray, n -= 4);
                            n += Decoder.malformedN(byteBuffer, 4).length();
                            continue;
                        }
                        cArray[n4++] = Character.highSurrogate(n8);
                        cArray[n4++] = Character.lowSurrogate(n8);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if ((n7 &= 0xFF) > 244 || n < n3 && Decoder.isMalformed4_2(n7, byArray[n] & 0xFF)) {
                        cArray[n4++] = this.replacement().charAt(0);
                        continue;
                    }
                    if (++n < n3 && Decoder.isMalformed4_3(byArray[n])) {
                        cArray[n4++] = this.replacement().charAt(0);
                        continue;
                    }
                    cArray[n4++] = this.replacement().charAt(0);
                    this.bidiToUnicode(cArray, n4);
                    return n4;
                }
                if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                    return -1;
                }
                cArray[n4++] = this.replacement().charAt(0);
            }
            this.bidiToUnicode(cArray, n4);
            return n4;
        }

        private void bidiToUnicode(char[] cArray, int n) {
            BidiConvert bidiConvert;
            if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, 0, n, this.bidiParms, this.csName)) {
                char[] cArray2 = bidiConvert.toUnicode(cArray, 0, n, this.bidiParms, this.csName);
                System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            }
        }

        public final int decodeUTF_8(byte[] byArray, int n, int n2, char[] cArray, int n3) {
            int n4 = 0;
            int n5 = n3 + n2;
            while (n3 < n5 && byArray[n] >= 0) {
                cArray[n3++] = (char)byArray[n++];
                ++n4;
            }
            return n4;
        }
    }
}

