/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ExtendedSocketOptions {
    public static final short SOCK_STREAM = 1;
    public static final short SOCK_DGRAM = 2;
    private final Set<SocketOption<?>> options;
    private final Set<SocketOption<?>> datagramOptions;
    private final Set<SocketOption<?>> clientStreamOptions;
    private final Set<SocketOption<?>> serverStreamOptions;
    private static volatile ExtendedSocketOptions instance;

    public final boolean isOptionSupported(SocketOption<?> socketOption) {
        return this.options().contains(socketOption);
    }

    public final Set<SocketOption<?>> options() {
        return this.options;
    }

    public static Set<SocketOption<?>> serverSocketOptions() {
        return ExtendedSocketOptions.getInstance().options0((short)1, true);
    }

    public static Set<SocketOption<?>> clientSocketOptions() {
        return ExtendedSocketOptions.getInstance().options0((short)1, false);
    }

    public static Set<SocketOption<?>> datagramSocketOptions() {
        return ExtendedSocketOptions.getInstance().options0((short)2, false);
    }

    private static boolean isDatagramOption(SocketOption<?> socketOption) {
        return !socketOption.name().startsWith("TCP_");
    }

    private static boolean isStreamOption(SocketOption<?> socketOption, boolean bl) {
        if (bl && "SO_FLOW_SLA".equals(socketOption.name())) {
            return false;
        }
        return !socketOption.name().startsWith("UDP_");
    }

    private Set<SocketOption<?>> options0(short s, boolean bl) {
        switch (s) {
            case 2: {
                return this.datagramOptions;
            }
            case 1: {
                if (bl) {
                    return this.serverStreamOptions;
                }
                return this.clientStreamOptions;
            }
        }
        throw new IllegalArgumentException("Invalid socket option type");
    }

    public abstract void setOption(FileDescriptor var1, SocketOption<?> var2, Object var3) throws SocketException;

    public abstract Object getOption(FileDescriptor var1, SocketOption<?> var2) throws SocketException;

    protected ExtendedSocketOptions(Set<SocketOption<?>> set) {
        this.options = set;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        for (SocketOption<?> socketOption : set) {
            if (ExtendedSocketOptions.isDatagramOption(socketOption)) {
                hashSet.add(socketOption);
            }
            if (ExtendedSocketOptions.isStreamOption(socketOption, true)) {
                hashSet2.add(socketOption);
            }
            if (!ExtendedSocketOptions.isStreamOption(socketOption, false)) continue;
            hashSet3.add(socketOption);
        }
        this.datagramOptions = new HashSet(hashSet);
        this.serverStreamOptions = new HashSet(hashSet2);
        this.clientStreamOptions = new HashSet(hashSet3);
    }

    public static final ExtendedSocketOptions getInstance() {
        return instance;
    }

    public static final void register(ExtendedSocketOptions extendedSocketOptions) {
        if (instance != null) {
            throw new InternalError("Attempting to reregister extended options");
        }
        instance = extendedSocketOptions;
    }

    static {
        try {
            Class<?> clazz = Class.forName("jdk.net.ExtendedSocketOptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            instance = new NoExtendedSocketOptions();
        }
    }

    static final class NoExtendedSocketOptions
    extends ExtendedSocketOptions {
        NoExtendedSocketOptions() {
            super(Collections.emptySet());
        }

        @Override
        public void setOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption, Object object) throws SocketException {
            throw new UnsupportedOperationException("no extended options: " + socketOption.name());
        }

        @Override
        public Object getOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption) throws SocketException {
            throw new UnsupportedOperationException("no extended options: " + socketOption.name());
        }
    }
}

