/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jdk.Exported;
import jdk.net.NetworkPermission;
import jdk.net.SocketFlow;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@Exported
public final class ExtendedSocketOptions {
    public static final SocketOption<SocketFlow> SO_FLOW_SLA = new ExtSocketOption<SocketFlow>("SO_FLOW_SLA", SocketFlow.class);
    public static final SocketOption<Integer> TCP_KEEPIDLE = new ExtSocketOption<Integer>("TCP_KEEPIDLE", Integer.class);
    public static final SocketOption<Integer> TCP_KEEPINTERVAL = new ExtSocketOption<Integer>("TCP_KEEPINTERVAL", Integer.class);
    public static final SocketOption<Integer> TCP_KEEPCOUNT = new ExtSocketOption<Integer>("TCP_KEEPCOUNT", Integer.class);
    private static final PlatformSocketOptions platformSocketOptions = PlatformSocketOptions.get();
    private static final boolean flowSupported = platformSocketOptions.flowSupported();
    private static final boolean keepAliveOptSupported = platformSocketOptions.keepAliveOptionsSupported();
    private static final Set<SocketOption<?>> extendedOptions = ExtendedSocketOptions.options();
    private static final JavaIOFileDescriptorAccess fdAccess;

    private ExtendedSocketOptions() {
    }

    static Set<SocketOption<?>> options() {
        HashSet<SocketOption<Object>> hashSet = new HashSet<SocketOption<Object>>();
        if (flowSupported) {
            hashSet.add(SO_FLOW_SLA);
        }
        if (keepAliveOptSupported) {
            hashSet.add(TCP_KEEPCOUNT);
            hashSet.add(TCP_KEEPIDLE);
            hashSet.add(TCP_KEEPINTERVAL);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static <T> T checkValueType(Object object, Class<T> clazz) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            String string = "Found: " + object.getClass() + ", Expected: " + clazz;
            throw new IllegalArgumentException(string);
        }
        return (T)object;
    }

    public static void setFlowOption(FileDescriptor fileDescriptor, SocketFlow socketFlow) throws SocketException {
        PlatformSocketOptions.get().setFlowOption(fdAccess.get(fileDescriptor), socketFlow);
    }

    public static void getFlowOption(FileDescriptor fileDescriptor, SocketFlow socketFlow) throws SocketException {
        PlatformSocketOptions.get().getFlowOption(fdAccess.get(fileDescriptor), socketFlow);
    }

    private static boolean flowSupported() {
        return PlatformSocketOptions.get().flowSupported();
    }

    private static boolean keepAliveOptionsSupported() {
        return PlatformSocketOptions.get().keepAliveOptionsSupported();
    }

    private static void setTcpkeepAliveProbes(FileDescriptor fileDescriptor, int n) throws SocketException {
        PlatformSocketOptions.get().setTcpkeepAliveProbes(fdAccess.get(fileDescriptor), n);
    }

    private static void setTcpKeepAliveTime(FileDescriptor fileDescriptor, int n) throws SocketException {
        PlatformSocketOptions.get().setTcpKeepAliveTime(fdAccess.get(fileDescriptor), n);
    }

    private static void setTcpKeepAliveIntvl(FileDescriptor fileDescriptor, int n) throws SocketException {
        PlatformSocketOptions.get().setTcpKeepAliveIntvl(fdAccess.get(fileDescriptor), n);
    }

    private static int getTcpkeepAliveProbes(FileDescriptor fileDescriptor) throws SocketException {
        return PlatformSocketOptions.get().getTcpkeepAliveProbes(fdAccess.get(fileDescriptor));
    }

    private static int getTcpKeepAliveTime(FileDescriptor fileDescriptor) throws SocketException {
        return PlatformSocketOptions.get().getTcpKeepAliveTime(fdAccess.get(fileDescriptor));
    }

    private static int getTcpKeepAliveIntvl(FileDescriptor fileDescriptor) throws SocketException {
        return PlatformSocketOptions.get().getTcpKeepAliveIntvl(fdAccess.get(fileDescriptor));
    }

    static {
        sun.net.ExtendedSocketOptions.register(new sun.net.ExtendedSocketOptions((Set)extendedOptions){

            @Override
            public void setOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption, Object object) throws SocketException {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new NetworkPermission("setOption." + socketOption.name()));
                }
                if (fileDescriptor == null || !fileDescriptor.valid()) {
                    throw new SocketException("socket closed");
                }
                if (socketOption == SO_FLOW_SLA) {
                    assert (flowSupported);
                    SocketFlow socketFlow = (SocketFlow)ExtendedSocketOptions.checkValueType(object, SocketFlow.class);
                    ExtendedSocketOptions.setFlowOption(fileDescriptor, socketFlow);
                } else if (socketOption == TCP_KEEPCOUNT) {
                    ExtendedSocketOptions.setTcpkeepAliveProbes(fileDescriptor, (Integer)object);
                } else if (socketOption == TCP_KEEPIDLE) {
                    ExtendedSocketOptions.setTcpKeepAliveTime(fileDescriptor, (Integer)object);
                } else if (socketOption == TCP_KEEPINTERVAL) {
                    ExtendedSocketOptions.setTcpKeepAliveIntvl(fileDescriptor, (Integer)object);
                } else {
                    throw new InternalError("Unexpected option " + socketOption);
                }
            }

            @Override
            public Object getOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption) throws SocketException {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new NetworkPermission("getOption." + socketOption.name()));
                }
                if (fileDescriptor == null || !fileDescriptor.valid()) {
                    throw new SocketException("socket closed");
                }
                if (socketOption == SO_FLOW_SLA) {
                    assert (flowSupported);
                    SocketFlow socketFlow = SocketFlow.create();
                    ExtendedSocketOptions.getFlowOption(fileDescriptor, socketFlow);
                    return socketFlow;
                }
                if (socketOption == TCP_KEEPCOUNT) {
                    return ExtendedSocketOptions.getTcpkeepAliveProbes(fileDescriptor);
                }
                if (socketOption == TCP_KEEPIDLE) {
                    return ExtendedSocketOptions.getTcpKeepAliveTime(fileDescriptor);
                }
                if (socketOption == TCP_KEEPINTERVAL) {
                    return ExtendedSocketOptions.getTcpKeepAliveIntvl(fileDescriptor);
                }
                throw new InternalError("Unexpected option " + socketOption);
            }
        });
        fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    }

    static class PlatformSocketOptions {
        private static final PlatformSocketOptions instance = PlatformSocketOptions.create();

        protected PlatformSocketOptions() {
        }

        private static PlatformSocketOptions newInstance(String string) {
            try {
                Class<?> clazz = Class.forName(string);
                return (PlatformSocketOptions)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }

        private static PlatformSocketOptions create() {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.name");
                }
            });
            if ("SunOS".equals(string)) {
                return PlatformSocketOptions.newInstance("jdk.net.SolarisSocketOptions");
            }
            if ("Linux".equals(string)) {
                return PlatformSocketOptions.newInstance("jdk.net.LinuxSocketOptions");
            }
            if (string.startsWith("Mac")) {
                return PlatformSocketOptions.newInstance("jdk.net.MacOSXSocketOptions");
            }
            if ("AIX".equals(string)) {
                return PlatformSocketOptions.newInstance("jdk.net.AixSocketOptions");
            }
            return new PlatformSocketOptions();
        }

        static PlatformSocketOptions get() {
            return instance;
        }

        void init() {
        }

        int setFlowOption(int n, SocketFlow socketFlow) throws SocketException {
            throw new UnsupportedOperationException("unsupported socket option");
        }

        int getFlowOption(int n, SocketFlow socketFlow) throws SocketException {
            throw new UnsupportedOperationException("unsupported socket option");
        }

        boolean flowSupported() {
            return false;
        }

        boolean keepAliveOptionsSupported() {
            return false;
        }

        void setTcpkeepAliveProbes(int n, int n2) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPCNT option");
        }

        void setTcpKeepAliveTime(int n, int n2) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPIDLE option");
        }

        void setTcpKeepAliveIntvl(int n, int n2) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPINTVL option");
        }

        int getTcpkeepAliveProbes(int n) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPCNT option");
        }

        int getTcpKeepAliveTime(int n) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPIDLE option");
        }

        int getTcpKeepAliveIntvl(int n) throws SocketException {
            throw new UnsupportedOperationException("unsupported TCP_KEEPINTVL option");
        }
    }

    private static class ExtSocketOption<T>
    implements SocketOption<T> {
        private final String name;
        private final Class<T> type;

        ExtSocketOption(String string, Class<T> clazz) {
            this.name = string;
            this.type = clazz;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<T> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

